/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.client;

import gavinx.temperatureapi.api.TemperatureResistanceAPI;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

@Environment(value=EnvType.CLIENT)
public final class TooltipHandler {
    private static final int HEAT_COLOR_T1 = 13447216;
    private static final int HEAT_COLOR_T6 = 0xB00000;
    private static final int COLD_COLOR_T1 = 5094129;
    private static final int COLD_COLOR_T6 = 37340;

    private TooltipHandler() {
    }

    public static void register() {
        ItemTooltipCallback.EVENT.register(TooltipHandler::onTooltip);
    }

    private static void onTooltip(class_1799 stack, class_1836 context, List<class_2561> lines) {
        class_5250 line;
        int color;
        int tier;
        boolean hasCold;
        if (stack == null || stack.method_7960()) {
            return;
        }
        if (!TemperatureResistanceAPI.AUTO_TOOLTIPS_ENABLED) {
            return;
        }
        TemperatureResistanceAPI.Resistance r = TemperatureResistanceAPI.stackResistance(stack);
        if (r == null) {
            return;
        }
        boolean hasHeat = r.heatC > 0.0;
        boolean bl = hasCold = r.coldC > 0.0;
        if (!hasHeat && !hasCold) {
            return;
        }
        if (hasHeat) {
            tier = TooltipHandler.clampTier((int)Math.round(r.heatC / 2.0));
            color = TooltipHandler.lerpColor(13447216, 0xB00000, TooltipHandler.tierProgress(tier));
            line = class_2561.method_43470((String)String.format("Heat Resistance: +%.0f\u00b0C", r.heatC)).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)color)));
            lines.add((class_2561)line);
        }
        if (hasCold) {
            tier = TooltipHandler.clampTier((int)Math.round(r.coldC / 2.0));
            color = TooltipHandler.lerpColor(5094129, 37340, TooltipHandler.tierProgress(tier));
            line = class_2561.method_43470((String)String.format("Cold Resistance: +%.0f\u00b0C", r.coldC)).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)color)));
            lines.add((class_2561)line);
        }
    }

    private static int clampTier(int t) {
        if (t < 1) {
            return 1;
        }
        if (t > 6) {
            return 6;
        }
        return t;
    }

    private static float tierProgress(int tier) {
        return (float)(tier - 1) / 5.0f;
    }

    private static int lerpColor(int a, int b, float t) {
        t = Math.max(0.0f, Math.min(1.0f, t));
        int ar = a >> 16 & 0xFF;
        int ag = a >> 8 & 0xFF;
        int ab = a & 0xFF;
        int br = b >> 16 & 0xFF;
        int bg = b >> 8 & 0xFF;
        int bb = b & 0xFF;
        int rr = (int)((float)ar + (float)(br - ar) * t);
        int rg = (int)((float)ag + (float)(bg - ag) * t);
        int rb = (int)((float)ab + (float)(bb - ab) * t);
        return rr << 16 | rg << 8 | rb;
    }
}

