/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import gavinx.temperatureapi.api.biome.BiomeAPI;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;

public final class HumidityAPI {
    private HumidityAPI() {
    }

    public static String getHumidity(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return "N/A";
        }
        int value = HumidityAPI.getHumidityValue(world, pos);
        return value < 0 ? "N/A" : value + "%";
    }

    public static String getHumidity(class_1657 player) {
        if (player == null) {
            return "N/A";
        }
        return HumidityAPI.getHumidity(player.method_37908(), player.method_24515());
    }

    public static int getHumidityValue(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return -1;
        }
        return HumidityAPI.resolveHumidity(world, pos);
    }

    public static int getHumidityValue(class_1657 player) {
        if (player == null) {
            return -1;
        }
        return HumidityAPI.getHumidityValue(player.method_37908(), player.method_24515());
    }

    private static int resolveHumidity(class_1937 world, class_2338 pos) {
        Optional<BiomeAPI.CustomBiome> custom;
        class_6880 entry = world.method_23753(pos);
        String key = BiomeAPI.keyFor((class_6880<class_1959>)entry);
        if (key != null && (custom = BiomeAPI.get(key)).isPresent()) {
            return HumidityAPI.clamp0to100(custom.get().humidity);
        }
        class_1959 biome = (class_1959)entry.comp_349();
        class_1959.class_1963 p = biome.method_48162(pos);
        int percent = p == class_1959.class_1963.field_9384 ? 10 : (p == class_1959.class_1963.field_9383 ? 50 : 65);
        return HumidityAPI.clamp0to100(percent);
    }

    private static int clamp0to100(int v) {
        return Math.max(0, Math.min(100, v));
    }
}

