/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import gavinx.temperatureapi.api.DayNightAPI;
import gavinx.temperatureapi.api.SeasonsAPI;
import gavinx.temperatureapi.api.biome.BiomeAPI;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_6880;

public final class TemperatureAPI {
    private TemperatureAPI() {
    }

    public static String getTemperature(class_1937 world, class_2338 pos, Unit unit) {
        if (world == null || pos == null || unit == null) {
            return "N/A";
        }
        double celsius = TemperatureAPI.resolveBiomeTemperatureCelsius(world, pos);
        double value = unit == Unit.FAHRENHEIT ? TemperatureAPI.cToF(celsius) : celsius;
        String suffix = unit == Unit.FAHRENHEIT ? "\u00b0F" : "\u00b0C";
        return String.format("%.1f%s", value, suffix);
    }

    public static String getTemperature(class_1937 world, class_2338 pos, boolean fahrenheit) {
        return TemperatureAPI.getTemperature(world, pos, fahrenheit ? Unit.FAHRENHEIT : Unit.CELSIUS);
    }

    public static String getTemperature(class_1937 world, class_2338 pos, String unit) {
        Unit parsed = TemperatureAPI.parseUnit(unit);
        return TemperatureAPI.getTemperature(world, pos, parsed);
    }

    public static String getTemperature(class_1657 player, Unit unit) {
        if (player == null || unit == null) {
            return "N/A";
        }
        return TemperatureAPI.getTemperature(player.method_37908(), player.method_24515(), unit);
    }

    public static String getTemperature(class_1657 player, boolean fahrenheit) {
        return TemperatureAPI.getTemperature(player, fahrenheit ? Unit.FAHRENHEIT : Unit.CELSIUS);
    }

    public static String getTemperature(class_1657 player, String unit) {
        return TemperatureAPI.getTemperature(player, TemperatureAPI.parseUnit(unit));
    }

    public static double getTemperatureCelsius(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            return Double.NaN;
        }
        return TemperatureAPI.resolveBiomeTemperatureCelsius(world, pos);
    }

    public static double getTemperatureCelsius(class_1657 player) {
        if (player == null) {
            return Double.NaN;
        }
        return TemperatureAPI.getTemperatureCelsius(player.method_37908(), player.method_24515());
    }

    private static double resolveBiomeTemperatureCelsius(class_1937 world, class_2338 pos) {
        Optional<BiomeAPI.CustomBiome> custom;
        class_6880 entry = world.method_23753(pos);
        String key = BiomeAPI.keyFor((class_6880<class_1959>)entry);
        double baseC = key != null ? ((custom = BiomeAPI.get(key)).isPresent() ? custom.get().temperature : (double)((class_1959)entry.comp_349()).method_8712()) : (double)((class_1959)entry.comp_349()).method_8712();
        double seasonalOffset = SeasonsAPI.temperatureOffsetC(world, pos);
        double diurnalOffset = DayNightAPI.temperatureOffsetC(world, pos);
        return baseC + seasonalOffset + diurnalOffset;
    }

    private static double cToF(double c) {
        return c * 9.0 / 5.0 + 32.0;
    }

    private static Unit parseUnit(String unit) {
        if (unit == null) {
            return Unit.CELSIUS;
        }
        String u = unit.trim().toUpperCase();
        if (u.equals("F") || u.equals("FAHRENHEIT")) {
            return Unit.FAHRENHEIT;
        }
        return Unit.CELSIUS;
    }

    public static enum Unit {
        CELSIUS,
        FAHRENHEIT;

    }
}

