/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api.biome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import gavinx.temperatureapi.TemperatureApi;
import gavinx.temperatureapi.api.biome.BopDefaults;
import gavinx.temperatureapi.api.biome.DefaultBiomes;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public final class BiomeAPI {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DEFAULT_DIR = "temperatureapi";
    private static final String DEFAULT_FILE = "biomes.json";
    private static Path configPath;
    private static Map<String, CustomBiome> registry;
    private static Map<String, CustomBiome> defaults;
    private static Map<String, CustomBiome> bopDefaults;

    private BiomeAPI() {
    }

    public static void setConfigPath(Path path) {
        configPath = path;
    }

    public static Path getConfigPath() {
        if (configPath != null) {
            return configPath;
        }
        Path cfgDir = FabricLoader.getInstance().getConfigDir().resolve(DEFAULT_DIR);
        return cfgDir.resolve(DEFAULT_FILE);
    }

    public static void load() {
        Path path = BiomeAPI.getConfigPath();
        BiomeAPI.ensureParentDir(path);
        HashMap<String, CustomBiome> merged = new HashMap<String, CustomBiome>();
        int resourceFiles = 0;
        int resourceEntries = 0;
        try {
            ClassLoader cl = BiomeAPI.class.getClassLoader();
            Enumeration<URL> urls = cl.getResources("temperatureapi/biomes.json");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                ++resourceFiles;
                try {
                    InputStream in = url.openStream();
                    try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                        JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                        if (root != null && root.isJsonArray()) {
                            JsonArray arr = root.getAsJsonArray();
                            for (JsonElement el : arr) {
                                if (!el.isJsonObject()) continue;
                                JsonObject obj = el.getAsJsonObject();
                                String biome = BiomeAPI.getAsString(obj, "biome", null);
                                Double temp = BiomeAPI.getAsDouble(obj, "temperature", null);
                                Integer hum = BiomeAPI.getAsInt(obj, "humidity", null);
                                if (biome == null || temp == null || hum == null) continue;
                                merged.put(biome, new CustomBiome(biome, temp, hum));
                                ++resourceEntries;
                            }
                            continue;
                        }
                        TemperatureApi.LOGGER.warn("Ignoring non-array TemperatureAPI resource at {}", (Object)url);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (Exception e) {
                    TemperatureApi.LOGGER.warn("Failed to read TemperatureAPI resource {}: {}", (Object)url, (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            TemperatureApi.LOGGER.debug("No TemperatureAPI classpath contributions found: {}", (Object)e.getMessage());
        }
        if (!Files.exists(path, new LinkOption[0])) {
            BiomeAPI.writeSample(path);
        }
        int externalEntries = 0;
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            if (root == null || !root.isJsonArray()) {
                throw new JsonParseException("Root must be a JSON array of biome entries");
            }
            JsonArray arr = root.getAsJsonArray();
            for (JsonElement el : arr) {
                if (!el.isJsonObject()) continue;
                JsonObject obj = el.getAsJsonObject();
                String biome = BiomeAPI.getAsString(obj, "biome", null);
                Double temp = BiomeAPI.getAsDouble(obj, "temperature", null);
                Integer hum = BiomeAPI.getAsInt(obj, "humidity", null);
                if (biome == null || temp == null || hum == null) continue;
                merged.put(biome, new CustomBiome(biome, temp, hum));
                ++externalEntries;
            }
        }
        catch (Exception e) {
            TemperatureApi.LOGGER.error("Failed to load biome config from {}: {}", (Object)path, (Object)e.getMessage());
        }
        registry = Collections.unmodifiableMap(merged);
        HashMap<String, CustomBiome> combined = new HashMap<String, CustomBiome>(DefaultBiomes.defaults());
        bopDefaults = BopDefaults.defaults();
        combined.putAll(bopDefaults);
        defaults = Collections.unmodifiableMap(combined);
        TemperatureApi.LOGGER.info("BiomeAPI loaded: {} classpath files ({} entries), {} external entries, {} defaults ({} BOP)", new Object[]{resourceFiles, resourceEntries, externalEntries, defaults.size(), bopDefaults.size()});
    }

    public static Optional<CustomBiome> get(String key) {
        CustomBiome v = registry.get(key);
        if (v != null) {
            return Optional.of(v);
        }
        return Optional.ofNullable(defaults.get(key));
    }

    public static String keyFor(class_6880<class_1959> biomeEntry) {
        class_2960 id = biomeEntry.method_40230().map(k -> k.method_29177()).orElse(null);
        if (id == null) {
            return null;
        }
        return "biome." + id.method_12836() + "." + id.method_12832().replace('/', '.');
    }

    private static void ensureParentDir(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            TemperatureApi.LOGGER.warn("Could not create config directory for {}: {}", (Object)path, (Object)e.getMessage());
        }
    }

    private static void writeSample(Path path) {
        JsonArray arr = new JsonArray();
        arr.add((JsonElement)BiomeAPI.sampleEntry("biome.minecraft.plains", 22.0, 40));
        arr.add((JsonElement)BiomeAPI.sampleEntry("biome.minecraft.desert", 38.0, 5));
        arr.add((JsonElement)BiomeAPI.sampleEntry("biome.minecraft.snowy_plains", -5.0, 60));
        try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)arr, (Appendable)w);
            TemperatureApi.LOGGER.info("Wrote sample biome config to {}", (Object)path);
        }
        catch (IOException e) {
            TemperatureApi.LOGGER.warn("Failed to write sample biome config to {}: {}", (Object)path, (Object)e.getMessage());
        }
    }

    private static JsonObject sampleEntry(String key, double temp, int humidity) {
        JsonObject obj = new JsonObject();
        obj.addProperty("biome", key);
        obj.addProperty("temperature", (Number)temp);
        obj.addProperty("humidity", (Number)humidity);
        return obj;
    }

    private static String getAsString(JsonObject o, String k, String def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsString() : def;
    }

    private static Double getAsDouble(JsonObject o, String k, Double def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsDouble() : def.doubleValue();
    }

    private static Integer getAsInt(JsonObject o, String k, Integer def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsInt() : def.intValue();
    }

    static {
        registry = Collections.emptyMap();
        defaults = Collections.emptyMap();
        bopDefaults = Collections.emptyMap();
    }

    public static final class CustomBiome {
        public final String key;
        public final double temperature;
        public final int humidity;

        public CustomBiome(String key, double temperature, int humidity) {
            this.key = key;
            this.temperature = temperature;
            this.humidity = Math.max(0, Math.min(100, humidity));
        }
    }
}

