/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public final class TemperatureResistanceAPI {
    public static final String NBT_RESISTANCE = "tempapi_resistance";
    public static final double DEFAULT_MAX_HEAT_RESIST_C = 48.0;
    public static final double DEFAULT_MAX_COLD_RESIST_C = 48.0;
    private static final List<ResistanceProvider> PROVIDERS = new ArrayList<ResistanceProvider>();

    private TemperatureResistanceAPI() {
    }

    public static void registerProvider(ResistanceProvider provider) {
        if (provider != null) {
            PROVIDERS.add(provider);
        }
    }

    public static Resistance computeTotal(class_1657 player) {
        if (player == null) {
            return new Resistance(0.0, 0.0);
        }
        double heat = 0.0;
        double cold = 0.0;
        heat += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6169)).heatC;
        cold += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6169)).coldC;
        heat += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6174)).heatC;
        cold += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6174)).coldC;
        heat += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6172)).heatC;
        cold += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6172)).coldC;
        heat += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6166)).heatC;
        cold += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6166)).coldC;
        heat += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6173)).heatC;
        cold += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6173)).coldC;
        heat += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6171)).heatC;
        cold += TemperatureResistanceAPI.stackResistance((class_1799)player.method_6118((class_1304)class_1304.field_6171)).coldC;
        for (ResistanceProvider rp : PROVIDERS) {
            try {
                Resistance extra = rp.get(player);
                if (extra == null) continue;
                heat += Math.max(0.0, extra.heatC);
                cold += Math.max(0.0, extra.coldC);
            }
            catch (Throwable throwable) {}
        }
        heat = Math.min(48.0, heat);
        cold = Math.min(48.0, cold);
        return new Resistance(heat, cold);
    }

    public static double tierToDegrees(int tier) {
        int abs = Math.abs(tier);
        return abs >= 1 && abs <= 6 ? (double)abs * 2.0 : 0.0;
    }

    public static Resistance stackResistance(class_1799 stack) {
        String[] parts;
        String spec;
        if (stack == null || stack.method_7960()) {
            return new Resistance(0.0, 0.0);
        }
        class_2487 tag = stack.method_7969();
        if (tag == null || !tag.method_10545(NBT_RESISTANCE)) {
            return new Resistance(0.0, 0.0);
        }
        try {
            spec = tag.method_10558(NBT_RESISTANCE);
        }
        catch (Throwable t) {
            return new Resistance(0.0, 0.0);
        }
        if (spec == null) {
            return new Resistance(0.0, 0.0);
        }
        if ((spec = spec.trim()).isEmpty()) {
            return new Resistance(0.0, 0.0);
        }
        double heat = 0.0;
        double cold = 0.0;
        for (String p : parts = spec.split("[\\s,;]+")) {
            int tier;
            int colon;
            String s;
            if (p == null || (s = p.trim()).isEmpty() || (colon = s.indexOf(58)) <= 0 || colon >= s.length() - 1) continue;
            String key = s.substring(0, colon).trim().toLowerCase();
            String val = s.substring(colon + 1).trim();
            try {
                tier = Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            if (tier < 1) {
                tier = 1;
            }
            if (tier > 6) {
                tier = 6;
            }
            double deg = TemperatureResistanceAPI.tierToDegrees(tier);
            if ("heat".equals(key)) {
                heat += deg;
                continue;
            }
            if (!"cold".equals(key)) continue;
            cold += deg;
        }
        return new Resistance(heat, cold);
    }

    public static double stackHeatC(class_1799 stack) {
        return TemperatureResistanceAPI.stackResistance((class_1799)stack).heatC;
    }

    public static double stackColdC(class_1799 stack) {
        return TemperatureResistanceAPI.stackResistance((class_1799)stack).coldC;
    }

    public static final class Resistance {
        public final double heatC;
        public final double coldC;

        public Resistance(double heatC, double coldC) {
            this.heatC = Math.max(0.0, heatC);
            this.coldC = Math.max(0.0, coldC);
        }

        public Resistance add(Resistance other) {
            if (other == null) {
                return this;
            }
            return new Resistance(this.heatC + other.heatC, this.coldC + other.coldC);
        }

        public String toString() {
            return "Resistance{" + this.heatC + "C heat, " + this.coldC + "C cold}";
        }
    }

    @FunctionalInterface
    public static interface ResistanceProvider {
        public Resistance get(class_1657 var1);
    }
}

