/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2533;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public final class BlockThermalAPI {
    private static final Map<class_2248, ThermalSource> SIMPLE = new ConcurrentHashMap<class_2248, ThermalSource>();
    private static final List<Provider> PROVIDERS = new ArrayList<Provider>();
    private static volatile int MAX_SOURCE_RANGE = 0;

    private BlockThermalAPI() {
    }

    public static boolean isOutside(class_1937 world, class_2338 source) {
        if (world == null || source == null) {
            return false;
        }
        if (!world.method_8597().comp_642()) {
            return false;
        }
        return BlockThermalAPI.stepsToOutside(world, source, 32) >= 0;
    }

    public static int stepsToOutside(class_1937 world, class_2338 source, int budget) {
        if (world == null || source == null) {
            return -1;
        }
        if (!world.method_8597().comp_642()) {
            return -1;
        }
        return Exposure.stepsToOutside(world, source, Math.max(0, budget));
    }

    public static boolean isOutside(class_1937 world, class_2338 source, class_2350 face) {
        if (world == null || source == null || face == null) {
            return false;
        }
        if (!world.method_8597().comp_642()) {
            return false;
        }
        return BlockThermalAPI.stepsToOutside(world, source, 32, face) >= 0;
    }

    public static int stepsToOutside(class_1937 world, class_2338 source, int budget, class_2350 face) {
        if (world == null || source == null || face == null) {
            return -1;
        }
        if (!world.method_8597().comp_642()) {
            return -1;
        }
        return Exposure.stepsToOutsideViaFace(world, source, Math.max(0, budget), face);
    }

    public static double outdoorExposure(class_1937 world, class_2338 source, int budget) {
        if (world == null || source == null || !world.method_8597().comp_642()) {
            return 0.0;
        }
        int steps = BlockThermalAPI.stepsToOutside(world, source, budget);
        if (steps < 0) {
            return 0.0;
        }
        if (steps == 0) {
            return 1.0;
        }
        double t = 1.0 - Math.min(1.0, (double)steps / (double)Math.max(1, budget));
        return Math.max(0.0, Math.min(1.0, t));
    }

    public static double outdoorExposure(class_1937 world, class_2338 source, int budget, class_2350 face) {
        if (world == null || source == null || face == null || !world.method_8597().comp_642()) {
            return 0.0;
        }
        int steps = BlockThermalAPI.stepsToOutside(world, source, budget, face);
        if (steps < 0) {
            return 0.0;
        }
        if (steps == 0) {
            return 1.0;
        }
        double t = 1.0 - Math.min(1.0, (double)steps / (double)Math.max(1, budget));
        return Math.max(0.0, Math.min(1.0, t));
    }

    public static void register(class_2248 block, double deltaC, int range) {
        Objects.requireNonNull(block, "block");
        ThermalSource ts = new ThermalSource(deltaC, range);
        SIMPLE.put(block, ts);
        int influence = ts.influenceRadius();
        if (influence > MAX_SOURCE_RANGE) {
            MAX_SOURCE_RANGE = influence;
        }
    }

    public static void register(class_2248 block, double deltaC, int range, OcclusionMode occlusion) {
        Objects.requireNonNull(block, "block");
        ThermalSource ts = new ThermalSource(deltaC, range, occlusion);
        SIMPLE.put(block, ts);
        int influence = ts.influenceRadius();
        if (influence > MAX_SOURCE_RANGE) {
            MAX_SOURCE_RANGE = influence;
        }
    }

    public static void register(class_2248 block, double deltaC, int range, OcclusionMode occlusion, int dropoffBlocks) {
        Objects.requireNonNull(block, "block");
        ThermalSource ts = new ThermalSource(deltaC, range, occlusion, dropoffBlocks, FalloffCurve.COSINE, null);
        SIMPLE.put(block, ts);
        int influence = ts.influenceRadius();
        if (influence > MAX_SOURCE_RANGE) {
            MAX_SOURCE_RANGE = influence;
        }
    }

    public static void register(class_2248 block, double deltaC, int range, class_2350 face) {
        Objects.requireNonNull(block, "block");
        ThermalSource ts = new ThermalSource(deltaC, range, OcclusionMode.FLOOD_FILL, 7, FalloffCurve.COSINE, face);
        SIMPLE.put(block, ts);
        int influence = ts.influenceRadius();
        if (influence > MAX_SOURCE_RANGE) {
            MAX_SOURCE_RANGE = influence;
        }
    }

    public static void register(class_2248 block, double deltaC, int range, OcclusionMode occlusion, class_2350 face) {
        Objects.requireNonNull(block, "block");
        ThermalSource ts = new ThermalSource(deltaC, range, occlusion, 7, FalloffCurve.COSINE, face);
        SIMPLE.put(block, ts);
        int influence = ts.influenceRadius();
        if (influence > MAX_SOURCE_RANGE) {
            MAX_SOURCE_RANGE = influence;
        }
    }

    public static void register(class_2248 block, double deltaC, int range, OcclusionMode occlusion, int dropoffBlocks, class_2350 face) {
        Objects.requireNonNull(block, "block");
        ThermalSource ts = new ThermalSource(deltaC, range, occlusion, dropoffBlocks, FalloffCurve.COSINE, face);
        SIMPLE.put(block, ts);
        int influence = ts.influenceRadius();
        if (influence > MAX_SOURCE_RANGE) {
            MAX_SOURCE_RANGE = influence;
        }
    }

    public static void register(Provider provider) {
        if (provider != null) {
            PROVIDERS.add(provider);
        }
    }

    public static void register(Provider provider, int maxRangeHint) {
        if (provider != null) {
            PROVIDERS.add(provider);
            if (maxRangeHint > MAX_SOURCE_RANGE) {
                MAX_SOURCE_RANGE = Math.max(0, maxRangeHint);
            }
        }
    }

    public static void setGlobalMaxRangeHint(int maxRange) {
        if (maxRange > MAX_SOURCE_RANGE) {
            MAX_SOURCE_RANGE = Math.max(0, maxRange);
        }
    }

    public static double temperatureOffsetC(class_1937 world, class_2338 atPos) {
        if (world == null || atPos == null) {
            return 0.0;
        }
        double cached = Cache.get(world, atPos);
        if (!Double.isNaN(cached)) {
            return cached;
        }
        int maxR = Math.max(0, MAX_SOURCE_RANGE);
        if (maxR == 0 && PROVIDERS.isEmpty()) {
            Cache.put(world, atPos, 0.0);
            return 0.0;
        }
        double sum = 0.0;
        for (int dx = -maxR; dx <= maxR; ++dx) {
            for (int dy = -maxR; dy <= maxR; ++dy) {
                for (int dz = -maxR; dz <= maxR; ++dz) {
                    ThermalSource ts;
                    class_2338 bp = atPos.method_10069(dx, dy, dz);
                    class_2680 state = world.method_8320(bp);
                    if (state.method_26215() || (ts = BlockThermalAPI.resolve(world, bp, state)) == null || ts.range <= 0 || ts.deltaC == 0.0) continue;
                    int drop = ts.dropoffBlocks;
                    int budget = ts.range + drop;
                    double euclid = atPos.method_46558().method_1022(bp.method_46558());
                    if (euclid > (double)budget + 0.5) continue;
                    if (ts.face != null && !bp.equals((Object)atPos)) {
                        class_243 src = bp.method_46558();
                        class_243 tgt = atPos.method_46558();
                        class_243 diff = tgt.method_1020(src);
                        class_2350 f = ts.face;
                        double dot = diff.field_1352 * (double)f.method_10148() + diff.field_1351 * (double)f.method_10164() + diff.field_1350 * (double)f.method_10165();
                        if (dot <= 0.0) continue;
                    }
                    if (BlockThermalAPI.isFullySealed(world, bp)) continue;
                    double contrib = 0.0;
                    if (ts.occlusion == OcclusionMode.FLOOD_FILL) {
                        int steps = ts.face != null ? FloodFill.stepsToViaFace(world, bp, atPos, budget, ts.face) : FloodFill.stepsTo(world, bp, atPos, budget);
                        if (steps < 0) continue;
                        if (steps <= ts.range) {
                            contrib = ts.deltaC;
                        } else {
                            if (drop <= 0) continue;
                            int over = Math.max(0, steps - ts.range);
                            double t = Math.min(1.0, (double)over / (double)drop);
                            contrib = ts.deltaC * BlockThermalAPI.weight(ts.curve, t);
                        }
                    } else {
                        boolean clear;
                        boolean bl = clear = atPos.equals((Object)bp) || BlockThermalAPI.hasLineOfSight(world, atPos, bp);
                        if (!clear) continue;
                        if (euclid <= (double)ts.range + 0.5) {
                            contrib = ts.deltaC;
                        } else {
                            if (drop <= 0) continue;
                            double over = Math.max(0.0, euclid - (double)ts.range);
                            double t = Math.min(1.0, over / (double)drop);
                            contrib = ts.deltaC * BlockThermalAPI.weight(ts.curve, t);
                        }
                    }
                    sum += contrib;
                }
            }
        }
        Cache.put(world, atPos, sum);
        return sum;
    }

    private static ThermalSource resolve(class_1937 world, class_2338 pos, class_2680 state) {
        ThermalSource ts = SIMPLE.get(state.method_26204());
        if (ts != null) {
            return ts;
        }
        if (!PROVIDERS.isEmpty()) {
            for (Provider p : PROVIDERS) {
                try {
                    ThermalSource dyn = p.get(world, pos, state);
                    if (dyn == null) continue;
                    int influence = dyn.influenceRadius();
                    if (influence > MAX_SOURCE_RANGE) {
                        MAX_SOURCE_RANGE = influence;
                    }
                    if (dyn.deltaC == 0.0 || dyn.range <= 0) continue;
                    return dyn;
                }
                catch (Throwable throwable) {
                }
            }
        }
        return null;
    }

    private static boolean hasLineOfSight(class_1937 world, class_2338 from, class_2338 to) {
        if (from.equals((Object)to)) {
            return true;
        }
        class_243 start = from.method_46558();
        class_243 end = to.method_46558();
        try {
            class_3959 ctx = new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, null);
            class_3965 hit = world.method_17742(ctx);
            if (hit == null) {
                return false;
            }
            if (hit.method_17783() == class_239.class_240.field_1333) {
                return true;
            }
            class_2338 hitPos = hit.method_17777();
            return hitPos != null && hitPos.equals((Object)to);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static boolean isFullySealed(class_1937 world, class_2338 source) {
        for (class_2350 d : class_2350.values()) {
            class_2680 st;
            class_2338 np = source.method_10093(d);
            if (!BlockThermalAPI.isPassable(world, np, st = world.method_8320(np))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasPassableSkyColumn(class_1937 world, class_2338 pos) {
        try {
            if (!world.method_8311(pos)) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int top = world.method_31600();
        for (int y = pos.method_10264(); y < top; ++y) {
            class_2680 st;
            class_2338 p = new class_2338(pos.method_10263(), y, pos.method_10260());
            if (BlockThermalAPI.isPassable(world, p, st = world.method_8320(p))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPassable(class_1937 world, class_2338 pos, class_2680 state) {
        if (state.method_26215()) {
            return true;
        }
        try {
            if (state.method_26220((class_1922)world, pos).method_1110()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (state.method_26204() instanceof class_2323 && state.method_28498((class_2769)class_2323.field_10945) && ((Boolean)state.method_11654((class_2769)class_2323.field_10945)).booleanValue()) {
                return true;
            }
            if (state.method_26204() instanceof class_2349 && state.method_28498((class_2769)class_2349.field_11026) && ((Boolean)state.method_11654((class_2769)class_2349.field_11026)).booleanValue()) {
                return true;
            }
            if (state.method_26204() instanceof class_2533 && state.method_28498((class_2769)class_2533.field_11631) && ((Boolean)state.method_11654((class_2769)class_2533.field_11631)).booleanValue()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static double weight(FalloffCurve curve, double t) {
        t = Math.max(0.0, Math.min(1.0, t));
        return Math.cos(t * 1.5707963267948966);
    }

    private static final class Exposure {
        private static final long TTL_TICKS = 80L;
        private static final Map<Cache.WorldKey, Map<Long, Entry>> CACHE = new ConcurrentHashMap<Cache.WorldKey, Map<Long, Entry>>();

        private Exposure() {
        }

        static int stepsToOutside(class_1937 world, class_2338 source, int budget) {
            Map byWorld = CACHE.computeIfAbsent(Cache.WorldKey.of(world), k -> new ConcurrentHashMap());
            long key = source.method_10063() ^ (long)budget << 32;
            long now = world.method_8510();
            Entry e = (Entry)byWorld.get(key);
            if (e != null && now - e.tick <= 80L) {
                return e.steps;
            }
            int steps = Exposure.compute(world, source, budget);
            byWorld.put(key, new Entry(now, steps));
            return steps;
        }

        static int stepsToOutsideViaFace(class_1937 world, class_2338 source, int budget, class_2350 face) {
            Map byWorld = CACHE.computeIfAbsent(Cache.WorldKey.of(world), k -> new ConcurrentHashMap());
            long key = source.method_10063() ^ (long)budget << 32 ^ (long)face.method_10146() << 48;
            long now = world.method_8510();
            Entry e = (Entry)byWorld.get(key);
            if (e != null && now - e.tick <= 80L) {
                return e.steps;
            }
            int steps = Exposure.computeViaFace(world, source, budget, face);
            byWorld.put(key, new Entry(now, steps));
            return steps;
        }

        private static int compute(class_1937 world, class_2338 source, int budget) {
            if (BlockThermalAPI.isFullySealed(world, source)) {
                return -1;
            }
            ArrayDeque<Node> q = new ArrayDeque<Node>();
            HashSet<Long> visited = new HashSet<Long>();
            class_2680 srcState = world.method_8320(source);
            boolean srcPass = BlockThermalAPI.isPassable(world, source, srcState);
            if (srcPass) {
                q.add(new Node(source, 0));
                visited.add(source.method_10063());
            }
            for (class_2350 d : class_2350.values()) {
                class_2680 st;
                class_2338 np = source.method_10093(d);
                if (visited.contains(np.method_10063()) || !BlockThermalAPI.isPassable(world, np, st = world.method_8320(np))) continue;
                q.add(new Node(np, 1));
                visited.add(np.method_10063());
            }
            while (!q.isEmpty()) {
                Node n = (Node)q.poll();
                if (BlockThermalAPI.hasPassableSkyColumn(world, n.pos)) {
                    return n.dist;
                }
                if (n.dist >= budget) continue;
                for (class_2350 d : class_2350.values()) {
                    class_2680 st;
                    class_2338 np = n.pos.method_10093(d);
                    long npLong = np.method_10063();
                    if (visited.contains(npLong) || !BlockThermalAPI.isPassable(world, np, st = world.method_8320(np))) continue;
                    visited.add(npLong);
                    q.add(new Node(np, n.dist + 1));
                }
            }
            return -1;
        }

        private static int computeViaFace(class_1937 world, class_2338 source, int budget, class_2350 face) {
            class_2338 first = source.method_10093(face);
            if (!BlockThermalAPI.isPassable(world, first, world.method_8320(first))) {
                return -1;
            }
            ArrayDeque<Node> q = new ArrayDeque<Node>();
            HashSet<Long> visited = new HashSet<Long>();
            q.add(new Node(first, 1));
            visited.add(first.method_10063());
            while (!q.isEmpty()) {
                Node n = (Node)q.poll();
                if (BlockThermalAPI.hasPassableSkyColumn(world, n.pos)) {
                    return n.dist;
                }
                if (n.dist >= budget) continue;
                for (class_2350 d : class_2350.values()) {
                    class_2680 st;
                    class_2338 np = n.pos.method_10093(d);
                    long npLong = np.method_10063();
                    if (visited.contains(npLong) || !BlockThermalAPI.isPassable(world, np, st = world.method_8320(np))) continue;
                    visited.add(npLong);
                    q.add(new Node(np, n.dist + 1));
                }
            }
            return -1;
        }

        private record Entry(long tick, int steps) {
        }

        private record Node(class_2338 pos, int dist) {
        }
    }

    public static final class ThermalSource {
        public final double deltaC;
        public final int range;
        public final OcclusionMode occlusion;
        public final int dropoffBlocks;
        public final FalloffCurve curve;
        public final class_2350 face;

        public ThermalSource(double deltaC, int range) {
            this(deltaC, range, OcclusionMode.FLOOD_FILL, 7, FalloffCurve.COSINE, null);
        }

        public ThermalSource(double deltaC, int range, OcclusionMode occlusion) {
            this(deltaC, range, occlusion, 7, FalloffCurve.COSINE, null);
        }

        public ThermalSource(double deltaC, int range, OcclusionMode occlusion, int dropoffBlocks, FalloffCurve curve) {
            this(deltaC, range, occlusion, dropoffBlocks, curve, null);
        }

        public ThermalSource(double deltaC, int range, OcclusionMode occlusion, int dropoffBlocks, FalloffCurve curve, class_2350 face) {
            this.deltaC = deltaC;
            this.range = Math.max(0, range);
            this.occlusion = occlusion == null ? OcclusionMode.FLOOD_FILL : occlusion;
            int d = Math.max(0, dropoffBlocks);
            if (d > 15) {
                d = 15;
            }
            this.dropoffBlocks = d;
            this.curve = curve == null ? FalloffCurve.COSINE : curve;
            this.face = face;
        }

        public static ThermalSource staticSource(double deltaC, int range) {
            return new ThermalSource(deltaC, range, OcclusionMode.FLOOD_FILL, 0, FalloffCurve.COSINE, null);
        }

        public int influenceRadius() {
            return this.range + this.dropoffBlocks;
        }

        public String toString() {
            return "ThermalSource{" + this.deltaC + "C, r=" + this.range + ", occ=" + String.valueOf((Object)this.occlusion) + ", drop=" + this.dropoffBlocks + ", curve=" + String.valueOf((Object)this.curve) + ", face=" + (this.face == null ? "omni" : this.face.method_15434()) + "}";
        }
    }

    public static enum OcclusionMode {
        LINE_OF_SIGHT,
        FLOOD_FILL;

    }

    public static enum FalloffCurve {
        COSINE;

    }

    private static final class Cache {
        private static final long TTL_TICKS = 80L;
        private static final Map<WorldKey, Map<Long, Entry>> CACHE = new ConcurrentHashMap<WorldKey, Map<Long, Entry>>();

        private Cache() {
        }

        static double get(class_1937 world, class_2338 pos) {
            WorldKey wk = WorldKey.of(world);
            Map<Long, Entry> map = CACHE.get(wk);
            if (map == null) {
                return Double.NaN;
            }
            Entry e = map.get(pos.method_10063());
            if (e == null) {
                return Double.NaN;
            }
            long now = world.method_8510();
            if (now - e.tick <= 80L) {
                return e.value;
            }
            map.remove(pos.method_10063());
            return Double.NaN;
        }

        static void put(class_1937 world, class_2338 pos, double value) {
            WorldKey wk = WorldKey.of(world);
            CACHE.computeIfAbsent(wk, k -> new ConcurrentHashMap()).put(pos.method_10063(), new Entry(world.method_8510(), value));
        }

        record WorldKey(String id) {
            static WorldKey of(class_1937 world) {
                class_2960 key = world.method_27983().method_29177();
                return new WorldKey(key.toString());
            }
        }

        record Entry(long tick, double value) {
        }
    }

    private static final class FloodFill {
        private static final Map<Cache.WorldKey, Map<Long, FFEntry>> CACHE = new ConcurrentHashMap<Cache.WorldKey, Map<Long, FFEntry>>();
        private static final long TTL_TICKS = 80L;

        private FloodFill() {
        }

        static int stepsTo(class_1937 world, class_2338 source, class_2338 target, int budget) {
            Integer dist;
            if (source.equals((Object)target)) {
                return 0;
            }
            int manhattan = Math.abs(target.method_10263() - source.method_10263()) + Math.abs(target.method_10264() - source.method_10264()) + Math.abs(target.method_10260() - source.method_10260());
            if (manhattan > budget) {
                return -1;
            }
            Map bySource = CACHE.computeIfAbsent(Cache.WorldKey.of(world), k -> new ConcurrentHashMap());
            long key = source.method_10063() ^ (long)budget << 32;
            long now = world.method_8510();
            FFEntry e = (FFEntry)bySource.get(key);
            if (e == null || now - e.tick > 80L) {
                e = FloodFill.compute(world, source, budget);
                bySource.put(key, e);
            }
            return (dist = e.distances.get(target.method_10063())) == null ? -1 : dist;
        }

        static int stepsToViaFace(class_1937 world, class_2338 source, class_2338 target, int budget, class_2350 face) {
            Integer dist;
            if (source.equals((Object)target)) {
                return 0;
            }
            int manhattan = Math.abs(target.method_10263() - source.method_10263()) + Math.abs(target.method_10264() - source.method_10264()) + Math.abs(target.method_10260() - source.method_10260());
            if (manhattan > budget) {
                return -1;
            }
            Map bySource = CACHE.computeIfAbsent(Cache.WorldKey.of(world), k -> new ConcurrentHashMap());
            long key = source.method_10063() ^ (long)budget << 32 ^ (long)face.method_10146() << 48;
            long now = world.method_8510();
            FFEntry e = (FFEntry)bySource.get(key);
            if (e == null || now - e.tick > 80L) {
                e = FloodFill.computeViaFace(world, source, budget, face);
                bySource.put(key, e);
            }
            return (dist = e.distances.get(target.method_10063())) == null ? -1 : dist;
        }

        private static FFEntry compute(class_1937 world, class_2338 source, int budget) {
            ArrayDeque<Node> q = new ArrayDeque<Node>();
            HashSet<Long> visited = new HashSet<Long>();
            HashMap<Long, Integer> distances = new HashMap<Long, Integer>();
            q.add(new Node(source, 0));
            visited.add(source.method_10063());
            distances.put(source.method_10063(), 0);
            while (!q.isEmpty()) {
                Node n = (Node)q.poll();
                if (n.dist >= budget) continue;
                for (class_2350 dir : class_2350.values()) {
                    class_2680 st;
                    class_2338 np = n.pos.method_10093(dir);
                    long npLong = np.method_10063();
                    if (visited.contains(npLong) || !BlockThermalAPI.isPassable(world, np, st = world.method_8320(np))) continue;
                    visited.add(npLong);
                    distances.put(npLong, n.dist + 1);
                    q.add(new Node(np, n.dist + 1));
                }
            }
            return new FFEntry(world.method_8510(), budget, distances);
        }

        private static FFEntry computeViaFace(class_1937 world, class_2338 source, int budget, class_2350 face) {
            ArrayDeque<Node> q = new ArrayDeque<Node>();
            HashSet<Long> visited = new HashSet<Long>();
            HashMap<Long, Integer> distances = new HashMap<Long, Integer>();
            visited.add(source.method_10063());
            distances.put(source.method_10063(), 0);
            class_2338 first = source.method_10093(face);
            if (BlockThermalAPI.isPassable(world, first, world.method_8320(first))) {
                q.add(new Node(first, 1));
                visited.add(first.method_10063());
                distances.put(first.method_10063(), 1);
            }
            while (!q.isEmpty()) {
                Node n = (Node)q.poll();
                if (n.dist >= budget) continue;
                for (class_2350 dir : class_2350.values()) {
                    class_2680 st;
                    class_2338 np = n.pos.method_10093(dir);
                    long npLong = np.method_10063();
                    if (visited.contains(npLong) || !BlockThermalAPI.isPassable(world, np, st = world.method_8320(np))) continue;
                    visited.add(npLong);
                    distances.put(npLong, n.dist + 1);
                    q.add(new Node(np, n.dist + 1));
                }
            }
            return new FFEntry(world.method_8510(), budget, distances);
        }

        private record FFEntry(long tick, int budget, HashMap<Long, Integer> distances) {
        }

        private record Node(class_2338 pos, int dist) {
        }
    }

    @FunctionalInterface
    public static interface Provider {
        public ThermalSource get(class_1937 var1, class_2338 var2, class_2680 var3);
    }
}

