/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.SplittableRandom;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public final class DayNightAPI {
    private static final long TICKS_PER_DAY = 24000L;
    private static final long TICKS_PER_MINUTE = 1200L;

    private DayNightAPI() {
    }

    public static double temperatureOffsetC(class_1937 world, class_2338 pos) {
        if (world == null) {
            return 0.0;
        }
        long timeOfDay = world.method_8532();
        return DayNightAPI.temperatureOffsetC(world, timeOfDay);
    }

    public static double temperatureOffsetC(class_1937 world, long timeOfDayTicks) {
        double m;
        double M;
        if (world == null) {
            return 0.0;
        }
        long dayIndex = Math.floorDiv(timeOfDayTicks, 24000L);
        long dayTick = Math.floorMod(timeOfDayTicks, 24000L);
        long minuteIndex = dayTick / 1200L;
        double t = ((double)minuteIndex + 0.5) / 20.0;
        Double Msyn = null;
        Double msyn = null;
        if (world.method_8608()) {
            String dim = world.method_27983().method_29177().toString();
            try {
                Field fDay;
                long d;
                Class<?> cls = Class.forName("gavinx.temperatureapi.client.DiurnalClientState");
                Method get = cls.getMethod("get", String.class);
                Object entry = get.invoke(null, dim);
                if (entry != null && (d = ((Long)(fDay = entry.getClass().getField("dayIndex")).get(entry)).longValue()) == dayIndex) {
                    Field fM = entry.getClass().getField("M");
                    Field fm = entry.getClass().getField("m");
                    Msyn = (Double)fM.get(entry);
                    msyn = (Double)fm.get(entry);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (Msyn != null && msyn != null) {
            M = Msyn;
            m = msyn;
        } else {
            long seed = DayNightAPI.seedFor(world, dayIndex);
            SplittableRandom rng = new SplittableRandom(seed);
            M = rng.nextDouble(0.0, 6.0);
            m = rng.nextDouble(-7.0, -2.0);
        }
        double center = (M + m) * 0.5;
        double amplitude = (M - m) * 0.5;
        double phase = t - 0.25;
        double offset = center + amplitude * Math.cos(Math.PI * 2 * phase);
        return offset;
    }

    private static long seedFor(class_1937 world, long dayIndex) {
        long seed = -7046029254386353131L;
        try {
            if (world instanceof class_3218) {
                class_3218 sw = (class_3218)world;
                seed ^= DayNightAPI.mix64(sw.method_8412());
            }
        }
        catch (Throwable sw) {
            // empty catch block
        }
        String dim = world.method_27983().method_29177().toString();
        seed ^= DayNightAPI.mix64(dim.hashCode());
        return seed ^= DayNightAPI.mix64(dayIndex);
    }

    private static long mix64(long z) {
        z = (z ^ z >>> 30) * -4658895280553007687L;
        z = (z ^ z >>> 27) * -7723592293110705685L;
        return z ^ z >>> 31;
    }
}

