/*
 * Decompiled with CFR 0.152.
 */
package gavinx.temperatureapi.api.biome;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import gavinx.temperatureapi.TemperatureApi;
import gavinx.temperatureapi.api.biome.BopDefaults;
import gavinx.temperatureapi.api.biome.DefaultBiomes;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6880;

public final class BiomeAPI {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DEFAULT_DIR = "temperatureapi";
    private static final String DEFAULT_FILE = "biomes.json";
    private static Path configPath;
    private static Map<String, CustomBiome> registry;
    private static Map<String, CustomBiome> defaults;
    private static Map<String, CustomBiome> bopDefaults;
    private static volatile boolean loaded;

    private static String normalizeKey(String raw) {
        int firstDot;
        if (raw == null) {
            return null;
        }
        String s = raw.trim();
        if (s.isEmpty()) {
            return null;
        }
        if ((s = s.toLowerCase()).startsWith("biome.")) {
            return s;
        }
        int colon = s.indexOf(58);
        if (colon > 0) {
            String ns = s.substring(0, colon);
            String path = s.substring(colon + 1).replace('/', '.');
            if (!ns.isEmpty() && !path.isEmpty()) {
                return "biome." + ns + "." + path;
            }
        }
        if ((firstDot = s.indexOf(46)) > 0) {
            String ns = s.substring(0, firstDot);
            String path = s.substring(firstDot + 1);
            if (!ns.isEmpty() && !path.isEmpty()) {
                return "biome." + ns + "." + path;
            }
        }
        if (!s.contains(".") && !s.contains(":")) {
            return "biome.minecraft." + s;
        }
        return s;
    }

    private static String collapseKey(String canonical) {
        if (canonical == null) {
            return null;
        }
        String s = canonical.toLowerCase();
        if (!s.startsWith("biome.")) {
            return s;
        }
        String[] parts = s.split("\\.");
        if (parts.length < 3) {
            return s;
        }
        String ns = parts[1];
        String last = parts[parts.length - 1];
        return "biome." + ns + "." + last;
    }

    private BiomeAPI() {
    }

    public static void setConfigPath(Path path) {
        configPath = path;
    }

    public static Path getConfigPath() {
        if (configPath != null) {
            return configPath;
        }
        Path cfgDir = FabricLoader.getInstance().getConfigDir().resolve(DEFAULT_DIR);
        return cfgDir.resolve(DEFAULT_FILE);
    }

    public static synchronized void load() {
        Path path = BiomeAPI.getConfigPath();
        BiomeAPI.ensureParentDir(path);
        HashMap<String, CustomBiome> merged = new HashMap<String, CustomBiome>();
        int resourceFiles = 0;
        int resourceEntries = 0;
        int resourceSkipped = 0;
        try {
            ClassLoader cl = BiomeAPI.class.getClassLoader();
            Enumeration<URL> urls = cl.getResources("temperatureapi/biomes.json");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                ++resourceFiles;
                try {
                    InputStream in = url.openStream();
                    try (String[] reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                        JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                        if (root != null && root.isJsonArray()) {
                            int[] r = BiomeAPI.mergeJsonArray(root, merged);
                            resourceEntries += r[0];
                            resourceSkipped += r[1];
                            continue;
                        }
                        TemperatureApi.LOGGER.warn("Ignoring non-array TemperatureAPI resource at {}", (Object)url);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (Exception e) {
                    TemperatureApi.LOGGER.warn("Failed to read TemperatureAPI resource {}: {}", (Object)url, (Object)e.getMessage());
                }
            }
        }
        catch (IOException e) {
            TemperatureApi.LOGGER.debug("No TemperatureAPI classpath contributions found: {}", (Object)e.getMessage());
        }
        try {
            for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
                String[] candidates;
                String modid = mod.getMetadata().getId();
                for (String rel : candidates = new String[]{"temperatureapi/biomes.json", "assets/" + modid + "/temperatureapi/biomes.json", "data/" + modid + "/temperatureapi/biomes.json"}) {
                    Path p;
                    Optional pOpt = mod.findPath(rel);
                    if (pOpt.isEmpty() || !Files.exists(p = (Path)pOpt.get(), new LinkOption[0])) continue;
                    ++resourceFiles;
                    try (InputStream in = Files.newInputStream(p, new OpenOption[0]);
                         InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                        JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
                        if (root != null && root.isJsonArray()) {
                            int[] r = BiomeAPI.mergeJsonArray(root, merged);
                            resourceEntries += r[0];
                            resourceSkipped += r[1];
                            JsonArray arr = root.getAsJsonArray();
                            TemperatureApi.LOGGER.info("Loaded TemperatureAPI biome resource from mod '{}' path '{}' ({} entries)", new Object[]{modid, rel, arr.size()});
                            continue;
                        }
                        TemperatureApi.LOGGER.warn("Ignoring non-array TemperatureAPI resource from mod '{}' at '{}'", (Object)modid, (Object)rel);
                    }
                    catch (Exception e) {
                        TemperatureApi.LOGGER.warn("Failed to read TemperatureAPI resource from mod '{}' at '{}': {}", new Object[]{modid, rel, e.getMessage()});
                    }
                }
            }
        }
        catch (Throwable t) {
            TemperatureApi.LOGGER.debug("TemperatureAPI mod resource scan skipped: {}", (Object)t.getMessage());
        }
        boolean createdSample = false;
        if (!Files.exists(path, new LinkOption[0])) {
            BiomeAPI.writeSample(path);
            createdSample = true;
        }
        int externalEntries = 0;
        int externalSkipped = 0;
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            JsonElement root = (JsonElement)GSON.fromJson((Reader)reader, JsonElement.class);
            if (root == null || !root.isJsonArray()) {
                throw new JsonParseException("Root must be a JSON array of biome entries");
            }
            int[] r = BiomeAPI.mergeJsonArray(root, merged);
            externalEntries += r[0];
            externalSkipped += r[1];
        }
        catch (Exception e) {
            TemperatureApi.LOGGER.error("Failed to load biome config from {}: {}", (Object)path, (Object)e.getMessage());
        }
        registry = Collections.unmodifiableMap(merged);
        if (merged.isEmpty() && !createdSample) {
            TemperatureApi.LOGGER.warn("BiomeAPI: No entries loaded from external config {}. Ensure JSON is an array of objects with biome/temperature/humidity.", (Object)path);
        }
        HashMap<String, CustomBiome> combined = new HashMap<String, CustomBiome>(DefaultBiomes.defaults());
        bopDefaults = BopDefaults.defaults();
        combined.putAll(bopDefaults);
        defaults = Collections.unmodifiableMap(combined);
        TemperatureApi.LOGGER.info("BiomeAPI loaded: {} classpath files ({} entries, {} skipped), {} external entries ({} skipped), {} defaults ({} BOP)", new Object[]{resourceFiles, resourceEntries, resourceSkipped, externalEntries, externalSkipped, defaults.size(), bopDefaults.size()});
        loaded = true;
    }

    private static void ensureLoaded() {
        if (!loaded) {
            try {
                BiomeAPI.load();
            }
            catch (Exception e) {
                TemperatureApi.LOGGER.error("BiomeAPI failed lazy-load: {}", (Object)e.getMessage());
            }
        }
    }

    public static Map<String, CustomBiome> snapshotConfigured() {
        BiomeAPI.ensureLoaded();
        return new HashMap<String, CustomBiome>(registry);
    }

    public static Map<String, CustomBiome> snapshotDefaults() {
        BiomeAPI.ensureLoaded();
        return new HashMap<String, CustomBiome>(defaults);
    }

    public static Optional<CustomBiome> get(String key) {
        BiomeAPI.ensureLoaded();
        String k = BiomeAPI.normalizeKey(key);
        CustomBiome v = registry.get(k);
        if (v != null) {
            return Optional.of(v);
        }
        v = registry.get(BiomeAPI.collapseKey(k));
        if (v != null) {
            return Optional.of(v);
        }
        CustomBiome d = defaults.get(k);
        if (d != null) {
            return Optional.of(d);
        }
        d = defaults.get(BiomeAPI.collapseKey(k));
        return Optional.ofNullable(d);
    }

    public static String keyFor(class_6880<class_1959> biomeEntry) {
        class_2960 id = biomeEntry.method_40230().map(k -> k.method_29177()).orElse(null);
        if (id == null) {
            return null;
        }
        String key = "biome." + id.method_12836() + "." + id.method_12832().replace('/', '.');
        return key.toLowerCase();
    }

    private static void ensureParentDir(Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            TemperatureApi.LOGGER.warn("Could not create config directory for {}: {}", (Object)path, (Object)e.getMessage());
        }
    }

    private static void writeSample(Path path) {
        JsonArray arr = new JsonArray();
        arr.add((JsonElement)BiomeAPI.sampleEntry("biome.minecraft.plains", 22.0, 40));
        arr.add((JsonElement)BiomeAPI.sampleEntry("biome.minecraft.desert", 38.0, 5));
        arr.add((JsonElement)BiomeAPI.sampleEntry("biome.minecraft.snowy_plains", -5.0, 60));
        try (BufferedWriter w = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)arr, (Appendable)w);
            TemperatureApi.LOGGER.info("Wrote sample biome config to {}", (Object)path);
        }
        catch (IOException e) {
            TemperatureApi.LOGGER.warn("Failed to write sample biome config to {}: {}", (Object)path, (Object)e.getMessage());
        }
    }

    private static JsonObject sampleEntry(String key, double temp, int humidity) {
        JsonObject obj = new JsonObject();
        obj.addProperty("biome", BiomeAPI.normalizeKey(key));
        obj.addProperty("temperature", (Number)temp);
        obj.addProperty("humidity", (Number)humidity);
        return obj;
    }

    private static int[] mergeJsonArray(JsonElement root, Map<String, CustomBiome> out) {
        int added = 0;
        int skipped = 0;
        JsonArray arr = root.getAsJsonArray();
        for (JsonElement el : arr) {
            if (!el.isJsonObject()) continue;
            JsonObject obj = el.getAsJsonObject();
            String biomeRaw = BiomeAPI.getAsString(obj, "biome", null);
            Double temp = BiomeAPI.getFirstDouble(obj, "temperature", "temp");
            Integer hum = BiomeAPI.getFirstInt(obj, "humidity", "hum");
            String biome = BiomeAPI.normalizeKey(biomeRaw);
            if (biome == null || temp == null || hum == null) {
                ++skipped;
                continue;
            }
            out.put(biome, new CustomBiome(biome, temp, hum));
            ++added;
        }
        return new int[]{added, skipped};
    }

    private static Double getFirstDouble(JsonObject o, String ... keys) {
        for (String k : keys) {
            Double v = BiomeAPI.getAsDouble(o, k, null);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private static Integer getFirstInt(JsonObject o, String ... keys) {
        for (String k : keys) {
            Integer v = BiomeAPI.getAsInt(o, k, null);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private static String getAsString(JsonObject o, String k, String def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsString() : def;
    }

    private static Double getAsDouble(JsonObject o, String k, Double def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsDouble() : def.doubleValue();
    }

    private static Integer getAsInt(JsonObject o, String k, Integer def) {
        return o.has(k) && o.get(k).isJsonPrimitive() ? o.get(k).getAsInt() : def.intValue();
    }

    static {
        registry = Collections.emptyMap();
        defaults = Collections.emptyMap();
        bopDefaults = Collections.emptyMap();
        loaded = false;
    }

    public static final class CustomBiome {
        public final String key;
        public final double temperature;
        public final int humidity;

        public CustomBiome(String key, double temperature, int humidity) {
            this.key = key;
            this.temperature = temperature;
            this.humidity = Math.max(0, Math.min(100, humidity));
        }
    }
}

