/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import java.util.ArrayList;
import java.util.List;
import us.mikebartosh.minecraft.animatedinventory.BranchPart;

public class Branch {
    private List<BranchPart> parts = new ArrayList<BranchPart>();
    private double waveAmplitude;
    private double frequency;
    public double k;
    public double m;
    public double n;

    public Branch(double waveAmplitude, double frequency, int k, int m, int n) {
        this.waveAmplitude = waveAmplitude;
        this.frequency = frequency;
        this.k = k;
        this.m = m;
        this.n = n;
    }

    public void addBranchPart(BranchPart part) {
        this.parts.add(part);
    }

    public void update(double time) {
        for (BranchPart part : this.parts) {
            part.updateOffset(this.waveAmplitude, this.frequency, time, this.k, this.m, this.n);
        }
    }

    public void balance() {
        for (int i = 0; i < this.parts.size() - 1; ++i) {
            BranchPart currentPart = this.parts.get(i);
            BranchPart nextPart = this.parts.get(i + 1);
            currentPart.balanceOffset(nextPart.getOffsetX());
        }
    }

    public List<BranchPart> getParts() {
        return this.parts;
    }
}

