/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import net.minecraft.class_2960;
import net.minecraft.class_332;

public class BranchPart {
    private final int originalX;
    private final int originalY;
    private int offsetX = 0;
    private final double phaseShift;
    private final String image_path;
    private final int branch_number;

    public BranchPart(int x, int y, double phaseShift, String branch_number) {
        this.originalX = x;
        this.originalY = y;
        this.phaseShift = phaseShift;
        this.image_path = "textures/gui/animated-inventory-textures/forests/branch_parts/branch_" + branch_number + ".png";
        this.branch_number = (int)Double.parseDouble("0." + branch_number);
    }

    public int getX() {
        return this.originalX + this.offsetX;
    }

    public int getY() {
        return this.originalY;
    }

    public void updateOffset(double waveAmplitude, double frequency, double time, double k, double m, double n) {
        double scaledAmplitude = n / ((double)this.branch_number + 1.0);
        this.offsetX = (int)(Math.sin(k * (double)(this.branch_number * this.branch_number) + m * time) * scaledAmplitude);
        if (this.offsetX > 1) {
            this.offsetX = 1;
        } else if (this.offsetX < -1) {
            this.offsetX = -1;
        }
    }

    public void balanceOffset(int nextBranchOffset) {
        int diff = this.offsetX - nextBranchOffset;
        if (Math.abs(diff) > 1) {
            if (diff > 1) {
                this.offsetX = nextBranchOffset + 1;
            } else if (diff < -1) {
                this.offsetX = nextBranchOffset - 1;
            }
        }
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getBranchNumber() {
        return this.branch_number;
    }

    public void render(class_332 context, int main_x, int main_y) {
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)this.image_path), main_x + this.originalX, main_y + this.originalY + this.offsetX, 0.0f, 0.0f, 26, 11, 26, 11);
    }
}

