/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import us.mikebartosh.minecraft.animatedinventory.TimeChecker;

public class Bubble {
    final double velocity;
    private final double[] coords;
    private final float bubbleID;
    private final int bubbleSize;
    private final String bubbleText;
    private boolean pop = false;
    private int pop_state = 1;
    public boolean dead_bubble = false;
    private double velocityX;
    private double velocityY;
    private boolean isBurstMode;

    public Bubble(double velocity, double[] start_coords, int bubbleSize, float ID, Random random, boolean isBurstMode) {
        this.velocity = velocity;
        this.coords = start_coords;
        this.bubbleID = ID;
        if (bubbleSize == 3) {
            this.bubbleSize = 7;
            this.bubbleText = "big_bubble/bubble";
        } else if (bubbleSize == 2) {
            this.bubbleSize = 6;
            this.bubbleText = "medium_bubble/bubble";
        } else {
            this.bubbleSize = 4;
            this.bubbleText = "small_bubble/bubble";
        }
        if (isBurstMode) {
            this.initializeBurstBubble(88.0, 83.0, random);
        } else {
            this.initializeDefaultBubble(random);
        }
    }

    public void initializeBurstBubble(double centerX, double centerY, Random random) {
        this.isBurstMode = true;
        double angle = Math.PI * 2 * random.nextDouble();
        double minSpeed = 0.5;
        double maxSpeed = 2.0;
        double speed = minSpeed + (maxSpeed - minSpeed) * random.nextDouble();
        this.velocityX = speed * Math.cos(angle);
        this.velocityY = speed * Math.sin(angle);
        this.coords[0] = centerX;
        this.coords[1] = centerY;
    }

    public void initializeDefaultBubble(Random random) {
        this.isBurstMode = false;
        this.velocityX = 0.0;
        this.velocityY = -(0.5 + 0.05 * random.nextDouble());
    }

    public void step_bubble(Random random) {
        if (this.isBurstMode) {
            this.coords[0] = this.coords[0] + this.velocityX;
            this.coords[1] = this.coords[1] + this.velocityY;
            this.velocityX += -0.01 + 0.02 * random.nextDouble();
            this.velocityY += -0.01 + 0.02 * random.nextDouble();
            double centerX = 0.0;
            double dx = this.coords[0] - centerX;
            double centerY = 0.0;
            double dy = this.coords[1] - centerY;
            double distance = Math.sqrt(dx * dx + dy * dy);
            if (distance < 1.0) {
                double force = 0.05;
                this.velocityX += force * (dx / distance);
                this.velocityY += force * (dy / distance);
            }
            double defaultDriftFactor = 0.1 * Math.sin((double)System.currentTimeMillis() / 300.0) + (-0.2 + 0.4 * random.nextDouble());
            double defaultFallSpeed = -(0.5 + 0.005 * random.nextDouble());
            double interpolationFactor = 0.01;
            this.velocityX = (1.0 - interpolationFactor) * this.velocityX + interpolationFactor * -defaultDriftFactor;
            this.velocityY = (1.0 - interpolationFactor) * this.velocityY + interpolationFactor * defaultFallSpeed;
        } else {
            double driftFactor = 0.1 * Math.sin((double)System.currentTimeMillis() / 300.0) + (-0.2 + 0.4 * random.nextDouble());
            this.coords[0] = this.coords[0] - driftFactor;
            double fallSpeed = -(0.5 + 0.005 * random.nextDouble());
            this.coords[1] = this.coords[1] + fallSpeed;
        }
        this.velocityX *= 0.98;
        this.velocityY *= 0.98;
    }

    public void render_bubble(class_332 context, int x_offset, int y_offset, TimeChecker timeCheck) {
        String path;
        if (this.pop) {
            String bubble_ID = "bubble" + this.bubbleID + this.velocity;
            if (!timeCheck.hasName(bubble_ID)) {
                timeCheck.addName(bubble_ID);
            }
            if (timeCheck.hasXTimePassed(bubble_ID, 0.14)) {
                ++this.pop_state;
                timeCheck.updateTime(bubble_ID);
            }
            if (this.pop_state == 3) {
                this.dead_bubble = true;
            }
            path = "textures/gui/animated-inventory-textures/underwater/bubbles/" + this.bubbleText + "_pop_" + this.pop_state + ".png";
        } else {
            path = "textures/gui/animated-inventory-textures/underwater/bubbles/" + this.bubbleText + ".png";
        }
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)path), (int)((double)x_offset + this.coords[0]), (int)((double)y_offset + this.coords[1]), 0.0f, 0.0f, this.bubbleSize, this.bubbleSize, this.bubbleSize, this.bubbleSize);
    }

    public boolean is_out_of_bounds(Random random) {
        boolean actuallyOutOfBounds;
        boolean bl = actuallyOutOfBounds = this.coords[0] > 176.0 || this.coords[1] > 166.0 || this.coords[0] < 0.0 || this.coords[1] < 0.0;
        if (actuallyOutOfBounds && random.nextInt(10) <= 2) {
            return false;
        }
        return actuallyOutOfBounds;
    }

    public boolean is_clicked(int x, int y, int x_offset, int y_offset) {
        return (double)x > (double)x_offset + this.coords[0] && (double)x < (double)x_offset + this.coords[0] + (double)this.bubbleSize && (double)y > (double)y_offset + this.coords[1] && (double)y < (double)y_offset + this.coords[1] + (double)this.bubbleSize;
    }

    public void pop() {
        this.pop = true;
    }
}

