/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.class_332;
import us.mikebartosh.minecraft.animatedinventory.Bubble;
import us.mikebartosh.minecraft.animatedinventory.TimeChecker;

public class BubbleManager {
    List<Bubble> bubbleList = new ArrayList<Bubble>();
    private final Random random = new Random();

    public void createBottomBubbles(int bubbleAmount, boolean burst) {
        while (bubbleAmount > 0) {
            --bubbleAmount;
            int bubble_size = this.random.nextInt(3) + 1;
            double velocity = 0.2 + (1.1 - (double)bubble_size * 0.3) * this.random.nextDouble();
            Bubble new_bubble = new Bubble(velocity, new double[]{this.random.nextInt(177), 166.0}, bubble_size, this.random.nextFloat(), this.random, burst);
            this.bubbleList.add(new_bubble);
        }
    }

    public void stepBubbles() {
        Iterator<Bubble> iterator = this.bubbleList.iterator();
        while (iterator.hasNext()) {
            Bubble bubble = iterator.next();
            bubble.step_bubble(this.random);
            if (bubble.is_out_of_bounds(this.random)) {
                bubble.pop();
            }
            if (!bubble.dead_bubble) continue;
            iterator.remove();
        }
    }

    public void renderBubbles(class_332 context, int x_offset, int y_offset, TimeChecker timeCheck) {
        for (Bubble bubble : this.bubbleList) {
            bubble.render_bubble(context, x_offset, y_offset, timeCheck);
        }
    }

    public void checkForClick(int x, int y, int x_offset, int y_offset) {
        for (Bubble bubble : this.bubbleList) {
            if (!bubble.is_clicked(x, y, x_offset, y_offset)) continue;
            bubble.pop();
        }
    }
}

