/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import us.mikebartosh.minecraft.animatedinventory.AnimatedInventory;
import us.mikebartosh.minecraft.animatedinventory.RandomPathGenerator;
import us.mikebartosh.minecraft.animatedinventory.TimeChecker;

public class Fly {
    final RandomPathGenerator randomPathGenerator;
    int last_time = 0;

    public Fly(RandomPathGenerator randomPathGenerator) {
        this.randomPathGenerator = randomPathGenerator;
    }

    public void drawFlyPath(class_332 context, int flyTime, int x, int y, Random random) {
        this.checkFlyTime(context, this.randomPathGenerator, flyTime);
        if (this.randomPathGenerator.hasReachedDestination()) {
            int[][] waypoints = new int[][]{{random.nextInt(x, x + 176), random.nextInt(y, y + 166)}, {random.nextInt(x, x + 176), random.nextInt(y, y + 166)}, {x, y + 55}};
            this.resetFlyPosition(waypoints, random, x, y);
        }
        int[] position = this.randomPathGenerator.move();
        String path = "textures/gui/animated-inventory-textures/flys/fly_" + this.randomPathGenerator.getFlyDirection() + ".png";
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)path), position[0], position[1], 0.0f, 0.0f, 2, 2, 2, 2);
        if (position[0] >= x + 102 && position[0] <= x + 106 && position[1] >= y + 52 && position[1] <= y + 58) {
            this.randomPathGenerator.setDestinationReached(true);
        }
    }

    private void checkFlyTime(class_332 context, RandomPathGenerator pathGenerator, int flyTime) {
        if (this.last_time == 0) {
            this.last_time = (int)System.currentTimeMillis();
        } else {
            int current_time = (int)System.currentTimeMillis();
            if (current_time - this.last_time >= flyTime) {
                this.last_time = current_time;
            } else {
                String path = "textures/gui/animated-inventory-textures/flys/fly_" + pathGenerator.getFlyDirection() + ".png";
                context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)path), pathGenerator.getCurrentX(), pathGenerator.getCurrentY(), 0.0f, 0.0f, 2, 2, 2, 2);
            }
        }
    }

    private void resetFlyPosition(int[][] waypoints, Random random, int x, int y) {
        this.randomPathGenerator.setDestinationReached(false);
        this.randomPathGenerator.resetCurrentPosition(random.nextInt(x, x + 176), random.nextInt(y, y + 166), waypoints);
    }

    public void drawFrogFlyPath(class_332 context, int flyTime, Random random, int x, int y, TimeChecker timeCheck) {
        this.checkFlyTime(context, this.randomPathGenerator, flyTime);
        if (this.randomPathGenerator.hasReachedDestination()) {
            int[][] waypoints = new int[][]{{random.nextInt(x, x + 176), y + 27}, {random.nextInt(x, x + 176), y + 45}, {x + 104, y + 55}};
            this.resetFlyPosition(waypoints, random, x, y);
        }
        int[] position = this.randomPathGenerator.move();
        String path = "textures/gui/animated-inventory-textures/flys/fly_" + this.randomPathGenerator.getFlyDirection() + ".png";
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)path), position[0], position[1], 0.0f, 0.0f, 2, 2, 2, 2);
        if (position[0] >= x + 102 && position[0] <= x + 106 && position[1] >= y + 52 && position[1] <= y + 58) {
            this.randomPathGenerator.setDestinationReached(true);
            timeCheck.updateTime("hole_frog");
            AnimatedInventory.run_frog = true;
        }
    }
}

