/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import net.minecraft.class_2960;
import net.minecraft.class_332;
import us.mikebartosh.minecraft.animatedinventory.TimeChecker;

public class JumpingFrog {
    private final int width;
    private final int height;
    private final int x_offset;
    private final int y_offset;
    private final int[][] click_detection_box_offsets;
    private final String check_id;
    private final int version;
    private final TimeChecker timeCheck;
    public boolean is_jumping = false;
    public boolean is_down;
    public boolean is_clicked = false;

    public JumpingFrog(int x_offset, int y_offset, int[][] click_detection_box_offsets, TimeChecker timeCheck, String check_id, int version, boolean is_down) {
        this.x_offset = x_offset;
        this.y_offset = y_offset;
        this.click_detection_box_offsets = click_detection_box_offsets;
        this.timeCheck = timeCheck;
        this.check_id = check_id;
        this.version = version;
        this.is_down = is_down;
        if (version == 1) {
            this.width = 34;
            this.height = 25;
        } else {
            this.width = 37;
            this.height = 18;
        }
    }

    public void updateTime() {
        this.timeCheck.updateTime(this.check_id);
    }

    public int[][] getClickDetectionBoxOffsets() {
        return this.click_detection_box_offsets;
    }

    public void drawFrog(int x, int y, class_332 context, Boolean vivid) {
        String path = "textures/gui/animated-inventory-textures/frogs/" + this.version;
        path = vivid != false ? path + "_jumping_frog_vivid/" : path + "_jumping_frog/";
        path = this.is_down ? path + "up/frog_up_1.png" : path + "down/frog_down_1.png";
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)path), x + this.x_offset, y + this.y_offset, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }

    public void runAnimation(int x, int y, class_332 context, Boolean vivid) {
        this.is_jumping = true;
        this.is_clicked = false;
        boolean time = false;
        String path = "textures/gui/animated-inventory-textures/frogs/" + this.version;
        path = vivid != false ? path + "_jumping_frog_vivid/" : path + "_jumping_frog/";
        path = this.is_down ? path + "up/frog_up" : path + "down/frog_down";
        if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.4)) {
            path = path + "_13.png";
            this.timeCheck.updateTime(this.check_id);
            this.is_down = !this.is_down;
            this.is_jumping = false;
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.39)) {
            path = path + "_12.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.38)) {
            path = path + "_11.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.37)) {
            path = path + "_10.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.36)) {
            path = path + "_9.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.35)) {
            path = path + "_8.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.3)) {
            path = path + "_7.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.25)) {
            path = path + "_6.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.2)) {
            path = path + "_5.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.15)) {
            path = path + "_4.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.1)) {
            path = path + "_3.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time + 0.05)) {
            path = path + "_2.png";
        } else if (this.timeCheck.hasXTimePassed(this.check_id, (double)time)) {
            path = path + "_1.png";
        }
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)path), x + this.x_offset, y + this.y_offset, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }
}

