/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import us.mikebartosh.minecraft.animatedinventory.AnimatedInventory;
import us.mikebartosh.minecraft.animatedinventory.TimeChecker;

public class MainSlimeHelper {
    private static double lastMouseX = -1.0;
    private static double lastMouseY = -1.0;

    public static boolean isMouseStatic(double currentX, double currentY) {
        boolean isStatic = currentX == lastMouseX && currentY == lastMouseY;
        lastMouseX = currentX;
        lastMouseY = currentY;
        return isStatic;
    }

    public static String getDirection(double deltaX, double deltaY) {
        if (Math.abs(deltaX) < 1.5 && Math.abs(deltaY) < 1.5) {
            return "idle";
        }
        if (deltaX < -1.5 && deltaY < -1.5) {
            return "up_left";
        }
        if (deltaX > 1.5 && deltaY < -1.5) {
            return "up_right";
        }
        if (deltaX < -0.5 && deltaY > 1.5) {
            return "down_left";
        }
        if (deltaX > 1.5 && deltaY > 1.5) {
            return "down_right";
        }
        if (deltaX < -1.5) {
            return "left";
        }
        if (deltaX > 1.5) {
            return "right";
        }
        if (deltaY < -1.5) {
            return "up";
        }
        if (deltaY > 1.5) {
            return "down";
        }
        return "idle";
    }

    public static void drawStaticTextures(class_332 context, int x, int y) {
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/slime_bucket.png"), x - 1, y - 12, 0.0f, 0.0f, 47, 16, 47, 16);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/smalldetailslime.png"), x - 5, y + 34, 0.0f, 0.0f, 5, 4, 5, 4);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/smallpipe.png"), x + 176, y + 9, 0.0f, 0.0f, 13, 42, 13, 42);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/smallpipe.png"), x + 176, y + 119, 0.0f, 0.0f, 13, 42, 13, 42);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/smallpipem.png"), x - 13, y + 92, 0.0f, 0.0f, 13, 42, 13, 42);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/smallpipe_cut.png"), x - 13, y + 35, 0.0f, 0.0f, 13, 11, 13, 11);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/slime_sponge_plate.png"), x + 155, y + 81, 0.0f, 0.0f, 13, 4, 13, 4);
    }

    public static void drawSlimeContainerLevel(class_332 context, int x, int y) {
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slime_container_" + AnimatedInventory.slimeBucketLevel + ".png")), x - 16, y + 17, 0.0f, 0.0f, 13, 18, 13, 18);
    }

    public static class FallingSlimePixel {
        private double y;
        private final double endY;
        private double velocityY;
        private final int x;
        private boolean done;

        public FallingSlimePixel(int x, double startY, double endY) {
            this.x = x;
            this.y = startY;
            this.endY = endY;
            this.velocityY = 0.0;
            this.done = false;
        }

        public void tick() {
            if (this.done) {
                return;
            }
            this.velocityY += 0.1;
            this.y += this.velocityY;
            if (this.y >= this.endY) {
                this.y = this.endY;
                this.done = true;
            }
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return (int)this.y;
        }

        public boolean isDone() {
            return this.done;
        }
    }

    public static class SlimeSlotSpongeClearAnimation {
        private final String timeCheckName;
        private int frame;
        private class_2960 texture;
        public final int slotX;
        public final int slotY;

        public SlimeSlotSpongeClearAnimation(Random random, int slotX, int slotY, TimeChecker timeChecker) {
            this.timeCheckName = "slimeSlotSpongeClear_" + random.nextFloat();
            this.frame = 1;
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slimeslot_spongeclear_" + this.frame + ".png"));
            this.slotX = slotX;
            this.slotY = slotY;
            timeChecker.addName(this.timeCheckName);
        }

        public void tick(TimeChecker timeChecker) {
            if (timeChecker.hasXTimePassed(this.timeCheckName, 0.025)) {
                this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slimeslot_spongeclear_" + this.frame + ".png"));
                ++this.frame;
                timeChecker.updateTime(this.timeCheckName);
            }
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public boolean isDone() {
            return this.frame >= 29;
        }
    }

    public static class SlimeSpongeFall {
        private final String timeCheckName = "slimeSpongeFall_" + System.nanoTime();
        private final int targetX;
        private final int targetY;
        public double velocityY = 1.5;
        private int currentY;
        private boolean done;
        private final class_2960 texture;

        public SlimeSpongeFall(TimeChecker timeChecker, int targetX, int targetY) {
            this.targetX = targetX;
            this.targetY = targetY;
            this.done = false;
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/slime_sponge.png");
            timeChecker.addName(this.timeCheckName);
        }

        public void tick(TimeChecker timeChecker) {
            if (!this.done && timeChecker.hasXTimePassed(this.timeCheckName, 0.016)) {
                this.velocityY += 0.26;
                this.currentY += (int)this.velocityY;
                if (this.currentY >= this.targetY) {
                    this.currentY = this.targetY;
                    this.done = true;
                }
                timeChecker.updateTime(this.timeCheckName);
            }
        }

        public void render(class_332 context) {
            context.method_25290(this.texture, this.targetX, this.currentY, 0.0f, 0.0f, 8, 4, 8, 4);
        }

        public boolean isDone() {
            return this.done;
        }
    }

    public static class MovingSlimeSponge {
        public double mouseX;
        public double mouseY;
        public double deltaX;
        public double deltaY;

        public MovingSlimeSponge(double mouseX, double mouseY, double deltaX, double deltaY) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
        }

        public int getDrawX() {
            return (int)(this.mouseX - 4.5);
        }

        public int getDrawY() {
            return (int)(this.mouseY - 4.5);
        }

        public String getDirection() {
            return MainSlimeHelper.isMouseStatic(this.mouseX, this.mouseY) ? "idle" : MainSlimeHelper.getDirection(this.deltaX, this.deltaY);
        }

        public class_2960 getTexture() {
            String textureFile = "slime_sponge.png";
            switch (this.getDirection()) {
                case "up_right": 
                case "down_left": {
                    textureFile = "slime_sponge_down_left.png";
                    break;
                }
                case "down_right": 
                case "up_left": {
                    textureFile = "slime_sponge_up_left.png";
                }
            }
            return class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/" + textureFile));
        }
    }

    public static class ThrownSlimeSponge {
        public double x;
        public double y;
        public double velocityX;
        public double velocityY;
        private class_2960 texture;

        public ThrownSlimeSponge(double x, double y, double velocityX, double velocityY) {
            this.x = x;
            this.y = y;
            this.velocityX = velocityX;
            this.velocityY = velocityY;
        }

        public void tick() {
            this.velocityY += 0.26;
            this.x += this.velocityX;
            this.y += this.velocityY;
            String textureFile = "slime_sponge.png";
            switch (MainSlimeHelper.getDirection(this.velocityX, this.velocityY)) {
                case "up_right": 
                case "down_left": {
                    textureFile = "slime_sponge_down_left.png";
                    break;
                }
                case "down_right": 
                case "up_left": {
                    textureFile = "slime_sponge_up_left.png";
                }
            }
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/" + textureFile));
        }

        public boolean isOffScreen(int screenWidth, int screenHeight) {
            return this.x < -10.0 || this.x > (double)(screenWidth + 10) || this.y > (double)(screenHeight + 10);
        }

        public int getDrawX() {
            return (int)(this.x - 4.5);
        }

        public int getDrawY() {
            return (int)(this.y - 4.5);
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }

    public static class MovingSlimeball {
        public double mouseX;
        public double mouseY;
        public double deltaX;
        public double deltaY;

        public MovingSlimeball(double mouseX, double mouseY, double deltaX, double deltaY) {
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.deltaX = deltaX;
            this.deltaY = deltaY;
        }

        public int getDrawX() {
            return (int)(this.mouseX - 4.5);
        }

        public int getDrawY() {
            return (int)(this.mouseY - 4.5);
        }

        public String getDirection() {
            return MainSlimeHelper.isMouseStatic(this.mouseX, this.mouseY) ? "idle" : MainSlimeHelper.getDirection(this.deltaX, this.deltaY);
        }

        public class_2960 getTexture() {
            String direction = this.getDirection();
            Object textureFile = direction.equals("idle") ? "slime_ball.png" : "slime_ball_" + direction + ".png";
            return class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/" + (String)textureFile));
        }
    }

    public static class ThrownSlimeball {
        public double x;
        public double y;
        public double velocityX;
        public double velocityY;
        private class_2960 texture;

        public ThrownSlimeball(double x, double y, double velocityX, double velocityY) {
            this.x = x;
            this.y = y;
            this.velocityX = velocityX;
            this.velocityY = velocityY;
        }

        public void tick() {
            this.velocityY += 0.16;
            this.x += this.velocityX;
            this.y += this.velocityY;
            String direction = MainSlimeHelper.getDirection(this.velocityX, this.velocityY);
            Object textureFile = direction.equals("idle") ? "slime_ball.png" : "slime_ball_" + direction + ".png";
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/" + (String)textureFile));
        }

        public boolean isOffScreen(int screenWidth, int screenHeight) {
            return this.x < -10.0 || this.x > (double)(screenWidth + 10) || this.y > (double)(screenHeight + 10);
        }

        public int getDrawX() {
            return (int)(this.x - 4.5);
        }

        public int getDrawY() {
            return (int)(this.y - 4.5);
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }

    public static class SlimeSlotAnimation {
        private final String timeCheckName;
        private int frame;
        private class_2960 texture;
        public final int slotX;
        public final int slotY;

        public SlimeSlotAnimation(Random random, int slotX, int slotY, TimeChecker timeChecker) {
            this.timeCheckName = "slimeSlot_" + random.nextFloat();
            this.frame = 1;
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slotslime_" + this.frame + ".png"));
            this.slotX = slotX;
            this.slotY = slotY;
            timeChecker.addName(this.timeCheckName);
        }

        public void tick(TimeChecker timeChecker) {
            if (timeChecker.hasXTimePassed(this.timeCheckName, 0.0325)) {
                this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slotslime_" + this.frame + ".png"));
                ++this.frame;
                timeChecker.updateTime(this.timeCheckName);
            }
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public boolean isDone() {
            return this.frame >= 14;
        }
    }

    public record SlotPosition(int slotX, int slotY) {
    }

    public static class IdleSlimeAnimation {
        private final String timeCheckName;
        private int frame;
        private class_2960 texture;
        public final int X;
        public final int Y;

        public IdleSlimeAnimation(Random random, int X, int Y, TimeChecker timeChecker) {
            this.timeCheckName = "idleSlimeAnimation_" + random.nextFloat();
            this.frame = 1;
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slime_idle_" + this.frame + ".png"));
            this.X = X;
            this.Y = Y;
            timeChecker.addName(this.timeCheckName);
        }

        public void tick(TimeChecker timeChecker) {
            if (timeChecker.hasXTimePassed(this.timeCheckName, 0.167)) {
                this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slime_idle_" + this.frame + ".png"));
                this.frame = this.frame >= 6 ? 1 : ++this.frame;
                timeChecker.updateTime(this.timeCheckName);
            }
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }

    public static class BigSlimePipeAnimation {
        private final String timeCheckName;
        private int frame;
        private class_2960 texture;
        public final int X;
        public final int Y;

        public BigSlimePipeAnimation(Random random, int X, int Y, TimeChecker timeChecker) {
            this.timeCheckName = "slime_fall_" + random.nextFloat();
            this.frame = 1;
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slime_fall_" + this.frame + ".png"));
            this.X = X;
            this.Y = Y;
            timeChecker.addName(this.timeCheckName);
        }

        public void tick(TimeChecker timeChecker) {
            if (timeChecker.hasXTimePassed(this.timeCheckName, 0.04167)) {
                this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slime_fall_" + this.frame + ".png"));
                this.frame = this.frame >= 53 ? 1 : ++this.frame;
                timeChecker.updateTime(this.timeCheckName);
            }
        }

        public boolean isDone() {
            if (this.frame >= 53) {
                this.frame = 1;
                return true;
            }
            return false;
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }

    public static class CutSlimePipeAnimation {
        private final String timeCheckName;
        private int frame;
        private class_2960 texture;
        public final int X;
        public final int Y;

        public CutSlimePipeAnimation(Random random, int X, int Y, TimeChecker timeChecker) {
            this.timeCheckName = "smallSlimePipeCut" + random.nextFloat();
            this.frame = 1;
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/smallslimepipecut_" + this.frame + ".png"));
            this.X = X;
            this.Y = Y;
            timeChecker.addName(this.timeCheckName);
        }

        public void tick(TimeChecker timeChecker) {
            if (timeChecker.hasXTimePassed(this.timeCheckName, 0.0625)) {
                this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/smallslimepipecut_" + this.frame + ".png"));
                this.frame = this.frame >= 21 ? 1 : ++this.frame;
                timeChecker.updateTime(this.timeCheckName);
            }
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }

    public static class MirroredSlimePipeAnimation {
        private final String timeCheckName;
        private int frame;
        private class_2960 texture;
        public final int X;
        public final int Y;

        public MirroredSlimePipeAnimation(Random random, int X, int Y, TimeChecker timeChecker) {
            this.timeCheckName = "slimePipeM_" + random.nextFloat();
            this.frame = 1;
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slimepipem_" + this.frame + ".png"));
            this.X = X;
            this.Y = Y;
            timeChecker.addName(this.timeCheckName);
        }

        public void tick(TimeChecker timeChecker) {
            if (timeChecker.hasXTimePassed(this.timeCheckName, 0.0625)) {
                this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slimepipem_" + this.frame + ".png"));
                this.frame = this.frame >= 21 ? 1 : ++this.frame;
                timeChecker.updateTime(this.timeCheckName);
            }
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }

    public static class SlimePipeAnimation {
        private final String timeCheckName;
        private int frame;
        private class_2960 texture;
        public final int X;
        public final int Y;

        public SlimePipeAnimation(Random random, int X, int Y, TimeChecker timeChecker) {
            this.timeCheckName = "slimePipe_" + random.nextFloat();
            this.frame = 1;
            this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slimepipe_" + this.frame + ".png"));
            this.X = X;
            this.Y = Y;
            timeChecker.addName(this.timeCheckName);
        }

        public void tick(TimeChecker timeChecker) {
            if (timeChecker.hasXTimePassed(this.timeCheckName, 0.0625)) {
                this.texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/slimepipe_" + this.frame + ".png"));
                this.frame = this.frame >= 21 ? 1 : ++this.frame;
                timeChecker.updateTime(this.timeCheckName);
            }
        }

        public class_2960 getTexture() {
            return this.texture;
        }
    }
}

