/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import java.util.Random;

public class RandomPathGenerator {
    private final Random random = new Random();
    private int currentX;
    private int currentY;
    private int destX;
    private int destY;
    private final int stepSize;
    private boolean destination = false;
    private String flyDirection = "down_right";
    private int[][] waypoints;
    private int waypointIndex = 0;

    public RandomPathGenerator(int startX, int startY, int[][] waypoints, int stepSize) {
        this.currentX = startX;
        this.currentY = startY;
        this.waypoints = waypoints;
        this.destX = waypoints[0][0];
        this.destY = waypoints[0][1];
        this.stepSize = stepSize;
    }

    public int getCurrentX() {
        return this.currentX;
    }

    public int getCurrentY() {
        return this.currentY;
    }

    public boolean hasReachedDestination() {
        return this.destination;
    }

    public void setDestinationReached(boolean destination) {
        this.destination = destination;
    }

    public void resetCurrentPosition(int startX, int startY, int[][] waypoints) {
        this.currentX = startX;
        this.currentY = startY;
        this.setWaypoints(waypoints);
    }

    public void setWaypoints(int[][] waypoints) {
        this.waypoints = waypoints;
        this.waypointIndex = 0;
        this.destX = waypoints[0][0];
        this.destY = waypoints[0][1];
        this.destination = false;
    }

    public String getFlyDirection() {
        return this.flyDirection;
    }

    public int[] move() {
        if (this.currentX == this.destX && this.currentY == this.destY) {
            ++this.waypointIndex;
            if (this.waypointIndex < this.waypoints.length) {
                this.destX = this.waypoints[this.waypointIndex][0];
                this.destY = this.waypoints[this.waypointIndex][1];
            } else {
                this.destination = true;
                return new int[]{this.currentX, this.currentY};
            }
        }
        int deltaX = this.destX - this.currentX;
        int deltaY = this.destY - this.currentY;
        int unitX = deltaX == 0 ? 0 : deltaX / Math.abs(deltaX);
        int unitY = deltaY == 0 ? 0 : deltaY / Math.abs(deltaY);
        int stepX = unitX + this.random.nextInt(3) - 1;
        int stepY = unitY + this.random.nextInt(3) - 1;
        int prevX = this.currentX;
        int prevY = this.currentY;
        this.currentX += (stepX *= this.stepSize);
        this.currentY += (stepY *= this.stepSize);
        this.currentX = Math.min(Math.max(this.currentX, Math.min(this.currentX, this.destX)), Math.max(this.currentX, this.destX));
        this.currentY = Math.min(Math.max(this.currentY, Math.min(this.currentY, this.destY)), Math.max(this.currentY, this.destY));
        if (this.currentX > prevX && this.currentY > prevY) {
            this.flyDirection = "down_right";
        } else if (this.currentX > prevX && this.currentY < prevY) {
            this.flyDirection = "up_right";
        } else if (this.currentX < prevX && this.currentY > prevY) {
            this.flyDirection = "down_left";
        } else if (this.currentX < prevX && this.currentY < prevY) {
            this.flyDirection = "up_left";
        }
        return new int[]{this.currentX, this.currentY};
    }
}

