/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class RotatingSnowman {
    private final int x_offset;
    private final int y_offset;
    private final String type;
    private final String preferred_rotation;
    private int current_frame = 1;

    public RotatingSnowman(int x_offset, int y_offset, String type, String preferred_rotation) {
        this.x_offset = x_offset;
        this.y_offset = y_offset;
        this.type = type;
        this.preferred_rotation = preferred_rotation;
    }

    public RotatingSnowman(int x_offset, int y_offset, String type, String preferred_rotation, int alternate_start_frame) {
        this.x_offset = x_offset;
        this.y_offset = y_offset;
        this.type = type;
        this.preferred_rotation = preferred_rotation;
        if (alternate_start_frame >= 1 && alternate_start_frame <= 17) {
            this.current_frame = alternate_start_frame;
        }
    }

    public void rotate() {
        if (Objects.equals(this.preferred_rotation, "left")) {
            this.rotate_left();
        } else if (Objects.equals(this.preferred_rotation, "right")) {
            this.rotate_right();
        } else {
            System.out.println("Non-valid rotation: " + this.preferred_rotation);
        }
    }

    private void rotate_left() {
        if (this.current_frame >= 1 && this.current_frame < 17) {
            ++this.current_frame;
        } else if (this.current_frame == 17) {
            this.current_frame = 1;
        }
    }

    private void rotate_right() {
        if (this.current_frame > 1 && this.current_frame <= 17) {
            --this.current_frame;
        } else if (this.current_frame == 1) {
            this.current_frame = 17;
        }
    }

    public void render_current_frame(class_332 context, int main_x, int main_y) {
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/christmas/rotating_snowmen/" + this.type + "/" + this.current_frame + ".png")), main_x + this.x_offset, main_y + this.y_offset, 0.0f, 0.0f, 10, 14, 10, 14);
    }
}

