/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import java.util.HashMap;
import java.util.Map;

public class TimeChecker {
    private final Map<String, Long> timeMap = new HashMap<String, Long>();

    public void addName(String name) {
        long currentTime = System.currentTimeMillis();
        this.timeMap.put(name, currentTime);
    }

    public void updateTime(String name) {
        long currentTime = System.currentTimeMillis();
        this.timeMap.put(name, currentTime);
    }

    public boolean hasName(String name) {
        return this.timeMap.get(name) != null;
    }

    public boolean hasXTimePassed(String name, double seconds) {
        Long startTime = this.timeMap.get(name);
        if (startTime == null) {
            throw new IllegalArgumentException("Name not found: " + name);
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - startTime;
        return (double)elapsedTime >= seconds * 1000.0;
    }

    public Long getTimePassed(String name) {
        Long startTime = this.timeMap.get(name);
        if (startTime == null) {
            throw new IllegalArgumentException("Name not found: " + name);
        }
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - startTime;
        return elapsedTime;
    }
}

