/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory;

import net.minecraft.class_2960;
import net.minecraft.class_332;
import us.mikebartosh.minecraft.animatedinventory.TimeChecker;

public class WalkingSnowman {
    private final int x_offset;
    private final int y_offset;
    private int x_steps = 0;
    private boolean has_rotated = false;
    public boolean walking = true;
    private boolean inital_rotation = false;
    private int current_frame = 1;
    private boolean heading_left = true;

    public WalkingSnowman(int x_offset, int y_offset) {
        this.x_offset = x_offset;
        this.y_offset = y_offset;
    }

    public void walk(TimeChecker timeChecker) {
        if (this.heading_left) {
            this.walk_left(timeChecker);
            if (!this.walking) {
                this.heading_left = false;
            }
        } else {
            this.walk_right(timeChecker);
            if (!this.walking) {
                this.heading_left = true;
            }
        }
    }

    private void walk_right(TimeChecker timeChecker) {
        if (!this.inital_rotation) {
            this.walking = true;
            this.rotate_right(timeChecker);
        } else if (this.x_steps < 0) {
            ++this.x_steps;
        } else if (!this.has_rotated) {
            this.rotate_left(timeChecker);
        }
    }

    private void walk_left(TimeChecker timeChecker) {
        if (!this.inital_rotation) {
            this.walking = true;
            this.rotate_left(timeChecker);
        } else if (this.x_steps > -64) {
            --this.x_steps;
        } else if (!this.has_rotated) {
            this.rotate_right(timeChecker);
        }
    }

    private void rotate_right(TimeChecker timeChecker) {
        String snowman_key = "walking_snowman_" + this.y_offset;
        if (!timeChecker.hasName(snowman_key)) {
            timeChecker.addName(snowman_key);
        } else if ((double)timeChecker.getTimePassed(snowman_key).longValue() > 0.5) {
            timeChecker.updateTime(snowman_key);
        }
        if (timeChecker.hasXTimePassed(snowman_key, 0.1)) {
            this.rotate_right();
        } else if (timeChecker.hasXTimePassed(snowman_key, 0.2)) {
            this.rotate_right();
        } else if (timeChecker.hasXTimePassed(snowman_key, 0.3)) {
            this.rotate_right();
        } else if (timeChecker.hasXTimePassed(snowman_key, 0.4)) {
            this.rotate_right();
            if (this.inital_rotation) {
                this.has_rotated = true;
                this.walking = false;
                this.inital_rotation = false;
            } else {
                this.inital_rotation = true;
            }
        }
    }

    private void rotate_left(TimeChecker timeChecker) {
        String snowman_key = "walking_snowman_" + this.y_offset;
        if (!timeChecker.hasName(snowman_key)) {
            timeChecker.addName(snowman_key);
        } else if (timeChecker.hasXTimePassed(snowman_key, 0.1)) {
            timeChecker.updateTime(snowman_key);
        }
        if (timeChecker.hasXTimePassed(snowman_key, 0.1)) {
            this.rotate_left();
        } else if (timeChecker.hasXTimePassed(snowman_key, 0.2)) {
            this.rotate_left();
        } else if (timeChecker.hasXTimePassed(snowman_key, 0.3)) {
            this.rotate_left();
        } else if (timeChecker.hasXTimePassed(snowman_key, 0.4)) {
            this.rotate_left();
            if (this.inital_rotation) {
                this.has_rotated = true;
                this.walking = false;
                this.inital_rotation = false;
            } else {
                this.inital_rotation = true;
            }
        }
    }

    private void rotate_left() {
        if (this.current_frame >= 1 && this.current_frame < 17) {
            ++this.current_frame;
        } else if (this.current_frame == 17) {
            this.current_frame = 1;
        }
    }

    private void rotate_right() {
        if (this.current_frame > 1 && this.current_frame <= 17) {
            --this.current_frame;
        } else if (this.current_frame == 1) {
            this.current_frame = 17;
        }
    }

    public void render_current_frame(class_332 context, int main_x, int main_y) {
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/christmas/rotating_snowmen/default/" + this.current_frame + ".png")), main_x + this.x_offset + this.x_steps, main_y + this.y_offset, 0.0f, 0.0f, 10, 14, 10, 14);
    }
}

