/*
 * Decompiled with CFR 0.152.
 */
package us.mikebartosh.minecraft.animatedinventory.mixin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_485;
import net.minecraft.class_490;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import us.mikebartosh.minecraft.animatedinventory.AnimatedInventory;
import us.mikebartosh.minecraft.animatedinventory.Box;
import us.mikebartosh.minecraft.animatedinventory.BoxManager;
import us.mikebartosh.minecraft.animatedinventory.BubbleManager;
import us.mikebartosh.minecraft.animatedinventory.Fly;
import us.mikebartosh.minecraft.animatedinventory.JumpingFrog;
import us.mikebartosh.minecraft.animatedinventory.MainFrogHelper;
import us.mikebartosh.minecraft.animatedinventory.MainSlimeHelper;
import us.mikebartosh.minecraft.animatedinventory.RandomPathGenerator;
import us.mikebartosh.minecraft.animatedinventory.RotatingSnowman;
import us.mikebartosh.minecraft.animatedinventory.SnowManager;
import us.mikebartosh.minecraft.animatedinventory.TimeChecker;
import us.mikebartosh.minecraft.animatedinventory.Values;
import us.mikebartosh.minecraft.animatedinventory.WalkingSnowman;

@Mixin(value={class_490.class})
public abstract class MixinInventoryScreen
extends class_485<class_1723> {
    @Shadow
    private float field_2935;
    @Shadow
    private float field_2934;
    @Shadow
    private boolean field_2930;
    @Unique
    TimeChecker timeCheck = new TimeChecker();
    @Unique
    List<Fly> flyList = new ArrayList<Fly>();
    @Unique
    Fly frogFlyPath;
    @Unique
    boolean createInitialStuff = true;
    @Unique
    final Random random = new Random();
    @Unique
    private int light_stage = 1;
    @Unique
    private SnowManager snowManager;
    @Unique
    private BubbleManager bubbleManager;
    @Unique
    List<RotatingSnowman> rotatingSnowmanList = new ArrayList<RotatingSnowman>();
    @Unique
    List<WalkingSnowman> walkingSnowmanList = new ArrayList<WalkingSnowman>();
    @Unique
    private boolean spawnBurst = true;
    @Unique
    private int beltStage = 1;
    @Unique
    private int lightStage = 1;
    @Unique
    private BoxManager boxManager;
    @Unique
    private int boxSpawnCycle = 1;
    @Unique
    private int catSitCycle = 1;
    @Unique
    private boolean isMovingSlimeBall = false;
    @Unique
    private boolean isMovingSlimeSponge = false;
    @Unique
    private boolean renderFallingSlimeSponge = false;
    @Unique
    private boolean renderStaticSlimeSponge = true;
    @Unique
    private boolean isBigPipeRendering = false;
    @Unique
    private boolean isRenderingSlimeBallContainerDepleting = false;
    @Unique
    private final List<MainSlimeHelper.ThrownSlimeball> thrownSlimeBalls = new ArrayList<MainSlimeHelper.ThrownSlimeball>();
    @Unique
    private final List<MainSlimeHelper.ThrownSlimeSponge> thrownSlimeSponges = new ArrayList<MainSlimeHelper.ThrownSlimeSponge>();
    @Unique
    private final List<MainSlimeHelper.FallingSlimePixel> fallingSlimePixels = new ArrayList<MainSlimeHelper.FallingSlimePixel>();
    @Unique
    private static MainSlimeHelper.MovingSlimeball currentMovingSlimeBall = null;
    @Unique
    private static MainSlimeHelper.MovingSlimeSponge currentMovingSlimeSponge = null;
    @Unique
    private final List<MainSlimeHelper.SlimeSlotAnimation> slimeSlotAnimations = new ArrayList<MainSlimeHelper.SlimeSlotAnimation>();
    @Unique
    private final List<MainSlimeHelper.SlimeSlotSpongeClearAnimation> slimeSlotSpongeAnimations = new ArrayList<MainSlimeHelper.SlimeSlotSpongeClearAnimation>();
    @Unique
    private MainSlimeHelper.SlimePipeAnimation slimePipe;
    @Unique
    private MainSlimeHelper.SlimePipeAnimation slimePipe2;
    @Unique
    private MainSlimeHelper.MirroredSlimePipeAnimation slimePipeM;
    @Unique
    private MainSlimeHelper.CutSlimePipeAnimation slimePipeCut;
    @Unique
    private MainSlimeHelper.BigSlimePipeAnimation bigSlimePipe;
    @Unique
    private MainSlimeHelper.IdleSlimeAnimation idleSlimeAnimation;
    @Unique
    private MainSlimeHelper.SlimeSpongeFall slimeSpongeFall;

    public MixinInventoryScreen(class_1723 screenHandler, class_1661 playerInventory, class_2561 text) {
        super((class_1703)screenHandler, playerInventory, text);
    }

    @Inject(method={"drawBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void drawAnimatedBackground(class_332 context, float delta, int mouseX, int mouseY, CallbackInfo ci) {
        Values config = (Values)AutoConfig.getConfigHolder(Values.class).getConfig();
        assert (this.field_22787 != null && this.field_22787.field_1724 != null);
        this.lnm$drawBackgroundTexture(config.texture_level, context, config.inventory_theme);
        if (this.createInitialStuff) {
            this.createInitialStuff(config.inventory_theme);
        }
        if (config.animation_state == 0) {
            return;
        }
        if (config.animation_state == 1) {
            return;
        }
        switch (config.inventory_theme) {
            case 0: {
                this.lnm$runFrogTheme(config, context);
                break;
            }
            case 1: {
                this.lnm$runChristmasTheme(context);
                break;
            }
            case 2: {
                this.lnm$runTreeTheme(context);
                break;
            }
            case 3: {
                this.lnm$runBubbleTheme(context);
                break;
            }
            case 4: {
                this.lnm$runFactoryTheme(context);
                break;
            }
            case 5: {
                this.lnm$runCatTheme(context);
                break;
            }
            case 6: {
                this.lnm$runSlimeTheme(context);
            }
        }
        ci.cancel();
    }

    @Unique
    private void createInitialStuff(int theme) {
        if (theme == 0) {
            int[][] waypoints = new int[][]{{this.random.nextInt(this.field_2776, this.field_2776 + 176), this.field_2800 + 27}, {this.random.nextInt(this.field_2776, this.field_2776 + 176), this.field_2800 + 45}, {this.field_2776 + 104, this.field_2800 + 55}};
            this.frogFlyPath = new Fly(new RandomPathGenerator(this.field_2776 + 141, this.field_2800 + 3, waypoints, 1));
            int[][] waypoints_2 = new int[][]{{this.random.nextInt(this.field_2776, this.field_2776 + 176), this.random.nextInt(this.field_2800, this.field_2800 + 166)}, {this.field_2776 + 176, this.random.nextInt(this.field_2800, this.field_2800 + 166)}, {this.field_2776 + 20, this.random.nextInt(this.field_2800, this.field_2800 + 166)}};
            this.flyList.add(new Fly(new RandomPathGenerator(this.field_2776 + 130, this.random.nextInt(this.field_2800, this.field_2800 + 166), waypoints_2, 1)));
            if (AnimatedInventory.jumpingFrogs.isEmpty()) {
                AnimatedInventory.jumpingFrogs.add(new JumpingFrog(135, 75, new int[][]{{162, 169}, {77, 83}, {135, 142}, {94, 100}}, this.timeCheck, "jumping_frog_1", 1, false));
                AnimatedInventory.jumpingFrogs.add(new JumpingFrog(16, 133, new int[][]{{43, 49}, {135, 142}, {16, 22}, {152, 158}}, this.timeCheck, "jumping_frog_2", 1, true));
                AnimatedInventory.jumpingFrogs.add(new JumpingFrog(68, -1, new int[][]{{68, 75}, {1, 7}, {98, 105}, {11, 17}}, this.timeCheck, "jumping_frog_2", 2, false));
            }
            if (!this.timeCheck.hasName("hole_frog")) {
                this.timeCheck.addName("hole_frog");
            }
            if (!this.timeCheck.hasName("jumping_frog_1")) {
                this.timeCheck.addName("jumping_frog_1");
            }
        } else if (theme == 1) {
            if (!this.timeCheck.hasName("christmas_lights")) {
                this.timeCheck.addName("christmas_lights");
            }
            if (!this.timeCheck.hasName("snow_fall_cycle")) {
                this.timeCheck.addName("snow_fall_cycle");
            }
            if (!this.timeCheck.hasName("snow_spawn_cycle")) {
                this.timeCheck.addName("snow_spawn_cycle");
            }
            if (!this.timeCheck.hasName("snowman_spin_cycle")) {
                this.timeCheck.addName("snowman_spin_cycle");
            }
            if (!this.timeCheck.hasName("walking_snowman_cycle")) {
                this.timeCheck.addName("walking_snowman_cycle");
            }
            this.snowManager = new SnowManager();
            this.rotatingSnowmanList.add(new RotatingSnowman(82, 47, "default", "left"));
            this.rotatingSnowmanList.add(new RotatingSnowman(154, 13, "hands_up", "right", 6));
            this.walkingSnowmanList.add(new WalkingSnowman(158, 69));
        } else if (theme == 3) {
            if (!this.timeCheck.hasName("bubble_rise_cycle")) {
                this.timeCheck.addName("bubble_rise_cycle");
            }
            if (!this.timeCheck.hasName("bubble_spawn_cycle")) {
                this.timeCheck.addName("bubble_spawn_cycle");
            }
            this.bubbleManager = new BubbleManager();
        } else if (theme == 4) {
            if (!this.timeCheck.hasName("belt_clock")) {
                this.timeCheck.addName("belt_clock");
            }
            if (!this.timeCheck.hasName("light_clock")) {
                this.timeCheck.addName("light_clock");
            }
            if (!this.timeCheck.hasName("box_spawn_clock")) {
                this.timeCheck.addName("box_spawn_clock");
            }
            if (!this.timeCheck.hasName("box_move_clock")) {
                this.timeCheck.addName("box_move_clock");
            }
            this.boxManager = new BoxManager();
        } else if (theme == 5) {
            if (!this.timeCheck.hasName("sitting_cat_1")) {
                this.timeCheck.addName("sitting_cat_1");
            }
        } else if (theme == 6) {
            this.slimePipe = new MainSlimeHelper.SlimePipeAnimation(this.random, 176, 9, this.timeCheck);
            this.slimePipe2 = new MainSlimeHelper.SlimePipeAnimation(this.random, 176, 119, this.timeCheck);
            this.slimePipeM = new MainSlimeHelper.MirroredSlimePipeAnimation(this.random, -13, 92, this.timeCheck);
            this.slimePipeCut = new MainSlimeHelper.CutSlimePipeAnimation(this.random, -13, 35, this.timeCheck);
            this.bigSlimePipe = new MainSlimeHelper.BigSlimePipeAnimation(this.random, -56, 110, this.timeCheck);
            this.idleSlimeAnimation = new MainSlimeHelper.IdleSlimeAnimation(this.random, 77, 46, this.timeCheck);
            if (!this.timeCheck.hasName("slimeBallTankCooldown")) {
                this.timeCheck.addName("slimeBallTankCooldown");
            }
            if (!this.timeCheck.hasName("fallingSlimePixels")) {
                this.timeCheck.addName("fallingSlimePixels");
            }
        }
        this.createInitialStuff = false;
    }

    @Unique
    private void lnm$drawBackgroundTexture(int textureLevel, class_332 context, int inventoryTheme) {
        class_2960 backgroundTexture = field_2801;
        if (textureLevel == 1) {
            switch (inventoryTheme) {
                case 0: {
                    backgroundTexture = class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/inventory-background/frog_inventory.png");
                    break;
                }
                case 1: {
                    backgroundTexture = class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/inventory-background/christmas_inventory.png");
                    break;
                }
                case 3: {
                    backgroundTexture = class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/inventory-background/underwater_inventory.png");
                    break;
                }
                case 4: 
                case 5: {
                    backgroundTexture = class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/inventory-background/factory_inventory.png");
                    break;
                }
                case 6: {
                    backgroundTexture = class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/inventory-background/slime_inventory.png");
                }
            }
        }
        int x = this.field_2776;
        int y = this.field_2800;
        context.method_25290(backgroundTexture, x, y, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_490.method_2486((class_332)context, (int)(x + 26), (int)(y + 8), (int)(x + 75), (int)(y + 78), (int)30, (float)0.0625f, (float)((float)(x + 51) - this.field_2935), (float)((float)(y + 75 - 50) - this.field_2934), (class_1309)this.field_22787.field_1724);
        }
    }

    @Unique
    private void lnm$runFrogTheme(Values config, class_332 context) {
        boolean hasXTimePassed = this.timeCheck.hasXTimePassed("hole_frog", 5.0);
        if (hasXTimePassed && !AnimatedInventory.run_frog) {
            String path = "hole-frog";
            if (config.vivid_textures) {
                path = "hole-frog-vivid";
            }
            context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/frogs/" + path + "/hole-frog-0.png")), this.field_2776 + 104, this.field_2800 + 45, 0.0f, 0.0f, 58, 39, 58, 39);
            this.frogFlyPath.drawFrogFlyPath(context, 150, this.random, this.field_2776, this.field_2800, this.timeCheck);
        } else if (!hasXTimePassed && !AnimatedInventory.run_frog) {
            String path = "hole-frog";
            if (config.vivid_textures) {
                path = "hole-frog-vivid";
            }
            context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/frogs/" + path + "/hole-frog-0.png")), this.field_2776 + 104, this.field_2800 + 45, 0.0f, 0.0f, 58, 39, 58, 39);
        }
        if (AnimatedInventory.run_frog) {
            MainFrogHelper.runFrogHoleAnimation(context, config.vivid_textures, this.timeCheck, this.field_2776, this.field_2800);
        }
        MainFrogHelper.checkForFrogClick(this.field_2935, this.field_2934, this.field_2776, this.field_2800);
        MainFrogHelper.drawFrogs(context, config.vivid_textures, this.field_2776, this.field_2800);
        MainFrogHelper.drawAllFlyPaths(context, this.flyList, this.field_2776, this.field_2800, this.random);
    }

    @Unique
    private void lnm$runChristmasTheme(class_332 context) {
        if (this.timeCheck.hasXTimePassed("snowman_spin_cycle", 0.05)) {
            for (RotatingSnowman snowman : this.rotatingSnowmanList) {
                snowman.rotate();
                this.timeCheck.updateTime("snowman_spin_cycle");
            }
        }
        for (RotatingSnowman snowman : this.rotatingSnowmanList) {
            snowman.render_current_frame(context, this.field_2776, this.field_2800);
        }
        boolean has1SecPassed = this.timeCheck.hasXTimePassed("christmas_lights", 1.0);
        boolean has2SecPassed = this.timeCheck.hasXTimePassed("christmas_lights", 1.05);
        boolean has3SecPassed = this.timeCheck.hasXTimePassed("christmas_lights", 1.1);
        boolean has4SecPassed = this.timeCheck.hasXTimePassed("christmas_lights", 2.1);
        boolean has5SecPassed = this.timeCheck.hasXTimePassed("christmas_lights", 2.15);
        boolean has6SecPassed = this.timeCheck.hasXTimePassed("christmas_lights", 2.2);
        if (has6SecPassed) {
            this.light_stage = 1;
            this.timeCheck.updateTime("christmas_lights");
        } else if (has5SecPassed) {
            this.light_stage = 2;
        } else if (has4SecPassed) {
            this.light_stage = 3;
        } else if (has3SecPassed) {
            this.light_stage = 4;
        } else if (has2SecPassed) {
            this.light_stage = 3;
        } else if (has1SecPassed) {
            this.light_stage = 2;
        }
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/christmas/hanging-lights/hanging-lights-" + this.light_stage + ".png")), this.field_2776 + 0, this.field_2800 + 0, 0.0f, 0.0f, 176, 83, 176, 83);
        if (this.timeCheck.hasXTimePassed("snow_spawn_cycle", 0.4)) {
            this.snowManager.createTopSnowFall(6);
            this.timeCheck.updateTime("snow_spawn_cycle");
        }
        if (this.timeCheck.hasXTimePassed("snow_fall_cycle", 0.05)) {
            this.snowManager.stepSnowFall();
            this.timeCheck.updateTime("snow_fall_cycle");
        }
        this.snowManager.renderSnowFall(context, this.field_2776, this.field_2800);
    }

    @Unique
    private void lnm$runTreeTheme(class_332 context) {
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/forests/test_tree.png"), this.field_2776 + 126, this.field_2800 - 16, 0.0f, 0.0f, 67, 197, 67, 197);
    }

    @Unique
    private void lnm$runBubbleTheme(class_332 context) {
        if (this.spawnBurst) {
            this.bubbleManager.createBottomBubbles(60, true);
            this.spawnBurst = false;
        }
        if (this.timeCheck.hasXTimePassed("bubble_spawn_cycle", 0.8)) {
            this.bubbleManager.createBottomBubbles(2, false);
            this.timeCheck.updateTime("bubble_spawn_cycle");
        }
        if (this.timeCheck.hasXTimePassed("bubble_rise_cycle", 0.045)) {
            this.bubbleManager.stepBubbles();
            this.timeCheck.updateTime("bubble_rise_cycle");
        }
        if (AnimatedInventory.left_mouse_clicked) {
            this.bubbleManager.checkForClick((int)this.field_2935, (int)this.field_2934, this.field_2776, this.field_2800);
        }
        this.bubbleManager.renderBubbles(context, this.field_2776, this.field_2800, this.timeCheck);
    }

    @Unique
    private void lnm$runFactoryTheme(class_332 context) {
        float scaleFactor = 2.0f;
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/factory/ladder.png"), this.field_2776 - 3, this.field_2800 - 5, 0.0f, 0.0f, 16, 91, 16, 91);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/factory/box_1.png"), this.field_2776 + 80, this.field_2800 + 52, 0.0f, 0.0f, 13, 9, 13, 9);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/factory/belt_support.png"), this.field_2776 + 163, this.field_2800 + 166, 0.0f, 0.0f, 8, 9, 8, 9);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/factory/belt_support.png"), this.field_2776 + 37, this.field_2800 + 166, 0.0f, 0.0f, 8, 9, 8, 9);
        if (this.timeCheck.hasXTimePassed("belt_clock", 0.1)) {
            this.beltStage = this.beltStage <= 3 ? ++this.beltStage : 1;
            this.timeCheck.updateTime("belt_clock");
        }
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/factory/belt_" + this.beltStage + ".png")), this.field_2776 + 35, this.field_2800 + 175, 0.0f, 0.0f, 208, 8, 208, 8);
        if (this.timeCheck.hasXTimePassed("light_clock", 0.16)) {
            this.light_stage = this.light_stage >= 2 ? --this.light_stage : 4;
            this.timeCheck.updateTime("light_clock");
        }
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/factory/left_light_" + this.light_stage + ".png")), this.field_2776 + 26, this.field_2800 + 9, 0.0f, 0.0f, 13, 8, 13, 8);
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/factory/right_light_" + this.light_stage + ".png")), this.field_2776 + 62, this.field_2800 + 9, 0.0f, 0.0f, 13, 8, 13, 8);
        if (this.timeCheck.hasXTimePassed("box_spawn_clock", this.boxSpawnCycle)) {
            this.boxManager.addBox();
            this.timeCheck.updateTime("box_spawn_clock");
            this.boxSpawnCycle = this.random.nextInt(3, 9);
        }
        if (this.timeCheck.hasXTimePassed("box_move_clock", 0.044)) {
            this.boxManager.stepAll();
            this.timeCheck.updateTime("box_move_clock");
        }
        this.boxManager.removeFinishedBoxes(class_310.method_1551().method_22683().method_4502(), 2.0f);
        for (Box box : this.boxManager.getBoxes()) {
            context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/factory/moving_box/" + box.getTexture() + ".png")), this.field_2776 + (int)((float)box.getX() / 2.0f), this.field_2800 + (int)((float)box.getY() / 2.0f), 0.0f, 0.0f, (int)((float)box.getTexture_x() / 2.0f), (int)((float)box.getTexture_y() / 2.0f), (int)((float)box.getTexture_x() / 2.0f), (int)((float)box.getTexture_y() / 2.0f));
        }
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/factory/pipe_out.png"), this.field_2776 + 176, this.field_2800 + 147, 0.0f, 0.0f, 12, 16, 12, 16);
    }

    @Unique
    private void lnm$runCatTheme(class_332 context) {
        float scaleFactor = 2.0f;
        if (this.timeCheck.hasXTimePassed("sitting_cat_1", 0.2)) {
            if (this.catSitCycle == 14) {
                this.catSitCycle = 1;
            }
            ++this.catSitCycle;
            this.timeCheck.updateTime("sitting_cat_1");
        }
        context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/cats/cat_1/cat_" + this.catSitCycle + ".png")), this.field_2776 + 77, this.field_2800 + 50, 0.0f, 0.0f, 14, 11, 14, 11);
    }

    @Unique
    private void lnm$runSlimeTheme(class_332 context) {
        String texture;
        Object textureFile;
        String direction;
        int drawY;
        int drawX;
        Object anim;
        context.method_25290(this.slimePipe.getTexture(), this.field_2776 + this.slimePipe.X, this.field_2800 + this.slimePipe.Y, 0.0f, 0.0f, 13, 42, 13, 42);
        this.slimePipe.tick(this.timeCheck);
        context.method_25290(this.slimePipe2.getTexture(), this.field_2776 + this.slimePipe2.X, this.field_2800 + this.slimePipe2.Y, 0.0f, 0.0f, 13, 42, 13, 42);
        this.slimePipe2.tick(this.timeCheck);
        context.method_25290(this.slimePipeM.getTexture(), this.field_2776 + this.slimePipeM.X, this.field_2800 + this.slimePipeM.Y, 0.0f, 0.0f, 13, 42, 13, 42);
        this.slimePipeM.tick(this.timeCheck);
        context.method_25290(this.slimePipeCut.getTexture(), this.field_2776 + this.slimePipeCut.X, this.field_2800 + this.slimePipeCut.Y, 0.0f, 0.0f, 13, 11, 13, 11);
        this.slimePipeCut.tick(this.timeCheck);
        if (this.isBigPipeRendering) {
            context.method_25290(this.bigSlimePipe.getTexture(), this.field_2776 + this.bigSlimePipe.X, this.field_2800 + this.bigSlimePipe.Y, 0.0f, 0.0f, 56, 500, 56, 500);
            if (this.bigSlimePipe.isDone()) {
                this.isBigPipeRendering = false;
            } else {
                this.bigSlimePipe.tick(this.timeCheck);
            }
        } else {
            context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/big_pipe.png"), this.field_2776 - 14, this.field_2800 + 145, 0.0f, 0.0f, 14, 15, 14, 15);
        }
        context.method_25290(this.idleSlimeAnimation.getTexture(), this.field_2776 + this.idleSlimeAnimation.X, this.field_2800 + this.idleSlimeAnimation.Y, 0.0f, 0.0f, 15, 15, 15, 15);
        this.idleSlimeAnimation.tick(this.timeCheck);
        MainSlimeHelper.drawStaticTextures(context, this.field_2776, this.field_2800);
        if (this.renderFallingSlimeSponge) {
            if (this.slimeSpongeFall == null) {
                this.slimeSpongeFall = new MainSlimeHelper.SlimeSpongeFall(this.timeCheck, this.field_2776 + 158, this.field_2800 + 79);
            }
            if (!this.slimeSpongeFall.isDone()) {
                this.slimeSpongeFall.tick(this.timeCheck);
                this.slimeSpongeFall.render(context);
            } else {
                this.renderFallingSlimeSponge = false;
                this.renderStaticSlimeSponge = true;
                this.slimeSpongeFall = null;
            }
        }
        if (this.renderStaticSlimeSponge) {
            context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/slime_sponge.png"), this.field_2776 + 158, this.field_2800 + 79, 0.0f, 0.0f, 8, 4, 8, 4);
        }
        if (!AnimatedInventory.left_mouse_clicked && this.isMovingSlimeBall) {
            this.isMovingSlimeBall = false;
            if (currentMovingSlimeBall != null) {
                boolean slimeBallUsed = false;
                if (MixinInventoryScreen.currentMovingSlimeBall.mouseX >= (double)(this.field_2776 - 16) && MixinInventoryScreen.currentMovingSlimeBall.mouseX <= (double)(this.field_2776 - 3) && MixinInventoryScreen.currentMovingSlimeBall.mouseY >= (double)(this.field_2800 + 17) && MixinInventoryScreen.currentMovingSlimeBall.mouseY <= (double)(this.field_2800 + 35) && AnimatedInventory.slimeBucketLevel < 7) {
                    ++AnimatedInventory.slimeBucketLevel;
                    slimeBallUsed = true;
                } else {
                    for (class_1735 slot : ((class_1723)this.field_2797).field_7761) {
                        int slotX = this.field_2776 + slot.field_7873;
                        slotY = this.field_2800 + slot.field_7872;
                        if (!(MixinInventoryScreen.currentMovingSlimeBall.mouseX >= (double)slotX) || !(MixinInventoryScreen.currentMovingSlimeBall.mouseX <= (double)(slotX + 16)) || !(MixinInventoryScreen.currentMovingSlimeBall.mouseY >= (double)slotY) || !(MixinInventoryScreen.currentMovingSlimeBall.mouseY <= (double)(slotY + 16))) continue;
                        int offsetX = slotX - this.field_2776 - 1;
                        offsetY = slotY - this.field_2800 - 1;
                        this.slimeSlotAnimations.add(new MainSlimeHelper.SlimeSlotAnimation(this.random, offsetX, offsetY, this.timeCheck));
                        slimeBallUsed = true;
                        break;
                    }
                }
                if (!slimeBallUsed) {
                    double throwVelocityX = MixinInventoryScreen.currentMovingSlimeBall.deltaX;
                    double throwVelocityY = MixinInventoryScreen.currentMovingSlimeBall.deltaY;
                    double maxVel = 8.0;
                    throwVelocityX = Math.max(-maxVel, Math.min(maxVel, throwVelocityX));
                    throwVelocityY = Math.max(-maxVel, Math.min(maxVel, throwVelocityY));
                    this.thrownSlimeBalls.add(new MainSlimeHelper.ThrownSlimeball(MixinInventoryScreen.currentMovingSlimeBall.mouseX, MixinInventoryScreen.currentMovingSlimeBall.mouseY, throwVelocityX, throwVelocityY));
                }
            }
            currentMovingSlimeBall = null;
        } else if (!AnimatedInventory.left_mouse_clicked && this.isMovingSlimeSponge) {
            this.isMovingSlimeSponge = false;
            if (currentMovingSlimeSponge != null) {
                boolean placedInSlot = false;
                for (class_1735 slot : ((class_1723)this.field_2797).field_7761) {
                    int offsetX;
                    boolean removed;
                    int slotX = this.field_2776 + slot.field_7873;
                    slotY = this.field_2800 + slot.field_7872;
                    if (!(MixinInventoryScreen.currentMovingSlimeSponge.mouseX >= (double)slotX) || !(MixinInventoryScreen.currentMovingSlimeSponge.mouseX <= (double)(slotX + 16)) || !(MixinInventoryScreen.currentMovingSlimeSponge.mouseY >= (double)slotY) || !(MixinInventoryScreen.currentMovingSlimeSponge.mouseY <= (double)(slotY + 16)) || !(removed = AnimatedInventory.slimedSlots.removeIf(arg_0 -> MixinInventoryScreen.lambda$lnm$runSlimeTheme$0(offsetY = slotY - this.field_2800 - 1, offsetX = slotX - this.field_2776 - 1, arg_0)))) continue;
                    placedInSlot = true;
                    this.slimeSlotSpongeAnimations.add(new MainSlimeHelper.SlimeSlotSpongeClearAnimation(this.random, offsetX, offsetY, this.timeCheck));
                    break;
                }
                if (!placedInSlot) {
                    double throwVelocityX = MixinInventoryScreen.currentMovingSlimeSponge.deltaX;
                    double throwVelocityY = MixinInventoryScreen.currentMovingSlimeSponge.deltaY;
                    double maxVel = 6.5;
                    throwVelocityX = Math.max(-maxVel, Math.min(maxVel, throwVelocityX));
                    throwVelocityY = Math.max(-maxVel, Math.min(maxVel, throwVelocityY));
                    this.thrownSlimeSponges.add(new MainSlimeHelper.ThrownSlimeSponge(MixinInventoryScreen.currentMovingSlimeSponge.mouseX, MixinInventoryScreen.currentMovingSlimeSponge.mouseY, throwVelocityX, throwVelocityY));
                }
            }
            currentMovingSlimeSponge = null;
        }
        if (!this.slimeSlotAnimations.isEmpty()) {
            Iterator<MainSlimeHelper.SlimeSlotAnimation> iterator = this.slimeSlotAnimations.iterator();
            while (iterator.hasNext()) {
                anim = iterator.next();
                context.method_25290(((MainSlimeHelper.SlimeSlotAnimation)anim).getTexture(), this.field_2776 + ((MainSlimeHelper.SlimeSlotAnimation)anim).slotX, this.field_2800 + ((MainSlimeHelper.SlimeSlotAnimation)anim).slotY, 0.0f, 0.0f, 18, 18, 18, 18);
                if (((MainSlimeHelper.SlimeSlotAnimation)anim).isDone()) {
                    AnimatedInventory.slimedSlots.add(new MainSlimeHelper.SlotPosition(((MainSlimeHelper.SlimeSlotAnimation)anim).slotX, ((MainSlimeHelper.SlimeSlotAnimation)anim).slotY));
                    iterator.remove();
                    continue;
                }
                ((MainSlimeHelper.SlimeSlotAnimation)anim).tick(this.timeCheck);
            }
        }
        if (!this.slimeSlotSpongeAnimations.isEmpty()) {
            Iterator<MainSlimeHelper.SlimeSlotSpongeClearAnimation> iterator = this.slimeSlotSpongeAnimations.iterator();
            while (iterator.hasNext()) {
                anim = iterator.next();
                context.method_25290(((MainSlimeHelper.SlimeSlotSpongeClearAnimation)anim).getTexture(), this.field_2776 + ((MainSlimeHelper.SlimeSlotSpongeClearAnimation)anim).slotX, this.field_2800 + ((MainSlimeHelper.SlimeSlotSpongeClearAnimation)anim).slotY, 0.0f, 0.0f, 18, 18, 18, 18);
                if (((MainSlimeHelper.SlimeSlotSpongeClearAnimation)anim).isDone()) {
                    iterator.remove();
                    this.renderFallingSlimeSponge = true;
                    continue;
                }
                ((MainSlimeHelper.SlimeSlotSpongeClearAnimation)anim).tick(this.timeCheck);
            }
        }
        if (!AnimatedInventory.slimedSlots.isEmpty()) {
            for (MainSlimeHelper.SlotPosition pos : AnimatedInventory.slimedSlots) {
                context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/slotslime_14.png"), this.field_2776 + pos.slotX(), this.field_2800 + pos.slotY(), 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
        if (AnimatedInventory.left_mouse_clicked && !this.isMovingSlimeBall && !this.isMovingSlimeSponge && this.field_2935 >= (float)(this.field_2776 + 18) && this.field_2935 <= (float)(this.field_2776 + 18 + 18) && this.field_2934 >= (float)(this.field_2800 - 10) && this.field_2934 <= (float)(this.field_2800 - 10 + 9)) {
            this.isMovingSlimeBall = true;
            AnimatedInventory.mouse_drag_data = List.of(Double.valueOf(this.field_2935), Double.valueOf(this.field_2934), Double.valueOf(0.0), Double.valueOf(0.0));
        }
        if (AnimatedInventory.left_mouse_clicked && !this.isMovingSlimeSponge && !this.isMovingSlimeBall && this.renderStaticSlimeSponge && this.field_2935 >= (float)(this.field_2776 + 158) && this.field_2935 <= (float)(this.field_2776 + 158 + 8) && this.field_2934 >= (float)(this.field_2800 + 79) && this.field_2934 <= (float)(this.field_2800 + 79 + 4)) {
            this.isMovingSlimeSponge = true;
            this.renderStaticSlimeSponge = false;
            AnimatedInventory.mouse_drag_data = List.of(Double.valueOf(this.field_2935), Double.valueOf(this.field_2934), Double.valueOf(0.0), Double.valueOf(0.0));
        }
        if (AnimatedInventory.left_mouse_clicked && !this.isMovingSlimeSponge && !this.isMovingSlimeBall && !this.isBigPipeRendering && AnimatedInventory.slimeBucketLevel >= 7 && this.field_2935 >= (float)(this.field_2776 - 13) && this.field_2935 <= (float)(this.field_2776 - 10) && this.field_2934 >= (float)(this.field_2800 + 143) && this.field_2934 <= (float)(this.field_2800 + 145)) {
            this.isBigPipeRendering = true;
            this.isRenderingSlimeBallContainerDepleting = true;
            this.timeCheck.updateTime("slimeBallTankCooldown");
            AnimatedInventory.mouse_drag_data = List.of(Double.valueOf(this.field_2935), Double.valueOf(this.field_2934), Double.valueOf(0.0), Double.valueOf(0.0));
        }
        if (this.isMovingSlimeBall && AnimatedInventory.mouse_drag_data != null && AnimatedInventory.mouse_drag_data.size() >= 4) {
            double mouseX = AnimatedInventory.mouse_drag_data.get(0);
            double mouseY = AnimatedInventory.mouse_drag_data.get(1);
            double deltaX = AnimatedInventory.mouse_drag_data.get(2);
            double deltaY = AnimatedInventory.mouse_drag_data.get(3);
            drawX = (int)(mouseX - 4.5);
            drawY = (int)(mouseY - 4.5);
            direction = MainSlimeHelper.isMouseStatic(mouseX, mouseY) ? "idle" : MainSlimeHelper.getDirection(deltaX, deltaY);
            textureFile = direction.equals("idle") ? "slime_ball.png" : "slime_ball_" + direction + ".png";
            texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/" + (String)textureFile));
            context.method_25290((class_2960)texture, drawX, drawY, 0.0f, 0.0f, 9, 9, 9, 9);
            currentMovingSlimeBall = new MainSlimeHelper.MovingSlimeball(mouseX, mouseY, deltaX, deltaY);
        }
        if (this.isMovingSlimeSponge && AnimatedInventory.mouse_drag_data != null && AnimatedInventory.mouse_drag_data.size() >= 4) {
            double mouseX = AnimatedInventory.mouse_drag_data.get(0);
            double mouseY = AnimatedInventory.mouse_drag_data.get(1);
            double deltaX = AnimatedInventory.mouse_drag_data.get(2);
            double deltaY = AnimatedInventory.mouse_drag_data.get(3);
            drawX = (int)(mouseX - 4.5);
            drawY = (int)(mouseY - 4.5);
            direction = MainSlimeHelper.isMouseStatic(mouseX, mouseY) ? "idle" : MainSlimeHelper.getDirection(deltaX, deltaY);
            textureFile = "slime_sponge.png";
            switch (direction) {
                case "up_right": 
                case "down_left": {
                    textureFile = "slime_sponge_down_left.png";
                    break;
                }
                case "down_right": 
                case "up_left": {
                    textureFile = "slime_sponge_up_left.png";
                }
            }
            texture = class_2960.method_43902((String)"animated-inventory", (String)("textures/gui/animated-inventory-textures/slime_theme/" + (String)textureFile));
            context.method_25290((class_2960)texture, drawX, drawY + 3, 0.0f, 0.0f, 8, 4, 8, 4);
            currentMovingSlimeSponge = new MainSlimeHelper.MovingSlimeSponge(mouseX, mouseY, deltaX, deltaY);
        }
        if (!this.thrownSlimeBalls.isEmpty()) {
            Iterator<MainSlimeHelper.ThrownSlimeball> iterator = this.thrownSlimeBalls.iterator();
            while (iterator.hasNext()) {
                MainSlimeHelper.ThrownSlimeball ball = iterator.next();
                ball.tick();
                if (ball.isOffScreen(context.method_51421(), context.method_51443())) {
                    iterator.remove();
                    continue;
                }
                context.method_25290(ball.getTexture(), ball.getDrawX(), ball.getDrawY(), 0.0f, 0.0f, 9, 9, 9, 9);
            }
        }
        if (!this.thrownSlimeSponges.isEmpty()) {
            Iterator<MainSlimeHelper.ThrownSlimeSponge> iterator = this.thrownSlimeSponges.iterator();
            while (iterator.hasNext()) {
                MainSlimeHelper.ThrownSlimeSponge sponge = iterator.next();
                sponge.tick();
                if (sponge.isOffScreen(context.method_51421(), context.method_51443())) {
                    iterator.remove();
                    this.renderFallingSlimeSponge = true;
                    continue;
                }
                context.method_25290(sponge.getTexture(), sponge.getDrawX(), sponge.getDrawY(), 0.0f, 0.0f, 8, 4, 8, 4);
            }
        }
        if (this.isRenderingSlimeBallContainerDepleting && this.timeCheck.hasXTimePassed("slimeBallTankCooldown", 0.05)) {
            this.timeCheck.updateTime("slimeBallTankCooldown");
            if (--AnimatedInventory.slimeBucketLevel == 1) {
                this.isRenderingSlimeBallContainerDepleting = false;
            }
        }
        MainSlimeHelper.drawSlimeContainerLevel(context, this.field_2776, this.field_2800);
        if ((double)this.random.nextFloat() < 0.02 && this.fallingSlimePixels.size() < 8) {
            this.fallingSlimePixels.add(new MainSlimeHelper.FallingSlimePixel(-1, 3.0, 34.0));
        }
        if (!this.fallingSlimePixels.isEmpty() && this.timeCheck.hasXTimePassed("fallingSlimePixels", 0.02)) {
            this.timeCheck.updateTime("fallingSlimePixels");
            Iterator<MainSlimeHelper.FallingSlimePixel> it = this.fallingSlimePixels.iterator();
            while (it.hasNext()) {
                MainSlimeHelper.FallingSlimePixel pixel = it.next();
                pixel.tick();
                context.method_25290(class_2960.method_43902((String)"animated-inventory", (String)"textures/gui/animated-inventory-textures/slime_theme/fallingslimepixel.png"), this.field_2776 + pixel.getX(), this.field_2800 + pixel.getY(), 0.0f, 0.0f, 1, 1, 1, 1);
                if (!pixel.isDone()) continue;
                it.remove();
            }
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0) {
            AnimatedInventory.mouse_drag_data = List.of(Double.valueOf(mouseX), Double.valueOf(mouseY), Double.valueOf(deltaX), Double.valueOf(deltaY));
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            AnimatedInventory.left_mouse_clicked = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            AnimatedInventory.left_mouse_clicked = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private static /* synthetic */ boolean lambda$lnm$runSlimeTheme$0(int offsetY, int offsetX, MainSlimeHelper.SlotPosition slimedSlot) {
        return slimedSlot.slotY() == offsetY && slimedSlot.slotX() == offsetX;
    }
}

