/*
 * Decompiled with CFR 0.152.
 */
package net.xiaoyu.you_have_treasure.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.xiaoyu.you_have_treasure.network.NetworkHandler;
import net.xiaoyu.you_have_treasure.util.TreasureUtil;

@EventBusSubscriber(modid="you_have_treasure")
public class TreasureRenderer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    @SubscribeEvent
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        event.getSkins().forEach(skinName -> {
            PlayerRenderer renderer = (PlayerRenderer)event.getSkin(skinName);
            if (renderer != null) {
                renderer.addLayer(new TreasureRenderer(renderer));
            }
        });
        for (EntityType entityType : event.getEntityTypes()) {
            LivingEntityRenderer livingRenderer;
            EntityRenderer renderer = event.getRenderer(entityType);
            if (!(renderer instanceof LivingEntityRenderer) || !((livingRenderer = (LivingEntityRenderer)renderer).getModel() instanceof HeadedModel)) continue;
            livingRenderer.addLayer(new TreasureRenderer(livingRenderer));
        }
    }

    public TreasureRenderer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        List<ItemStack> treasureItems = this.getCarriedTreasureItems(entity);
        if (!treasureItems.isEmpty()) {
            this.renderTreasureItems(poseStack, buffer, packedLight, entity, treasureItems);
        }
    }

    private List<ItemStack> getCarriedTreasureItems(T entity) {
        List<ItemStack> cachedItems;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player == Minecraft.getInstance().player) {
                return TreasureUtil.getCarriedTreasureItems((LivingEntity)player);
            }
            List<ItemStack> cachedItems2 = NetworkHandler.getTreasureItemsForEntity(player.getId());
            if (!cachedItems2.isEmpty()) {
                return cachedItems2;
            }
        }
        if (!(cachedItems = NetworkHandler.getTreasureItemsForEntity(entity.getId())).isEmpty()) {
            return cachedItems;
        }
        return TreasureUtil.getCarriedTreasureItems(entity);
    }

    private void renderTreasureItems(PoseStack poseStack, MultiBufferSource buffer, int packedLight, T entity, List<ItemStack> itemStacks) {
        poseStack.pushPose();
        ((HeadedModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
        for (int i = 0; i < itemStacks.size(); ++i) {
            poseStack.pushPose();
            poseStack.translate(0.0, (double)(-i) * 0.5, 0.0);
            if (itemStacks.get(i).getItem() instanceof BlockItem) {
                poseStack.translate(0.0, -0.75, 0.0);
            } else {
                poseStack.translate(0.0, -0.35, 0.0);
            }
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(0.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(itemStacks.get(i), ItemDisplayContext.HEAD, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), entity.getId());
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

