/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.Bubbles;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class BubbleBreathEffect {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final Map<Integer, Integer> lastAirValues = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> breathingTimers = new HashMap<Integer, Integer>();
    private static int cleanupTimer = 0;

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (!EffectualConfig.get().bubbleBreath || client.f_91073_ == null || client.m_91104_()) {
                return;
            }
            if (++cleanupTimer >= 100) {
                BubbleBreathEffect.cleanupMap(client.f_91073_.m_6907_());
                cleanupTimer = 0;
            }
            for (Player player : client.f_91073_.m_6907_()) {
                int breatheTicks;
                int id = player.m_19879_();
                if (BubbleBreathEffect.shouldPlayEffect(player)) {
                    boolean uiBubblePopped;
                    int currentAir = player.m_20146_();
                    int previousAir = lastAirValues.getOrDefault(id, currentAir);
                    lastAirValues.put(id, currentAir);
                    boolean airDecreased = currentAir < previousAir;
                    boolean bl = uiBubblePopped = currentAir % 30 == 0 && currentAir < 300;
                    if (airDecreased && uiBubblePopped) {
                        breathingTimers.put(id, 8);
                    }
                } else {
                    lastAirValues.remove(id);
                    breathingTimers.remove(id);
                }
                if ((breatheTicks = breathingTimers.getOrDefault(id, 0).intValue()) <= 0) continue;
                BubbleBreathEffect.processBreathTick(player);
                breathingTimers.put(id, breatheTicks - 1);
            }
        });
    }

    private static void cleanupMap(List<? extends Player> activePlayers) {
        Iterator<Integer> iterator = lastAirValues.keySet().iterator();
        while (iterator.hasNext()) {
            Integer id = iterator.next();
            if (!activePlayers.stream().noneMatch(p -> p.m_19879_() == id.intValue())) continue;
            iterator.remove();
            breathingTimers.remove(id);
        }
    }

    private static boolean shouldPlayEffect(Player player) {
        return player.m_5842_() && !player.m_5833_() && !player.m_7500_();
    }

    private static void processBreathTick(Player player) {
        float xRot = player.m_146909_();
        float yRot = player.m_146908_();
        float xRotRad = xRot * ((float)Math.PI / 180);
        float yRotRad = -yRot * ((float)Math.PI / 180);
        double lookX = Mth.m_14031_((float)yRotRad) * Mth.m_14089_((float)xRotRad);
        double lookY = -Mth.m_14031_((float)xRotRad);
        double lookZ = Mth.m_14089_((float)yRotRad) * Mth.m_14089_((float)xRotRad);
        double mouthOffsetForward = 0.25;
        double mouthOffsetDown = 0.15;
        double originX = player.m_20185_() + lookX * mouthOffsetForward;
        double originY = player.m_20188_() - mouthOffsetDown + lookY * mouthOffsetForward;
        double originZ = player.m_20189_() + lookZ * mouthOffsetForward;
        Vec3 playerVel = player.m_20184_();
        if (RANDOM.m_188499_()) {
            double velocityX = lookX * 0.1 + playerVel.f_82479_ * 0.8;
            double velocityY = lookY * 0.1 + playerVel.f_82480_ * 0.8 + 0.05;
            double velocityZ = lookZ * 0.1 + playerVel.f_82481_ * 0.8;
            TClientParticles.spawn((ParticleOptions)ParticleTypes.f_123795_, (double)originX, (double)originY, (double)originZ, (double)velocityX, (double)velocityY, (double)velocityZ);
        }
    }
}

