/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.CauldronFill;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CauldronFillEffect {
    private static final Map<Long, Snapshot> stateCache = new HashMap<Long, Snapshot>();
    private static final RandomSource RAND = RandomSource.m_216327_();
    private static int backgroundScanTimer = 0;
    private static int cleanupTimer = 0;

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (!EffectualConfig.get().cauldronFillEffect || client.f_91073_ == null || client.f_91074_ == null || client.m_91104_()) {
                return;
            }
            CauldronFillEffect.scanTargetedBlock(client);
            if (++backgroundScanTimer >= 10) {
                CauldronFillEffect.scanArea(client);
                backgroundScanTimer = 0;
            }
            if (++cleanupTimer >= 100) {
                CauldronFillEffect.cleanup(client.f_91074_.m_20183_());
                cleanupTimer = 0;
            }
        });
    }

    private static void scanTargetedBlock(Minecraft client) {
        HitResult hit = client.f_91077_;
        if (hit == null || hit.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)hit;
        BlockPos pos = blockHit.m_82425_();
        if (client.f_91074_.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > 36.0) {
            return;
        }
        CauldronFillEffect.checkBlock(client, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    private static void scanArea(Minecraft client) {
        BlockPos center = client.f_91074_.m_20183_();
        int radius = 6;
        int cx = center.m_123341_();
        int cy = center.m_123342_();
        int cz = center.m_123343_();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -1; dy <= 2; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    CauldronFillEffect.checkBlock(client, cx + dx, cy + dy, cz + dz);
                }
            }
        }
    }

    private static void checkBlock(Minecraft client, int x, int y, int z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        BlockState state = client.f_91073_.m_8055_((BlockPos)pos);
        Kind kind = CauldronFillEffect.kindOf(state.m_60734_());
        if (kind == null) {
            return;
        }
        long posKey = BlockPos.m_121882_((int)x, (int)y, (int)z);
        int level = CauldronFillEffect.currentLevel(state, kind);
        Snapshot prev = stateCache.get(posKey);
        if (prev == null) {
            stateCache.put(posKey, new Snapshot(kind, level));
            return;
        }
        boolean changed = false;
        if (kind != prev.kind) {
            if (kind != Kind.EMPTY) {
                CauldronFillEffect.spawnBurst((BlockPos)pos, kind, Math.max(1, level));
            }
            changed = true;
        } else if (level > prev.level) {
            CauldronFillEffect.spawnBurst((BlockPos)pos, kind, level - prev.level);
            changed = true;
        } else if (level != prev.level) {
            changed = true;
        }
        if (changed) {
            stateCache.put(posKey, new Snapshot(kind, level));
        }
    }

    private static void cleanup(BlockPos center) {
        long maxDistSqr = 256L;
        Iterator<Map.Entry<Long, Snapshot>> it = stateCache.entrySet().iterator();
        int cx = center.m_123341_();
        int cy = center.m_123342_();
        int cz = center.m_123343_();
        while (it.hasNext()) {
            int z;
            double dZ;
            int y;
            double dY;
            long posLong = it.next().getKey();
            int x = BlockPos.m_121983_((long)posLong);
            double dX = cx - x;
            double distSqr = dX * dX + (dY = (double)(cy - (y = BlockPos.m_122008_((long)posLong)))) * dY + (dZ = (double)(cz - (z = BlockPos.m_122015_((long)posLong)))) * dZ;
            if (!(distSqr > (double)maxDistSqr)) continue;
            it.remove();
        }
    }

    private static Kind kindOf(Block b) {
        if (b == Blocks.f_50256_) {
            return Kind.EMPTY;
        }
        if (b == Blocks.f_152476_) {
            return Kind.WATER;
        }
        if (b == Blocks.f_152477_) {
            return Kind.LAVA;
        }
        if (b == Blocks.f_152478_) {
            return Kind.POWDER;
        }
        return null;
    }

    private static int currentLevel(BlockState s, Kind k) {
        if (k == Kind.WATER || k == Kind.POWDER) {
            IntegerProperty p = BlockStateProperties.f_61418_;
            return s.m_61138_((Property)p) ? (Integer)s.m_61143_((Property)p) : 0;
        }
        if (k == Kind.LAVA) {
            return 3;
        }
        return 0;
    }

    private static void spawnBurst(BlockPos pos, Kind kind, int delta) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.94;
        double z = (double)pos.m_123343_() + 0.5;
        int base = kind == Kind.WATER ? 6 : (kind == Kind.LAVA ? 5 : 7);
        int count = base + RAND.m_188503_(3) + Math.min(4, delta * 2);
        block5: for (int i = 0; i < count; ++i) {
            double ox = (RAND.m_188500_() - 0.5) * 0.6;
            double oz = (RAND.m_188500_() - 0.5) * 0.6;
            double vx = (RAND.m_188500_() - 0.5) * 0.05;
            double vz = (RAND.m_188500_() - 0.5) * 0.05;
            switch (kind.ordinal()) {
                case 1: {
                    double vy = 0.05 + RAND.m_188500_() * 0.05;
                    TClientParticles.spawn((ParticleOptions)ParticleTypes.f_123769_, (double)(x + ox), (double)y, (double)(z + oz), (double)vx, (double)vy, (double)vz);
                    if (!(RAND.m_188501_() < 0.4f)) continue block5;
                    TClientParticles.spawn((ParticleOptions)ParticleTypes.f_123795_, (double)(x + ox * 0.7), (double)(y - 0.2), (double)(z + oz * 0.7), (double)0.0, (double)(0.02 + RAND.m_188500_() * 0.02), (double)0.0);
                    continue block5;
                }
                case 2: {
                    double vy = 0.04 + RAND.m_188500_() * 0.04;
                    TClientParticles.spawn((ParticleOptions)ParticleTypes.f_123756_, (double)(x + ox), (double)y, (double)(z + oz), (double)vx, (double)vy, (double)vz);
                    if (!(RAND.m_188501_() < 0.3f)) continue block5;
                    TClientParticles.spawn((ParticleOptions)ParticleTypes.f_123762_, (double)(x + ox), (double)(y + 0.1), (double)(z + oz), (double)0.0, (double)0.02, (double)0.0);
                    continue block5;
                }
                case 3: {
                    double vy = 0.03 + RAND.m_188500_() * 0.04;
                    TClientParticles.spawn((ParticleOptions)ParticleTypes.f_175821_, (double)(x + ox), (double)(y + 0.1), (double)(z + oz), (double)(vx * 0.5), (double)vy, (double)(vz * 0.5));
                    continue block5;
                }
            }
        }
    }

    private static enum Kind {
        EMPTY,
        WATER,
        LAVA,
        POWDER;

    }

    private static final class Snapshot {
        final Kind kind;
        final int level;

        Snapshot(Kind k, int l) {
            this.kind = k;
            this.level = l;
        }
    }
}

