/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.CaveDust;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CaveDustEffect {
    private static final RandomSource RAND = RandomSource.m_216327_();
    private static boolean inCaveCached = false;
    private static int checkTimer = 0;

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (!EffectualConfig.get().caveDust) {
                return;
            }
            if (client.f_91074_ == null || client.f_91073_ == null || client.m_91104_()) {
                return;
            }
            if (checkTimer++ >= 20) {
                checkTimer = 0;
                CaveDustEffect.updateCaveStatus(client);
            }
            if (!inCaveCached) {
                return;
            }
            CaveDustEffect.spawnDustParticles(client);
        });
    }

    private static void updateCaveStatus(Minecraft client) {
        BlockPos center = client.f_91074_.m_20183_();
        if (client.f_91073_.m_45517_(LightLayer.SKY, center) > 0) {
            inCaveCached = false;
            return;
        }
        if (client.f_91073_.m_45527_(center.m_7494_())) {
            inCaveCached = false;
            return;
        }
        int radius = 6;
        int naturalCount = 0;
        int artificialCount = 0;
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    mpos.m_122178_(center.m_123341_() + dx, center.m_123342_() + dy, center.m_123343_() + dz);
                    BlockState state = client.f_91073_.m_8055_((BlockPos)mpos);
                    if (state.m_60795_()) continue;
                    if (CaveDustEffect.isNaturalBlock(state)) {
                        ++naturalCount;
                        continue;
                    }
                    if (!CaveDustEffect.isArtificialBlock(state)) continue;
                    ++artificialCount;
                }
            }
        }
        int total = naturalCount + artificialCount;
        if (total == 0) {
            inCaveCached = false;
            return;
        }
        float naturalRatio = (float)naturalCount / (float)total;
        inCaveCached = naturalRatio >= 0.85f;
    }

    private static boolean isNaturalBlock(BlockState state) {
        if (state.m_204336_(BlockTags.f_13061_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144274_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144262_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144258_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144264_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13043_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144260_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144261_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144259_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144263_)) {
            return true;
        }
        Block b = state.m_60734_();
        return b == Blocks.f_49994_ || b == Blocks.f_50129_ || b == Blocks.f_49992_ || b == Blocks.f_49993_ || b == Blocks.f_152588_ || b == Blocks.f_152537_ || b == Blocks.f_152497_ || b == Blocks.f_152496_ || b == Blocks.f_152490_ || b == Blocks.f_152491_ || b == Blocks.f_152544_ || b == Blocks.f_152543_ || b == Blocks.f_152475_ || b == Blocks.f_220855_ || b == Blocks.f_220856_ || b == Blocks.f_220857_ || b == Blocks.f_152500_ || b == Blocks.f_220858_ || b == Blocks.f_49990_ || b == Blocks.f_49991_;
    }

    private static boolean isArtificialBlock(BlockState state) {
        if (state.m_204336_(BlockTags.f_13090_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13089_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_215838_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13038_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13103_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13036_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13039_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13032_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13030_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13031_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13034_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13068_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13028_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_198156_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144265_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13087_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13033_)) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_13083_)) {
            return true;
        }
        Block b = state.m_60734_();
        return b == Blocks.f_50652_ || b == Blocks.f_152551_ || b == Blocks.f_50079_ || b == Blocks.f_50222_ || b == Blocks.f_50223_ || b == Blocks.f_50224_ || b == Blocks.f_50225_ || b == Blocks.f_50470_ || b == Blocks.f_50387_ || b == Blocks.f_50281_ || b == Blocks.f_50175_ || b == Blocks.f_152555_ || b == Blocks.f_152589_ || b == Blocks.f_152559_ || b == Blocks.f_152593_ || b == Blocks.f_50076_ || b == Blocks.f_50058_ || b == Blocks.f_50185_ || b == Blocks.f_152498_ || b == Blocks.f_50183_ || b == Blocks.f_50184_ || b == Blocks.f_50081_ || b == Blocks.f_50082_ || b == Blocks.f_50139_ || b == Blocks.f_50140_ || b == Blocks.f_50681_ || b == Blocks.f_50682_ || b == Blocks.f_50091_ || b == Blocks.f_50094_ || b == Blocks.f_50620_ || b == Blocks.f_50619_ || b == Blocks.f_50087_ || b == Blocks.f_50325_ || b == Blocks.f_50618_ || b == Blocks.f_50078_ || b == Blocks.f_244299_ || b == Blocks.f_50624_ || b == Blocks.f_50201_ || b == Blocks.f_50255_ || b == Blocks.f_50332_ || b == Blocks.f_50286_ || b == Blocks.f_50061_ || b == Blocks.f_50155_ || b == Blocks.f_50616_;
    }

    private static void spawnDustParticles(Minecraft client) {
        int frequency = EffectualConfig.get().caveDustFrequency;
        if (frequency <= 0 || RAND.m_188503_(10) > frequency) {
            return;
        }
        BlockPos center = client.f_91074_.m_20183_();
        for (int i = 0; i < 2; ++i) {
            double x = (double)center.m_123341_() + (RAND.m_188500_() - 0.5) * 32.0;
            double z = (double)center.m_123343_() + (RAND.m_188500_() - 0.5) * 32.0;
            double y = (double)center.m_123342_() + RAND.m_188500_() * 6.0 + 1.0;
            BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
            if (!client.f_91073_.m_8055_(pos).m_60795_() || !client.f_91073_.m_8055_(pos.m_7495_()).m_60795_()) continue;
            TClientParticles.spawn((ParticleOptions)ParticleTypes.f_123790_, (double)x, (double)y, (double)z, (double)0.0, (double)-0.01, (double)0.0);
        }
    }
}

