/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.MouthSteam;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.effectual.ModParticles;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;

public class MouthSteamEffect {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final Map<Integer, Integer> tickCounters = new HashMap<Integer, Integer>();
    private static final Map<Integer, MovementState> lastStates = new HashMap<Integer, MovementState>();

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (!EffectualConfig.get().mouthSteam || client.f_91073_ == null || client.m_91104_()) {
                return;
            }
            for (Player player : client.f_91073_.m_6907_()) {
                int frequency;
                int id = player.m_19879_();
                if (!MouthSteamEffect.shouldPlayEffect(player)) {
                    tickCounters.remove(id);
                    lastStates.remove(id);
                    continue;
                }
                MovementState current = MouthSteamEffect.getMovementState(player);
                MovementState previous = lastStates.getOrDefault(id, MovementState.STANDING);
                int tickCounter = tickCounters.getOrDefault(id, 0);
                if (current != previous) {
                    tickCounter = 0;
                }
                if (++tickCounter >= (frequency = MouthSteamEffect.getRandomFrequency(current))) {
                    MouthSteamEffect.spawnBreath(player);
                    tickCounter = 0;
                }
                tickCounters.put(id, tickCounter);
                lastStates.put(id, current);
            }
        });
    }

    private static boolean shouldPlayEffect(Player player) {
        return MouthSteamEffect.isColdEnough(player) && !player.m_5842_() && !player.m_5833_() && !player.m_7500_();
    }

    private static boolean isColdEnough(Player player) {
        BlockPos pos = player.m_20183_();
        return ((Biome)player.m_9236_().m_204166_(pos).m_203334_()).m_47554_() < 0.15f;
    }

    private static void spawnBreath(Player player) {
        int count = 3 + RANDOM.m_188503_(3);
        for (int i = 0; i < count; ++i) {
            TClientParticles.spawn((ParticleOptions)((ParticleOptions)ModParticles.MOUTH_STEAM.get()), (double)player.m_20185_(), (double)player.m_20188_(), (double)player.m_20189_(), (double)0.0, (double)0.0, (double)0.0);
        }
    }

    private static int getRandomFrequency(MovementState state) {
        if (!EffectualConfig.get().dynamicBreathSpeed) {
            return 90 + RANDOM.m_188503_(21);
        }
        return state == MovementState.SPRINTING || state == MovementState.JUMPING ? 30 + RANDOM.m_188503_(21) : 90 + RANDOM.m_188503_(21);
    }

    private static MovementState getMovementState(Player p) {
        if (p.m_20142_()) {
            return MovementState.SPRINTING;
        }
        if (!p.m_20096_() && p.m_20184_().f_82480_ > 0.0) {
            return MovementState.JUMPING;
        }
        if (p.m_20184_().m_165925_() > 0.1) {
            return MovementState.WALKING;
        }
        return MovementState.STANDING;
    }

    private static enum MovementState {
        STANDING,
        WALKING,
        SPRINTING,
        JUMPING;

    }
}

