/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.PlayerRunEffect;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.effectual.ModParticles;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class PlayerRunEffect {
    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (!EffectualConfig.get().runDust || client.f_91073_ == null || client.m_91104_()) {
                return;
            }
            for (Player player : client.f_91073_.m_6907_()) {
                if (!PlayerRunEffect.shouldPlayEffect(player)) continue;
                PlayerRunEffect.spawnDust(client, player);
            }
        });
    }

    private static boolean shouldPlayEffect(Player player) {
        return player.m_20142_() && !player.m_6144_() && player.m_20096_() && !player.m_5842_() && !player.m_20069_() && !player.m_5833_();
    }

    private static void spawnDust(Minecraft client, Player player) {
        ClientLevel level = client.f_91073_;
        BlockPos pos = player.m_20183_();
        BlockState atFeet = level.m_8055_(pos);
        BlockState below = level.m_8055_(pos.m_7495_());
        Vec3 velocity = player.m_20184_();
        double speedFactor = 0.5;
        double vx = -velocity.f_82479_ * speedFactor;
        double vz = -velocity.f_82481_ * speedFactor;
        if (atFeet.m_60713_(Blocks.f_50125_) && atFeet.m_61138_((Property)BlockStateProperties.f_61417_)) {
            PlayerRunEffect.spawnParticle(client, (SimpleParticleType)ModParticles.SNOW_DUST.get(), player, vx, vz, 0.1);
            return;
        }
        if (atFeet.m_60713_(Blocks.f_220864_) || atFeet.m_60713_(Blocks.f_220834_)) {
            PlayerRunEffect.spawnParticle(client, (SimpleParticleType)ModParticles.MUD_DUST.get(), player, vx, vz, 0.5);
            return;
        }
        Block block = below.m_60734_();
        if (block == Blocks.f_49992_ || block == Blocks.f_271439_) {
            PlayerRunEffect.spawnParticle(client, (SimpleParticleType)ModParticles.SAND_DUST.get(), player, vx, vz, 0.1);
        } else if (block == Blocks.f_49993_) {
            PlayerRunEffect.spawnParticle(client, (SimpleParticleType)ModParticles.RED_SAND_DUST.get(), player, vx, vz, 0.1);
        } else if (block == Blocks.f_50125_ || block == Blocks.f_50127_ || block == Blocks.f_152499_) {
            PlayerRunEffect.spawnParticle(client, (SimpleParticleType)ModParticles.SNOW_DUST.get(), player, vx, vz, 0.1);
        } else if (block == Blocks.f_49994_ || block == Blocks.f_276445_) {
            PlayerRunEffect.spawnParticle(client, (SimpleParticleType)ModParticles.GRAVEL_DUST.get(), player, vx, vz, 0.1);
        } else if (block == Blocks.f_220864_ || block == Blocks.f_220843_ || block == Blocks.f_220834_) {
            PlayerRunEffect.spawnParticle(client, (SimpleParticleType)ModParticles.MUD_DUST.get(), player, vx, vz, 0.1);
        }
    }

    private static void spawnParticle(Minecraft client, SimpleParticleType type, Player player, double vx, double vz, double yOffset) {
        RandomSource rand = client.f_91073_.f_46441_;
        double x = player.m_20185_() + (rand.m_188500_() - 0.5) * 0.6;
        double y = player.m_20186_() + yOffset;
        double z = player.m_20189_() + (rand.m_188500_() - 0.5) * 0.6;
        double noisyVx = vx + (rand.m_188500_() - 0.5) * 0.15;
        double noisyVz = vz + (rand.m_188500_() - 0.5) * 0.15;
        TClientParticles.spawn((ParticleOptions)type, (double)x, (double)y, (double)z, (double)noisyVx, (double)0.0, (double)noisyVz);
    }
}

