/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.SoulGlow;

import com.imeetake.tlib.client.particle.TOrientedParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class SoulGlowParticle
extends TOrientedParticle<SimpleParticleType> {
    private final Vec3 home;
    private Vec3 initialVelocity;
    private Vec3 forward;
    private final double seedA;
    private final double seedB;
    protected double prevPosX;
    protected double prevPosY;
    protected double prevPosZ;

    public SoulGlowParticle(ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteSet) {
        super(level, x, y, z, velocityX, velocityY, velocityZ, spriteSet);
        this.scale = 0.028f + this.f_107223_.m_188501_() * 0.01f;
        this.f_107225_ = 52 + this.f_107223_.m_188503_(18);
        this.f_107230_ = 0.0f;
        float base = 0.9f + this.f_107223_.m_188501_() * 0.1f;
        float r = base * (0.05f + this.f_107223_.m_188501_() * 0.05f);
        float g = base * (0.7f + this.f_107223_.m_188501_() * 0.15f);
        float b = base * (0.95f + this.f_107223_.m_188501_() * 0.05f);
        this.m_107253_(r, g, b);
        this.f_107219_ = false;
        this.f_107226_ = 0.0f;
        this.home = new Vec3(x, y, z);
        this.initialVelocity = new Vec3(velocityX, velocityY, velocityZ);
        this.forward = this.initialVelocity.m_82556_() > 1.0E-6 ? this.initialVelocity.m_82541_() : new Vec3(0.0, 1.0, 0.0);
        this.seedA = this.f_107223_.m_188500_() * 1000.0;
        this.seedB = this.f_107223_.m_188500_() * 1000.0;
        this.prevPosX = this.f_107212_;
        this.prevPosY = this.f_107213_;
        this.prevPosZ = this.f_107214_;
    }

    public void m_5989_() {
        this.prevPosX = this.f_107212_;
        this.prevPosY = this.f_107213_;
        this.prevPosZ = this.f_107214_;
        double t = ((double)this.f_107224_ + this.seedA) * 0.1;
        double lateralAmp = 2.0E-4 + 1.0E-4 * Math.sin(((double)this.f_107224_ + this.seedB) * 0.15);
        double ax = lateralAmp * Math.sin(t);
        double az = lateralAmp * Math.cos(t);
        double ay = 6.5E-4 + 2.5E-4 * Math.sin(((double)this.f_107224_ + this.seedB) * 0.22);
        Vec3 toHome = this.home.m_82492_(this.f_107212_, this.f_107213_, this.f_107214_);
        Vec3 toHomeXZ = new Vec3(toHome.f_82479_, 0.0, toHome.f_82481_);
        double horizDist = Math.sqrt(toHomeXZ.f_82479_ * toHomeXZ.f_82479_ + toHomeXZ.f_82481_ * toHomeXZ.f_82481_);
        double leashK = 0.003;
        if (horizDist > 0.35) {
            leashK = 0.009;
        }
        this.f_107215_ += (ax += toHomeXZ.f_82479_ * leashK);
        this.f_107217_ += (az += toHomeXZ.f_82481_ * leashK);
        this.f_107216_ += ay;
        double maxSpeed = 0.01;
        double vx = this.f_107215_;
        double vy = this.f_107216_;
        double vz = this.f_107217_;
        double speed = Math.sqrt(vx * vx + vy * vy + vz * vz);
        if (speed > maxSpeed) {
            double k = maxSpeed / speed;
            this.f_107215_ *= k;
            this.f_107216_ *= k;
            this.f_107217_ *= k;
        }
        this.f_107215_ *= 0.986;
        this.f_107216_ *= 0.986;
        this.f_107217_ *= 0.986;
        Vec3 v = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_);
        if (v.m_82556_() > 1.0E-7) {
            this.forward = v.m_82541_();
        }
        float progress = (float)this.f_107224_ / (float)this.f_107225_;
        float aIn = this.smoothstep(0.0f, 0.15f, progress);
        float aOut = 1.0f - this.smoothstep(0.82f, 1.0f, progress);
        this.f_107230_ = 0.8f * aIn * aOut;
        super.m_5989_();
    }

    public void buildGeometry(VertexConsumer vc, Camera camera, float tickDelta) {
        float px = (float)Mth.m_14139_((double)tickDelta, (double)this.prevPosX, (double)this.f_107212_);
        float py = (float)Mth.m_14139_((double)tickDelta, (double)this.prevPosY, (double)this.f_107213_);
        float pz = (float)Mth.m_14139_((double)tickDelta, (double)this.prevPosZ, (double)this.f_107214_);
        Vec3 cam = camera.m_90583_();
        Vec3 center = new Vec3((double)px - cam.f_82479_, (double)py - cam.f_82480_, (double)pz - cam.f_82481_);
        Vec3 f = this.forward.m_82556_() > 1.0E-7 ? this.forward : new Vec3(0.0, 1.0, 0.0);
        Vec3 upRef = Math.abs(f.f_82480_) > 0.99 ? new Vec3(0.0, 0.0, 1.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 right = f.m_82537_(upRef).m_82541_();
        Vec3 up = right.m_82537_(f).m_82541_();
        float speed = (float)new Vec3(this.f_107215_, this.f_107216_, this.f_107217_).m_82553_();
        float len = this.scale * (0.65f + speed * 5.5f);
        float halfW = this.scale * (0.22f + speed * 1.5f);
        Vec3 tail = f.m_82490_((double)(-len) * 0.5);
        Vec3 nose = f.m_82490_((double)len * 0.5);
        Vec3 offRight = right.m_82490_((double)halfW);
        Vec3 offLeft = right.m_82490_((double)(-halfW));
        Vec3 q1 = center.m_82549_(nose).m_82549_(offRight);
        Vec3 q2 = center.m_82549_(nose).m_82549_(offLeft);
        Vec3 q3 = center.m_82549_(tail).m_82549_(offLeft);
        Vec3 q4 = center.m_82549_(tail).m_82549_(offRight);
        TextureAtlasSprite sprite = this.spriteSet.m_5819_(this.f_107224_, this.f_107225_);
        float u1 = sprite.m_118409_();
        float u2 = sprite.m_118410_();
        float v1 = sprite.m_118411_();
        float v2 = sprite.m_118412_();
        int light = this.m_6355_(tickDelta);
        this.vertex(vc, q1, u2, v1, light);
        this.vertex(vc, q2, u1, v1, light);
        this.vertex(vc, q3, u1, v2, light);
        this.vertex(vc, q4, u2, v2, light);
    }

    private void vertex(VertexConsumer vc, Vec3 pos, float u, float v, int light) {
        vc.m_5483_(pos.f_82479_, pos.f_82480_, pos.f_82481_).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    private float smoothstep(float edge0, float edge1, float x) {
        float t = Mth.m_14036_((float)((x - edge0) / (edge1 - edge0)), (float)0.0f, (float)1.0f);
        return t * t * (3.0f - 2.0f * t);
    }
}

