/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.Sparks;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.effectual.ModParticles;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FireImprovements {
    private static final RandomSource RAND = RandomSource.m_216327_();
    private static int tickCounter = 0;

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (client.f_91073_ == null || client.f_91074_ == null || client.m_91104_()) {
                return;
            }
            if (!EffectualConfig.get().fireImprovements) {
                return;
            }
            if (++tickCounter < 3) {
                return;
            }
            tickCounter = 0;
            FireImprovements.spawn(client);
        });
    }

    private static void spawn(Minecraft client) {
        BlockPos center = client.f_91074_.m_20183_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dx = -8; dx <= 8; ++dx) {
            for (int dy = -8; dy <= 8; ++dy) {
                for (int dz = -8; dz <= 8; ++dz) {
                    pos.m_122178_(center.m_123341_() + dx, center.m_123342_() + dy, center.m_123343_() + dz);
                    BlockState state = client.f_91073_.m_8055_((BlockPos)pos);
                    if (!state.m_60713_(Blocks.f_50083_) || RAND.m_188501_() >= 0.65f) continue;
                    FireImprovements.spark(client, (BlockPos)pos);
                }
            }
        }
    }

    private static void spark(Minecraft client, BlockPos pos) {
        double z;
        double y;
        double x;
        Direction attachedFace = FireImprovements.getFireAttachmentFace(client, pos);
        if (attachedFace == Direction.DOWN) {
            x = (double)pos.m_123341_() + RAND.m_188500_();
            y = (double)pos.m_123342_() + 0.4 + RAND.m_188500_() * 0.5;
            z = (double)pos.m_123343_() + RAND.m_188500_();
        } else {
            x = (double)pos.m_123341_() + 0.5;
            y = (double)pos.m_123342_() + 0.3 + RAND.m_188500_() * 0.5;
            z = (double)pos.m_123343_() + 0.5;
            double offset = 0.3 + RAND.m_188500_() * 0.15;
            x += (double)attachedFace.m_122429_() * offset;
            z += (double)attachedFace.m_122431_() * offset;
            double perpX = attachedFace.m_122431_();
            double perpZ = -attachedFace.m_122429_();
            double lateral = (RAND.m_188500_() - 0.5) * 0.6;
            x += perpX * lateral;
            z += perpZ * lateral;
        }
        double angle = RAND.m_188500_() * Math.PI * 2.0;
        double speed = 0.01 + RAND.m_188500_() * 0.03;
        double dx = Math.cos(angle) * speed;
        double dy = 0.04 + RAND.m_188500_() * 0.06;
        double dz = Math.sin(angle) * speed;
        TClientParticles.spawn((ParticleOptions)((ParticleOptions)ModParticles.SPARK.get()), (double)x, (double)y, (double)z, (double)dx, (double)dy, (double)dz);
    }

    private static Direction getFireAttachmentFace(Minecraft client, BlockPos firePos) {
        BlockPos below = firePos.m_7495_();
        if (client.f_91073_.m_8055_(below).m_60804_((BlockGetter)client.f_91073_, below)) {
            return Direction.DOWN;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos adjacent = firePos.m_121945_(dir);
            if (!client.f_91073_.m_8055_(adjacent).m_60804_((BlockGetter)client.f_91073_, adjacent)) continue;
            return dir;
        }
        return Direction.DOWN;
    }
}

