/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.Sparks;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.effectual.ModParticles;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class FurnaceSparksEffect {
    private static final RandomSource RAND = RandomSource.m_216327_();
    private static int tickCounter = 0;

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (!EffectualConfig.get().furnaceSparks || client.f_91073_ == null || client.f_91074_ == null || client.m_91104_()) {
                return;
            }
            if (++tickCounter < 4) {
                return;
            }
            tickCounter = 0;
            FurnaceSparksEffect.spawnNearPlayer(client);
        });
    }

    private static void spawnNearPlayer(Minecraft client) {
        BlockPos center = client.f_91074_.m_20183_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int radius = 6;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    pos.m_122178_(center.m_123341_() + dx, center.m_123342_() + dy, center.m_123343_() + dz);
                    BlockState state = client.f_91073_.m_8055_((BlockPos)pos);
                    boolean isFurnace = state.m_60713_(Blocks.f_50094_);
                    boolean isBlast = state.m_60713_(Blocks.f_50620_);
                    if (!isFurnace && !isBlast || !state.m_61145_((Property)BlockStateProperties.f_61443_).orElse(false).booleanValue() || RAND.m_188501_() > 0.45f || !state.m_61138_((Property)BlockStateProperties.f_61374_)) continue;
                    Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                    FurnaceSparksEffect.spawnFrontSparks((BlockPos)pos, facing);
                }
            }
        }
    }

    private static void spawnFrontSparks(BlockPos pos, Direction facing) {
        double nz;
        double cx = (double)pos.m_123341_() + 0.5;
        double cz = (double)pos.m_123343_() + 0.5;
        double nx = facing.m_122429_();
        double tx = nz = (double)facing.m_122431_();
        double tz = -nx;
        double cy = (double)pos.m_123342_() + 0.25 + RAND.m_188500_() * 0.2;
        double px = cx + nx * 0.52;
        double pz = cz + nz * 0.52;
        double lateral = (RAND.m_188500_() - 0.5) * 0.25;
        px += tx * lateral;
        pz += tz * lateral;
        double outSpeed = 0.008 + RAND.m_188500_() * 0.012;
        double upSpeed = 0.015 + RAND.m_188500_() * 0.02;
        double sideSpeed = (RAND.m_188500_() - 0.5) * 0.008;
        double vx = nx * outSpeed + tx * sideSpeed;
        double vz = nz * outSpeed + tz * sideSpeed;
        TClientParticles.spawn((ParticleOptions)((ParticleOptions)ModParticles.SPARK.get()), (double)px, (double)cy, (double)pz, (double)vx, (double)upSpeed, (double)vz);
    }
}

