/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.SparksSoul;

import com.imeetake.tlib.client.particle.TOrientedParticle;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class SoulSparkParticle
extends TOrientedParticle<SimpleParticleType> {
    private final double roll;
    private final float rotSpeed;
    private final double driftAngle;
    private final double driftSpeed;
    private final double riseAccel;
    private final double turbulenceScale;
    protected double prevPosX;
    protected double prevPosY;
    protected double prevPosZ;

    public SoulSparkParticle(ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet spriteSet) {
        super(level, x, y, z, velocityX, velocityY, velocityZ, spriteSet);
        this.scale = (0.02f + this.f_107223_.m_188501_() * 0.01f) / 1.2f;
        this.f_107225_ = 40 + this.f_107223_.m_188503_(20);
        this.f_107230_ = 1.0f;
        float base = 0.9f + this.f_107223_.m_188501_() * 0.1f;
        this.f_107227_ = base * (0.05f + this.f_107223_.m_188501_() * 0.05f);
        this.f_107228_ = base * (0.75f + this.f_107223_.m_188501_() * 0.15f);
        this.f_107229_ = base * (0.95f + this.f_107223_.m_188501_() * 0.05f);
        this.f_107219_ = false;
        this.f_107226_ = 0.0f;
        this.f_107215_ = velocityX * 0.2;
        this.f_107216_ = velocityY * 0.2;
        this.f_107217_ = velocityZ * 0.2;
        this.roll = this.f_107223_.m_188500_() * Math.PI * 2.0;
        this.rotSpeed = (this.f_107223_.m_188501_() - 0.5f) * 0.1f;
        this.driftAngle = this.f_107223_.m_188500_() * Math.PI * 2.0;
        this.driftSpeed = 2.0E-4 + this.f_107223_.m_188500_() * 3.0E-4;
        this.riseAccel = 0.0015 + this.f_107223_.m_188500_() * 0.001;
        this.turbulenceScale = 0.3 + this.f_107223_.m_188500_() * 0.4;
        this.prevPosX = this.f_107212_;
        this.prevPosY = this.f_107213_;
        this.prevPosZ = this.f_107214_;
    }

    public void m_5989_() {
        this.prevPosX = this.f_107212_;
        this.prevPosY = this.f_107213_;
        this.prevPosZ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        float life = (float)this.f_107224_ / (float)this.f_107225_;
        double time = (double)this.f_107224_ * 0.15;
        double turbX = Math.sin(time + this.driftAngle) * Math.cos(time * 0.7) * this.turbulenceScale;
        double turbZ = Math.cos(time * 0.9 + this.driftAngle) * Math.sin(time * 0.6) * this.turbulenceScale;
        this.f_107215_ += Math.cos(this.driftAngle) * this.driftSpeed + turbX * 1.0E-4;
        this.f_107217_ += Math.sin(this.driftAngle) * this.driftSpeed + turbZ * 1.0E-4;
        double riseBoost = this.riseAccel * (1.0 - (double)life * 0.5);
        this.f_107216_ += riseBoost;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        double drag = 0.92 - (double)life * 0.03;
        this.f_107215_ *= drag;
        this.f_107216_ *= drag;
        this.f_107217_ *= drag;
        float fadeStart = 0.7f;
        if (life > fadeStart) {
            float fadeProgress = (life - fadeStart) / (1.0f - fadeStart);
            this.f_107230_ = 1.0f - this.smoothstep(0.0f, 1.0f, fadeProgress);
        } else {
            this.f_107230_ = this.smoothstep(0.0f, 0.1f, life);
        }
    }

    public void buildGeometry(VertexConsumer vc, Camera camera, float tickDelta) {
        float x = (float)Mth.m_14139_((double)tickDelta, (double)this.prevPosX, (double)this.f_107212_);
        float y = (float)Mth.m_14139_((double)tickDelta, (double)this.prevPosY, (double)this.f_107213_);
        float z = (float)Mth.m_14139_((double)tickDelta, (double)this.prevPosZ, (double)this.f_107214_);
        Vec3 cam = camera.m_90583_();
        Vec3 center = new Vec3((double)x - cam.f_82479_, (double)y - cam.f_82480_, (double)z - cam.f_82481_);
        Vec3 v = new Vec3(this.f_107215_, this.f_107216_, this.f_107217_);
        if (v.m_82556_() < 1.0E-6) {
            v = new Vec3(0.0, 1.0, 0.0);
        }
        Vec3 up = v.m_82541_();
        double currentRoll = this.roll + (double)(((float)this.f_107224_ + tickDelta) * this.rotSpeed);
        Vec3 tmp = Math.abs(up.f_82480_) > 0.9 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
        Vec3 right = up.m_82537_(tmp).m_82541_();
        right = this.rotateAroundAxis(right, up, currentRoll);
        float halfW = this.scale * 0.8f;
        float halfH = this.scale * 1.2f;
        Vec3 u = up.m_82490_((double)halfH);
        Vec3 r = right.m_82490_((double)halfW);
        Vec3 p1 = center.m_82549_(r).m_82549_(u);
        Vec3 p2 = center.m_82549_(r).m_82546_(u);
        Vec3 p3 = center.m_82546_(r).m_82546_(u);
        Vec3 p4 = center.m_82546_(r).m_82549_(u);
        TextureAtlasSprite sprite = this.spriteSet.m_5819_(this.f_107224_, this.f_107225_);
        float u1 = sprite.m_118409_();
        float u2 = sprite.m_118410_();
        float v1 = sprite.m_118411_();
        float v2 = sprite.m_118412_();
        int light = 0xF000F0;
        this.vertex(vc, p1, u2, v1, light);
        this.vertex(vc, p2, u2, v2, light);
        this.vertex(vc, p3, u1, v2, light);
        this.vertex(vc, p4, u1, v1, light);
        this.vertex(vc, p4, u1, v1, light);
        this.vertex(vc, p3, u1, v2, light);
        this.vertex(vc, p2, u2, v2, light);
        this.vertex(vc, p1, u2, v1, light);
    }

    private void vertex(VertexConsumer vc, Vec3 pos, float u, float v, int light) {
        vc.m_5483_(pos.f_82479_, pos.f_82480_, pos.f_82481_).m_7421_(u, v).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(light).m_5752_();
    }

    private Vec3 rotateAroundAxis(Vec3 vec, Vec3 axis, double angle) {
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        Vec3 a = axis.m_82541_();
        return vec.m_82490_(c).m_82549_(a.m_82537_(vec).m_82490_(s)).m_82549_(a.m_82490_(a.m_82526_(vec) * (1.0 - c)));
    }

    private float smoothstep(float edge0, float edge1, float x) {
        float t = Mth.m_14036_((float)((x - edge0) / (edge1 - edge0)), (float)0.0f, (float)1.0f);
        return t * t * (3.0f - 2.0f * t);
    }
}

