/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.SteamEffect;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SteamEffect {
    private static final Set<BlockPos> activeSteamPositions = new HashSet<BlockPos>();
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final int POSITIONS_PER_TICK = 462;
    private static final int RADIUS = 20;
    private static final int HEIGHT = 5;
    private static int scanX = -20;
    private static int scanY = -5;
    private static int scanZ = -20;

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (!EffectualConfig.get().steamEffect) {
                return;
            }
            if (client.f_91073_ == null || client.f_91074_ == null) {
                return;
            }
            if (client.m_91104_()) {
                return;
            }
            SteamEffect.updateSteamPositions(client);
            for (BlockPos pos : activeSteamPositions) {
                SteamEffect.spawnSteam(pos);
            }
        });
    }

    private static void updateSteamPositions(Minecraft client) {
        BlockPos center = client.f_91074_.m_20183_();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int checkedCount = 0; checkedCount < 462; ++checkedCount) {
            pos.m_122178_(center.m_123341_() + scanX, center.m_123342_() + scanY, center.m_123343_() + scanZ);
            boolean isSteam = SteamEffect.isWaterNextToLava(client, (BlockPos)pos);
            if (isSteam) {
                activeSteamPositions.add(pos.m_7949_());
            } else {
                activeSteamPositions.remove(pos);
            }
            if (++scanX <= 20) continue;
            scanX = -20;
            if (++scanZ <= 20) continue;
            scanZ = -20;
            if (++scanY <= 5) continue;
            scanY = -5;
        }
    }

    private static boolean isWaterNextToLava(Minecraft client, BlockPos pos) {
        BlockState state = client.f_91073_.m_8055_(pos);
        if (!state.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos neighborPos;
                    BlockState neighbor;
                    if (dx == 0 && dy == 0 && dz == 0 || !(neighbor = client.f_91073_.m_8055_(neighborPos = pos.m_7918_(dx, dy, dz))).m_60819_().m_205070_(FluidTags.f_13132_) && !neighbor.m_60713_(Blocks.f_152477_)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static void spawnSteam(BlockPos pos) {
        int count = RANDOM.m_188503_(2) + 1;
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.m_123341_() + 0.5 + (RANDOM.m_188500_() - 0.5) * 0.3;
            double y = (double)pos.m_123342_() + 1.0 + RANDOM.m_188500_() * 0.2;
            double z = (double)pos.m_123343_() + 0.5 + (RANDOM.m_188500_() - 0.5) * 0.3;
            TClientParticles.spawn((ParticleOptions)ParticleTypes.f_123759_, (double)x, (double)y, (double)z, (double)0.0, (double)(0.1 + RANDOM.m_188500_() * 0.05), (double)0.0);
        }
    }
}

