/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.StripEffect;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.event.events.common.InteractionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class StripEffect {
    private static final RandomSource RAND = RandomSource.m_216327_();
    private static final Map<BlockPos, Pending> PENDING = new HashMap<BlockPos, Pending>();

    public static void register() {
        InteractionEvent.RIGHT_CLICK_BLOCK.register((player, hand, pos, face) -> {
            if (!EffectualConfig.get().stripEffect) {
                return EventResult.pass();
            }
            if (!player.m_9236_().f_46443_) {
                return EventResult.pass();
            }
            ItemStack stack = player.m_21120_(hand);
            if (!(stack.m_41720_() instanceof AxeItem)) {
                return EventResult.pass();
            }
            BlockState state = player.m_9236_().m_8055_(pos);
            if (!StripEffect.isLog(state)) {
                return EventResult.pass();
            }
            long now = player.m_9236_().m_46467_();
            PENDING.put(pos.m_7949_(), new Pending(state, face, now + 6L));
            return EventResult.pass();
        });
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (!EffectualConfig.get().stripEffect || client.f_91073_ == null || client.m_91104_()) {
                return;
            }
            StripEffect.tick(client);
        });
    }

    private static void tick(Minecraft client) {
        ClientLevel level = client.f_91073_;
        long now = level.m_46467_();
        Iterator<Map.Entry<BlockPos, Pending>> it = PENDING.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, Pending> e = it.next();
            BlockPos pos = e.getKey();
            Pending p = e.getValue();
            if (now >= p.expiresAt()) {
                it.remove();
                continue;
            }
            BlockState cur = level.m_8055_(pos);
            if (cur.m_60734_() == p.oldState().m_60734_()) continue;
            if (StripEffect.isLog(p.oldState()) && StripEffect.isLog(cur)) {
                StripEffect.spawnParticles(pos, p.oldState(), p.face());
            }
            it.remove();
        }
    }

    private static boolean isLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_);
    }

    private static void spawnParticles(BlockPos pos, BlockState state, Direction face) {
        double nx = face.m_122429_();
        double ny = face.m_122430_();
        double nz = face.m_122431_();
        double cx = (double)pos.m_123341_() + 0.5 + nx * 0.51;
        double cy = (double)pos.m_123342_() + 0.5 + ny * 0.51;
        double cz = (double)pos.m_123343_() + 0.5 + nz * 0.51;
        int chips = 7 + RAND.m_188503_(4);
        for (int i = 0; i < chips; ++i) {
            double t = (RAND.m_188500_() - 0.5) * 0.16;
            double sx = nx == 0.0 ? t : 0.0;
            double sy = ny == 0.0 ? t : 0.0;
            double sz = nz == 0.0 ? t : 0.0;
            double vx = nx * (0.04 + RAND.m_188500_() * 0.03);
            double vy = ny * (0.04 + RAND.m_188500_() * 0.03);
            double vz = nz * (0.04 + RAND.m_188500_() * 0.03);
            TClientParticles.spawn((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (double)(cx + sx), (double)(cy + sy), (double)(cz + sz), (double)vx, (double)vy, (double)vz);
        }
    }

    private record Pending(BlockState oldState, Direction face, long expiresAt) {
    }
}

