/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.effects.WaterDrip;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.effectual.ModParticles;
import com.imeetake.tlib.client.particle.TClientParticles;
import dev.architectury.event.events.client.ClientTickEvent;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;

public class WaterDripEffect {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final Map<Player, Long> lastFullySubmergedTicks = new WeakHashMap<Player, Long>();

    public static void register() {
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (!EffectualConfig.get().waterDrip || client.f_91073_ == null || client.m_91104_()) {
                return;
            }
            ClientLevel level = client.f_91073_;
            for (Player player : level.m_6907_()) {
                if (!WaterDripEffect.shouldPlayEffect(player)) continue;
                WaterDripEffect.spawnWaterDripParticles(player);
            }
        });
    }

    private static boolean shouldPlayEffect(Player player) {
        if (player.m_5833_() || player.m_7500_()) {
            return false;
        }
        long time = player.m_9236_().m_46467_();
        if (player.m_5842_()) {
            lastFullySubmergedTicks.put(player, time);
            return false;
        }
        long last = lastFullySubmergedTicks.getOrDefault(player, -200L);
        if (time - last > 100L) {
            return false;
        }
        if (player.m_20069_()) {
            return true;
        }
        return player.m_20184_().m_82556_() > 4.0E-4 || player.m_20142_();
    }

    private static void spawnWaterDripParticles(Player player) {
        int count = 1 + (RANDOM.m_188501_() < 0.12f ? 1 : 0);
        float yaw = player.m_146908_();
        double ry = Math.toRadians(-yaw);
        for (int i = 0; i < count; ++i) {
            double ring = 0.32 + RANDOM.m_188500_() * 0.08;
            double ang = RANDOM.m_188500_() * Math.PI * 2.0;
            double lx = Math.cos(ang) * ring;
            double lz = Math.sin(ang) * ring;
            double ly = 0.95 + RANDOM.m_188500_() * 0.7;
            double rx = lx * Math.cos(ry) - lz * Math.sin(ry);
            double rz = lx * Math.sin(ry) + lz * Math.cos(ry);
            double x = player.m_20185_() + rx;
            double y = player.m_20186_() + ly;
            double z = player.m_20189_() + rz;
            TClientParticles.spawn((ParticleOptions)((ParticleOptions)ModParticles.WATER_DRIP.get()), (double)x, (double)y, (double)z, (double)0.0, (double)0.0, (double)0.0);
        }
    }
}

