/*
 * Decompiled with CFR 0.152.
 */
package com.imeetake.effectual.mixin;

import com.imeetake.effectual.EffectualConfig;
import com.imeetake.effectual.ModParticles;
import com.imeetake.tlib.client.particle.TClientParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class MetalHitMixin {
    @Inject(method={"startDestroyBlock"}, at={@At(value="HEAD")})
    private void onMetalHit(BlockPos pos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        BlockHitResult blockHitResult;
        TagKey metalBlocksTag;
        TagKey metalItemsTag;
        if (!EffectualConfig.get().metalHitSparks) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91073_ == null || client.f_91074_ == null) {
            return;
        }
        ClientLevel world = client.f_91073_;
        LocalPlayer player = client.f_91074_;
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_204117_(metalItemsTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("effectual", "metal_items")))) {
            return;
        }
        BlockState blockState = world.m_8055_(pos);
        if (!blockState.m_204336_(metalBlocksTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("effectual", "metal_blocks")))) {
            return;
        }
        HitResult hitResult = client.f_91077_;
        Vec3 hitPos = hitResult instanceof BlockHitResult && (blockHitResult = (BlockHitResult)hitResult).m_82425_().equals((Object)pos) ? blockHitResult.m_82450_() : Vec3.m_82512_((Vec3i)pos).m_82520_((double)direction.m_122429_() * 0.5, (double)direction.m_122430_() * 0.5, (double)direction.m_122431_() * 0.5);
        this.spawnSparks(world, hitPos, direction);
    }

    private void spawnSparks(ClientLevel world, Vec3 pos, Direction direction) {
        RandomSource random = world.f_46441_;
        for (int i = 0; i < 6 + random.m_188503_(4); ++i) {
            double offsetX = pos.f_82479_ + (random.m_188500_() - 0.5) * 0.2;
            double offsetY = pos.f_82480_ + (random.m_188500_() - 0.5) * 0.2;
            double offsetZ = pos.f_82481_ + (random.m_188500_() - 0.5) * 0.2;
            double velocityX = (random.m_188500_() - 0.5) * 0.1 + (double)direction.m_122429_() * 0.1;
            double velocityY = (random.m_188500_() - 0.5) * 0.1 + (double)direction.m_122430_() * 0.1;
            double velocityZ = (random.m_188500_() - 0.5) * 0.1 + (double)direction.m_122431_() * 0.1;
            TClientParticles.spawn((ParticleOptions)((ParticleOptions)ModParticles.METAL_SPARK.get()), (double)offsetX, (double)offsetY, (double)offsetZ, (double)velocityX, (double)velocityY, (double)velocityZ);
        }
    }
}

