/*
 * Decompiled with CFR 0.152.
 */
package com.jagrosh.discordipc.entities.pipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.entities.Callback;
import com.jagrosh.discordipc.entities.Packet;
import com.jagrosh.discordipc.entities.pipe.Pipe;
import com.jagrosh.discordipc.entities.pipe.PipeStatus;
import com.jagrosh.discordipc.impl.WinRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsPipe
extends Pipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsPipe.class);
    private static final Float javaSpec = Float.valueOf(Float.parseFloat(System.getProperty("java.specification.version")));
    private final int targetKey = -2147483647;
    private final long targetLongKey = -2147483647L;
    public RandomAccessFile file;

    WindowsPipe(IPCClient ipcClient, HashMap<String, Callback> callbacks, File location) {
        super(ipcClient, callbacks);
        try {
            this.file = new RandomAccessFile(location, "rw");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to access '" + location + "', check file permissions", e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.file.write(b);
    }

    @Override
    public Packet read() throws IOException, JsonParseException {
        while ((this.status == PipeStatus.CONNECTED || this.status == PipeStatus.CLOSING) && this.file.length() == 0L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == PipeStatus.DISCONNECTED) {
            throw new IOException("Disconnected!");
        }
        if (this.status == PipeStatus.CLOSED) {
            return new Packet(Packet.OpCode.CLOSE, null, this.ipcClient.getEncoding());
        }
        Packet.OpCode op = Packet.OpCode.values()[Integer.reverseBytes(this.file.readInt())];
        int len = Integer.reverseBytes(this.file.readInt());
        byte[] d = new byte[len];
        this.file.readFully(d);
        return this.receive(op, d);
    }

    @Override
    public void close() throws IOException {
        if (this.ipcClient.isDebugMode()) {
            this.ipcClient.getCurrentLogger(LOGGER).info("[DEBUG] Closing IPC pipe...");
        }
        this.status = PipeStatus.CLOSING;
        this.send(Packet.OpCode.CLOSE, new JsonObject());
        this.status = PipeStatus.CLOSED;
        this.file.close();
    }

    @Override
    public void registerApp(String applicationId, String command) {
        String javaExePath;
        String javaLibraryPath = System.getProperty("java.home");
        File javaExeFile = new File(javaLibraryPath.split(";")[0] + "/bin/java.exe");
        File javawExeFile = new File(javaLibraryPath.split(";")[0] + "/bin/javaw.exe");
        String string = javaExeFile.exists() ? javaExeFile.getAbsolutePath() : (javaExePath = javawExeFile.exists() ? javawExeFile.getAbsolutePath() : null);
        if (javaExePath == null) {
            throw new RuntimeException("Unable to find java path");
        }
        String openCommand = command != null ? command : javaExePath;
        String protocolName = "discord-" + applicationId;
        String protocolDescription = "URL:Run game " + applicationId + " protocol";
        String keyName = "Software\\Classes\\" + protocolName;
        String iconKeyName = keyName + "\\DefaultIcon";
        String commandKeyName = keyName + "\\shell\\open\\command";
        try {
            if (javaSpec.floatValue() >= 11.0f) {
                WinRegistry.createKey(-2147483647L, keyName);
                WinRegistry.writeStringValue(-2147483647L, keyName, "", protocolDescription);
                WinRegistry.writeStringValue(-2147483647L, keyName, "URL Protocol", "\u0000");
                WinRegistry.createKey(-2147483647L, iconKeyName);
                WinRegistry.writeStringValue(-2147483647L, iconKeyName, "", javaExePath);
                WinRegistry.createKey(-2147483647L, commandKeyName);
                WinRegistry.writeStringValue(-2147483647L, commandKeyName, "", openCommand);
            } else {
                WinRegistry.createKey(-2147483647, keyName);
                WinRegistry.writeStringValue(-2147483647, keyName, "", protocolDescription);
                WinRegistry.writeStringValue(-2147483647, keyName, "URL Protocol", "\u0000");
                WinRegistry.createKey(-2147483647, iconKeyName);
                WinRegistry.writeStringValue(-2147483647, iconKeyName, "", javaExePath);
                WinRegistry.createKey(-2147483647, commandKeyName);
                WinRegistry.writeStringValue(-2147483647, commandKeyName, "", openCommand);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Unable to modify Discord registry keys", ex);
        }
    }

    @Override
    public void registerSteamGame(String applicationId, String steamId) {
        try {
            String steamPath = javaSpec.floatValue() >= 11.0f ? WinRegistry.readString(-2147483647L, "Software\\\\Valve\\\\Steam", "SteamExe") : WinRegistry.readString(-2147483647, "Software\\\\Valve\\\\Steam", "SteamExe");
            if (steamPath == null) {
                throw new RuntimeException("Steam exe path not found");
            }
            steamPath = steamPath.replaceAll("/", "\\");
            String command = "\"" + steamPath + "\" steam://rungameid/" + steamId;
            this.registerApp(applicationId, command);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to register Steam game", ex);
        }
    }
}

