/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1259;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2629;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3288;
import net.minecraft.class_345;
import net.minecraft.class_3518;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.apache.logging.log4j.Level;
import org.meteordev.starscript.value.Value;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.AlinLogger;
import ru.kelcuprum.alinlib.api.KeyMappingHelper;
import ru.kelcuprum.alinlib.api.events.alinlib.LocalizationEvents;
import ru.kelcuprum.alinlib.api.events.client.ClientLifecycleEvents;
import ru.kelcuprum.alinlib.api.events.client.ClientTickEvents;
import ru.kelcuprum.alinlib.api.events.client.GuiRenderEvents;
import ru.kelcuprum.alinlib.config.Config;
import ru.kelcuprum.alinlib.config.Localization;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.components.builder.AbstractBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;
import ru.kelcuprum.alinlib.gui.screens.ConfirmScreen;
import ru.kelcuprum.alinlib.gui.toast.ToastBuilder;
import ru.kelcuprum.alinlib.info.World;
import ru.kelcuprum.alinlib.utils.GsonHelper;
import ru.kelcuprum.alinlib.utils.StealthManager;
import ru.pplh.mod.api.OAuth;
import ru.pplh.mod.api.PepeLandAPI;
import ru.pplh.mod.api.PepeLandHelperAPI;
import ru.pplh.mod.api.components.user.User;
import ru.pplh.mod.command.PPLHelperCommand;
import ru.pplh.mod.gui.screens.ArchivedProjectsScreen;
import ru.pplh.mod.gui.screens.CommandsScreen;
import ru.pplh.mod.gui.screens.EmotesScreen;
import ru.pplh.mod.gui.screens.ModsScreen;
import ru.pplh.mod.gui.screens.NewsListScreen;
import ru.pplh.mod.gui.screens.ProfileScreen;
import ru.pplh.mod.gui.screens.ProjectsScreen;
import ru.pplh.mod.gui.screens.UpdaterScreen;
import ru.pplh.mod.gui.screens.configs.ConfigScreen;
import ru.pplh.mod.gui.style.VanillaLikeStyle;
import ru.pplh.mod.interactive.InteractiveManager;
import ru.pplh.mod.mods.abi.ABIManager;
import ru.pplh.mod.mods.minedows.MinedowsManager;
import ru.pplh.mod.mods.sailstatus.SailStatusManager;
import ru.pplh.mod.test.GUIRender;
import ru.pplh.mod.test.LevelTick;
import ru.pplh.mod.utils.DiscordActivityManager;
import ru.pplh.mod.utils.FollowManager;
import ru.pplh.mod.utils.TabHelper;
import ru.pplh.mod.utils.TradeManager;

public class PepeLandHelper
implements ClientModInitializer {
    public static final AlinLogger LOG = new AlinLogger("PPL Helper");
    public static User user = null;
    public static Config config = new Config("config/pplhelper/config.json");
    public static boolean isInstalledABI = FabricLoader.getInstance().isModLoaded("actionbarinfo");
    public static boolean isInstalledSailStatus = FabricLoader.getInstance().isModLoaded("sailstatus");
    public static boolean worldsLoaded = false;
    public static boolean modsLoaded = false;
    public static String[] worlds = new String[]{"\u041c\u041f1", "\u041c\u041f2", "\u041c\u0420", "\u041c\u0424", "\u0422\u0417", "\u042d\u043d\u0434"};
    public static JsonArray commands = new JsonArray();
    public static JsonArray mods = new JsonArray();
    public static JsonArray resource_packs = new JsonArray();
    public static JsonObject tradeRegistry = new JsonObject();
    public static JsonObject trade = new JsonObject();
    public static boolean categoriesAndTags = false;
    public static String[] pc = new String[]{":("};
    public static String[] pct = new String[]{":("};
    public static String[] nc = new String[]{":("};
    public static String[] nct = new String[]{":("};
    public static String[] sc = new String[]{"PepeLand 9"};
    public static String[] sct = new String[]{"ppl9"};
    public static VanillaLikeStyle vanillaLikeStyle = new VanillaLikeStyle();
    private static long discordRpcLastUpdatedTime = 0L;
    private static TabHelper.Worlds lastWorld = null;
    private static boolean lastLobby = false;
    private static boolean gameStarted = false;
    private static boolean loginAval = false;
    public static String[] emotes = new String[0];
    public static long restartTime = 0L;
    public static long joinTime = 0L;
    public static UUID rtUUID = UUID.randomUUID();
    public static UUID jtUUID = UUID.randomUUID();
    public static class_345 rtBossBar;
    public static class_345 jtBossBar;
    public static UUID spUUID;
    public static class_345 spBossBar;
    private static long lastMaxNear;
    private static HashMap<String, String> lastEmotes;

    public void onInitializeClient() {
        LOG.log("-=-=-=-=-=-=-=-", new Object[]{Level.WARN});
        LOG.log("\u0414\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442 \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0444\u0438\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u044c\u044e \u0441\u0435\u0442\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u043e\u0432 PepeLand", new Object[]{Level.WARN});
        LOG.log("-=-=-=-=-=-=-=-", new Object[]{Level.WARN});
        StealthManager.registerActiveManager(() -> {
            boolean isActive = false;
            if (config.getBoolean("STEALTH", false) && PepeLandHelper.playerInPPL() && TabHelper.getWorld() != null) {
                if (config.getBoolean("STEALTH.CURRENT_WORLD", true)) {
                    if (config.getBoolean(String.format("STEALTH.WORLD.%s", TabHelper.getWorld().shortName.toUpperCase()), true)) {
                        isActive = true;
                    }
                } else {
                    isActive = true;
                }
            }
            return isActive;
        });
        World.register((String)"minecraft:world_art", (String)"\u041c\u0438\u0440 \u0430\u0440\u0442\u043e\u0432");
        World.register((String)"minecraft:world_art_old", (String)"\u041c\u0438\u0440 \u0441\u0442\u0430\u0440\u044b\u0445 \u0430\u0440\u0442\u043e\u0432");
        if (isInstalledABI && !PepeLandHelper.isABILegacy()) {
            ABIManager.register();
        }
        if (config.getString("API_URL", "https://api.pplh.ru/").toLowerCase().contains("pplmods.ru")) {
            config.setString("API_URL", "https://api.pplh.ru/");
        }
        if (config.getString("oauth.url", "https://auth.pplh.ru/").toLowerCase().contains("pplmods.ru")) {
            config.setString("oauth.url", "https://auth.pplh.ru/");
        }
        PepeLandHelper.loadUser(false);
        FabricLoader.getInstance().getModContainer("pplhelper").ifPresent(s -> ResourceManagerHelper.registerBuiltinResourcePack((class_2960)GuiUtils.getResourceLocation((String)"pplhelper", (String)"icons"), (ModContainer)s, (class_2561)class_2561.method_43471((String)"resourcePack.pplhelper.icons"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL));
        ClientLifecycleEvents.CLIENT_FULL_STARTED.register(s -> {
            gameStarted = true;
            new Thread(() -> {
                PepeLandHelper.loadStaticInformation();
                PepeLandHelper.checkModUpdates(s);
            }).start();
            if (FabricLoader.getInstance().isModLoaded("minedows")) {
                MinedowsManager.register();
            }
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(s -> OAuth.stop());
        ClientTickEvents.START_CLIENT_TICK.register(s -> {
            if (PepeLandHelper.playerInPPL() && s.field_1724 != null) {
                InteractiveManager.checkPlayerPosition(s.field_1724);
            }
        });
        if (PepeLandHelper.isTestSubject()) {
            GuiRenderEvents.RENDER.register((Object)new GUIRender());
            ClientTickEvents.START_CLIENT_TICK.register((Object)new LevelTick());
        }
        ClientCommandRegistrationCallback.EVENT.register(PPLHelperCommand::register);
        class_304 key1 = KeyMappingHelper.register((class_304)new class_304("pplhelper.key.open.projects", 72, "pplhelper"));
        class_304 key2 = KeyMappingHelper.register((class_304)new class_304("pplhelper.key.open.config", -1, "pplhelper"));
        class_304 key3 = KeyMappingHelper.register((class_304)new class_304("pplhelper.key.unfollow_project", -1, "pplhelper"));
        class_304 key4 = KeyMappingHelper.register((class_304)new class_304("pplhelper.key.stealth", -1, "pplhelper"));
        class_304 key5 = KeyMappingHelper.register((class_304)new class_304("pplhelper.key.stealth.world", -1, "pplhelper"));
        class_304 key6 = KeyMappingHelper.register((class_304)new class_304("pplhelper.key.stealth.common_world", -1, "pplhelper"));
        ClientTickEvents.START_CLIENT_TICK.register(s -> {
            if (gameStarted && loginAval != (user == null)) {
                boolean bl = loginAval = user == null;
                if (loginAval) {
                    OAuth.run();
                } else {
                    OAuth.stop();
                }
            }
            if (lastWorld != TabHelper.getWorld() && s.method_1558() != null) {
                boolean bl = lastLobby = lastWorld == TabHelper.Worlds.LOBBY;
                if (lastLobby) {
                    joinTime = System.currentTimeMillis() + 15000L;
                }
                lastWorld = TabHelper.getWorld();
            }
            if (restartTime != -1L || joinTime != -1L) {
                PepeLandHelper.updateBossBar();
            }
            PepeLandHelper.updateCoordinatesBB();
            if (key1.method_1436()) {
                new Thread(() -> {
                    if (PepeLandHelperAPI.apiAvailable()) {
                        AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507((class_437)new ProjectsScreen(AlinLib.MINECRAFT.field_1755)));
                    } else {
                        new ToastBuilder().setTitle((class_2561)class_2561.method_43471((String)"pplhelper.api")).setMessage(PepeLandHelperAPI.getMessageFromBreakAPI()).setType(ToastBuilder.Type.ERROR).setIcon(Icons.WHITE_PEPE).buildAndShow();
                    }
                }).start();
            }
            if (key2.method_1436()) {
                AlinLib.MINECRAFT.method_1507(new ConfigScreen().build(AlinLib.MINECRAFT.field_1755));
            }
            if (key3.method_1436() && FollowManager.getCurrentCoordinates() != null) {
                FollowManager.resetCoordinates();
            }
            if (key4.method_1436()) {
                config.setBoolean("STEALTH", !config.getBoolean("STEALTH", false));
            }
            if (key5.method_1436() && TabHelper.getWorld() != null && config.getBoolean("STEALTH.CURRENT_WORLD", true)) {
                config.setBoolean(String.format("STEALTH.WORLD.%s", TabHelper.getWorld().shortName.toUpperCase()), !config.getBoolean(String.format("STEALTH.WORLD.%s", TabHelper.getWorld().shortName.toUpperCase()), true));
            }
            if (key6.method_1436()) {
                config.setBoolean("STEALTH.CURRENT_WORLD", !config.getBoolean("STEALTH.CURRENT_WORLD", true));
            }
        });
        LocalizationEvents.DEFAULT_PARSER_INIT.register(starScript -> starScript.ss.set("pplhelper.world", () -> {
            TabHelper.Worlds world = TabHelper.getWorld();
            return Value.string((String)(world == null ? "" : world.title.getString()));
        }).set("pplhelper.world_short", () -> {
            TabHelper.Worlds world = TabHelper.getWorld();
            return Value.string((String)(world == null ? "" : world.shortName));
        }).set("pplhelper.tps", () -> Value.number((double)TabHelper.getTPS())).set("pplhelper.online", () -> Value.number((double)TabHelper.getOnline())).set("pplhelper.max_online", () -> Value.number((double)TabHelper.getMaxOnline())));
        if (isInstalledSailStatus) {
            SailStatusManager.register();
        } else if (config.getBoolean("DISCORD", false)) {
            DiscordActivityManager.initialize();
            ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        }
    }

    private void onClientTick(class_310 minecraft) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - discordRpcLastUpdatedTime < 1000L) {
            return;
        }
        if (TabHelper.getWorld() == null) {
            DiscordActivityManager.clearPresence();
        }
        discordRpcLastUpdatedTime = currentTime;
        if (PepeLandHelper.playerInPPL()) {
            try {
                DiscordActivityManager.updatePresence();
            }
            catch (RuntimeException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static AbstractBuilder[] getPanelWidgets(class_437 parent, class_437 current) {
        boolean apiEnable = PepeLandHelperAPI.apiAvailable();
        AbstractBuilder[] buttons = new AbstractBuilder[]{new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.news")).setOnPress(s -> new Thread(() -> {
            NewsListScreen screen = new NewsListScreen(current);
            AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507(screen));
        }).start()).setIcon(ru.kelcuprum.alinlib.gui.Icons.WIKI).setCentered(false), new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.projects")).setOnPress(s -> new Thread(() -> {
            ProjectsScreen screen = new ProjectsScreen(current);
            AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507(screen));
        }).start()).setIcon(Icons.PROJECTS).setCentered(false), new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.projects.archived")).setOnPress(s -> new Thread(() -> {
            ArchivedProjectsScreen screen = new ArchivedProjectsScreen(current);
            AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507(screen));
        }).start()).setIcon(Icons.WHITE_PEPE).setCentered(false), new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.commands")).setOnPress(s -> new Thread(() -> {
            class_437 screen = new CommandsScreen().build(parent);
            AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507(screen));
        }).start()).setIcon(Icons.COMMANDS).setCentered(false), new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.emotes")).setOnPress(s -> new Thread(() -> {
            class_437 screen = new EmotesScreen().build(parent);
            AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507(screen));
        }).start()).setIcon(PepeLandHelper.getInstalledPack() == null ? ru.kelcuprum.alinlib.gui.Icons.CLOWNFISH : GuiUtils.getResourceLocation((String)"myemotes", (String)"textures/font/emotes/clueless.png")).setCentered(false).setActive(PepeLandHelper.getInstalledPack() != null), new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.mods")).setOnPress(s -> new Thread(() -> {
            class_437 screen = new ModsScreen().build(parent);
            AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507(screen));
        }).start()).setIcon(Icons.MODS).setCentered(false), new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.pack")).setOnPress(s -> new Thread(() -> {
            class_437 screen = new UpdaterScreen().build(parent);
            AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507(screen));
        }).start()).setIcon(Icons.PACK_INFO).setCentered(false), PepeLandHelper.getProfileButton(parent)};
        if (!apiEnable) {
            buttons = new AbstractBuilder[]{new TextBuilder(PepeLandHelperAPI.getMessageFromBreakAPI()).setType(TextBuilder.TYPE.BLOCKQUOTE).setColor(-938447), new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.emotes")).setOnPress(s -> {
                class_437 screen = new EmotesScreen().build(parent);
                AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507(screen));
            }).setIcon(PepeLandHelper.getInstalledPack() == null ? ru.kelcuprum.alinlib.gui.Icons.CLOWNFISH : GuiUtils.getResourceLocation((String)"myemotes", (String)"textures/font/emotes/clueless.png")).setCentered(false).setActive(PepeLandHelper.getInstalledPack() != null), new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.pack")).setOnPress(s -> new Thread(() -> {
                class_437 screen = new UpdaterScreen().build(parent);
                AlinLib.MINECRAFT.execute(() -> AlinLib.MINECRAFT.method_1507(screen));
            }).start()).setIcon(Icons.PACK_INFO).setCentered(false)};
        }
        return buttons;
    }

    public static ButtonBuilder getProfileButton(class_437 parent) {
        ButtonBuilder builder = new ButtonBuilder((class_2561)class_2561.method_43471((String)(user == null ? "pplhelper.oauth.login" : "pplhelper.oauth.profile")));
        builder.setIcon(ru.kelcuprum.alinlib.gui.Icons.WIKI).setCentered(false);
        builder.setOnPress(s -> {
            if (user == null) {
                PepeLandHelper.confirmLinkNow(AlinLib.MINECRAFT.field_1755, String.format("http://localhost:%s", Integer.parseInt(config.getString("oauth.port", "11430"))));
            } else {
                AlinLib.MINECRAFT.method_1507((class_437)new ProfileScreen(parent, user));
            }
        });
        return builder;
    }

    public static void loadUser(boolean withToast) {
        String token = config.getString("oauth.access_token", "");
        if (token.isBlank()) {
            return;
        }
        user = OAuth.getUser(token);
        if (user != null && withToast) {
            new ToastBuilder().setTitle((class_2561)class_2561.method_43471((String)"pplhelper")).setMessage((class_2561)class_2561.method_43469((String)"pplhelper.oauth.hello", (Object[])new Object[]{PepeLandHelper.user.nickname == null ? PepeLandHelper.user.username : PepeLandHelper.user.nickname})).setIcon(class_1802.field_8137).buildAndShow();
        }
    }

    public static void executeCommand(class_746 player, String command) {
        if (command.startsWith("/")) {
            command = command.substring(1);
            player.field_3944.method_45730(command);
        } else {
            player.field_3944.method_45729(command);
        }
    }

    public static boolean isABILegacy() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("actionbarinfo").get()).getMetadata().getVersion().getFriendlyString().startsWith("1.");
    }

    public static void checkModUpdates(class_310 s) {
        PepeLandHelper.checkPackUpdates();
    }

    public static void checkPackUpdates() {
        try {
            String packVersion = PepeLandHelper.getInstalledPackVersion();
            boolean modrinth = config.getBoolean("PACK.MODRINTH", true);
            if ((config.getBoolean("PACK_UPDATES.NOTICE", true) || config.getBoolean("PACK_UPDATES.AUTO_UPDATE", true)) && !packVersion.isEmpty()) {
                JsonObject packInfo = PepeLandAPI.getPackInfo(PepeLandHelper.onlyEmotesCheck(), modrinth);
                if (config.getBoolean("PACK_UPDATES.NOTICE", true) && !config.getBoolean("PACK_UPDATES.AUTO_UPDATE", false)) {
                    if (!packInfo.get("version").getAsString().equals(packVersion)) {
                        new ToastBuilder().setTitle((class_2561)class_2561.method_43471((String)"pplhelper")).setMessage((class_2561)class_2561.method_43471((String)"pplhelper.pack.update.avalible")).setIcon(class_1802.field_30904).buildAndShow();
                    }
                } else if (config.getBoolean("PACK_UPDATES.AUTO_UPDATE", false) && !packInfo.get("version").getAsString().equals(packVersion)) {
                    PepeLandHelper.downloadPack(packInfo, PepeLandHelper.onlyEmotesCheck(), ss -> {
                        if (ss) {
                            String fileName = String.format("pepeland-%1$s-v%2$s.zip", PepeLandHelper.onlyEmotesCheck() ? "emotes" : "main", packInfo.get("version").getAsString());
                            AlinLib.MINECRAFT.method_1520().method_14445();
                            for (class_3288 pack : AlinLib.MINECRAFT.method_1520().method_14444()) {
                                if (!pack.method_14459().getString().toLowerCase().contains("pepeland pack")) continue;
                                AlinLib.MINECRAFT.method_1520().method_49428(pack.method_14463());
                            }
                            for (class_3288 pack : AlinLib.MINECRAFT.method_1520().method_14441()) {
                                if (!pack.method_14463().contains(fileName)) continue;
                                AlinLib.MINECRAFT.method_1520().method_49427(pack.method_14463());
                            }
                            AlinLib.MINECRAFT.field_1690.method_49598(AlinLib.MINECRAFT.method_1520());
                            new ToastBuilder().setTitle((class_2561)class_2561.method_43471((String)"pplhelper")).setIcon(Icons.WHITE_PEPE).setMessage((class_2561)class_2561.method_43469((String)"pplhelper.pack.downloaded", (Object[])new Object[]{packInfo.get("version").getAsString()})).buildAndShow();
                        } else {
                            new ToastBuilder().setTitle((class_2561)class_2561.method_43471((String)"pplhelper")).setMessage((class_2561)class_2561.method_43471((String)"pplhelper.pack.file_broken")).setIcon(ru.kelcuprum.alinlib.gui.Icons.DONT).buildAndShow();
                        }
                    }, modrinth);
                }
            }
        }
        catch (Exception ex) {
            new ToastBuilder().setTitle((class_2561)class_2561.method_43471((String)"pplhelper")).setMessage((class_2561)class_2561.method_43470((String)"\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u0430\u0432\u0442\u043e-\u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f, \u0437\u0430\u0433\u043b\u044f\u043d\u0438\u0442\u0435 \u0432 \u043b\u043e\u0433\u0438!")).setType(ToastBuilder.Type.ERROR).setIcon(ru.kelcuprum.alinlib.gui.Icons.DONT).buildAndShow();
            ex.printStackTrace();
        }
    }

    public static void loadStaticInformation() {
        try {
            if (PepeLandHelperAPI.apiAvailable()) {
                JsonObject common_info = PepeLandHelperAPI.getCommonInformation();
                tradeRegistry = common_info.getAsJsonObject("trade_registry");
                trade = common_info.getAsJsonObject("trade");
                TradeManager.loadInfo(trade);
                commands = common_info.getAsJsonArray("commands");
                mods = common_info.getAsJsonArray("recommend_mods");
                resource_packs = common_info.getAsJsonArray("resource_packs");
                modsLoaded = true;
                pc = PepeLandHelper.categoriesShit(common_info.getAsJsonObject("categories").getAsJsonArray("projects"), true);
                pct = PepeLandHelper.categoriesTagsShit(common_info.getAsJsonObject("categories").getAsJsonArray("projects"), true);
                nc = PepeLandHelper.categoriesShit(common_info.getAsJsonObject("categories").getAsJsonArray("news"), true);
                nct = PepeLandHelper.categoriesTagsShit(common_info.getAsJsonObject("categories").getAsJsonArray("news"), true);
                sc = PepeLandHelper.categoriesShit(common_info.getAsJsonObject("categories").getAsJsonArray("seasons"), false);
                sct = PepeLandHelper.categoriesTagsShit(common_info.getAsJsonObject("categories").getAsJsonArray("seasons"), false);
                categoriesAndTags = true;
                worlds = PepeLandHelper.jsonArrayToString(common_info.getAsJsonArray("worlds"));
                worldsLoaded = true;
            } else {
                new ToastBuilder().setTitle((class_2561)class_2561.method_43471((String)"pplhelper.api")).setMessage((class_2561)class_2561.method_43471((String)"pplhelper.api.unavailable")).setIcon(Icons.WHITE_PEPE).setType(ToastBuilder.Type.ERROR).buildAndShow();
            }
        }
        catch (Exception ex) {
            Exception exc = new Exception("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438\n" + ex.getMessage());
            exc.setStackTrace(ex.getStackTrace());
            exc.printStackTrace();
            new ToastBuilder().setTitle((class_2561)class_2561.method_43470((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438")).setMessage((class_2561)class_2561.method_43470((String)ex.getMessage())).setIcon(Icons.WHITE_PEPE).setType(ToastBuilder.Type.ERROR).buildAndShow();
        }
    }

    public static String[] jsonArrayToString(JsonArray jsonArray) {
        String[] strings = new String[jsonArray.size()];
        int i = 0;
        for (JsonElement jsonElement : jsonArray) {
            strings[i] = jsonElement.getAsString();
            ++i;
        }
        return strings;
    }

    public static String[] categoriesShit(JsonArray jsonArray, boolean needAddAll) {
        String[] categories = new String[jsonArray.size() + (needAddAll ? 1 : 0)];
        if (needAddAll) {
            categories[0] = class_2561.method_43471((String)"pplhelper.project.world.all").getString();
        }
        int size = needAddAll ? 1 : 0;
        for (JsonElement data : jsonArray) {
            categories[size] = GsonHelper.jsonElementIsNull((String)"translatable", (JsonObject)((JsonObject)data)) ? GsonHelper.getStringInJSON((String)"name", (JsonObject)((JsonObject)data), (String)"") : class_2561.method_43471((String)GsonHelper.getStringInJSON((String)"name", (JsonObject)((JsonObject)data), (String)"")).getString();
            ++size;
        }
        return categories;
    }

    public static String[] categoriesShit(String[] jsonArray, boolean needAddAll) {
        String[] categories = new String[jsonArray.length + (needAddAll ? 1 : 0)];
        if (needAddAll) {
            categories[0] = class_2561.method_43471((String)"pplhelper.project.world.all").getString();
        }
        int size = needAddAll ? 1 : 0;
        String[] stringArray = jsonArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String data;
            categories[size] = data = stringArray[i];
            ++size;
        }
        return categories;
    }

    public static String[] categoriesTagsShit(String[] jsonArray, boolean needAddAll) {
        String[] categories = new String[jsonArray.length + (needAddAll ? 1 : 0)];
        if (needAddAll) {
            categories[0] = "";
        }
        int size = needAddAll ? 1 : 0;
        String[] stringArray = jsonArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String data;
            categories[size] = data = stringArray[i];
            ++size;
        }
        return categories;
    }

    public static String[] categoriesTagsShit(JsonArray jsonArray, boolean needAddAll) {
        String[] categories = new String[jsonArray.size() + (needAddAll ? 1 : 0)];
        if (needAddAll) {
            categories[0] = "";
        }
        int size = needAddAll ? 1 : 0;
        for (JsonElement data : jsonArray) {
            categories[size] = class_2561.method_43471((String)GsonHelper.getStringInJSON((String)"tag", (JsonObject)((JsonObject)data), (String)"")).getString();
            ++size;
        }
        return categories;
    }

    public static boolean isAprilFool() {
        return AlinLib.isAprilFool() || user != null && PepeLandHelper.user.role.TESTING_APRIL_FOOL && config.getBoolean("IM_A_TEST_SUBJECT.APRIL", false);
    }

    public static boolean isPWGood() {
        return AlinLib.MINECRAFT.method_53462().getName().equals("PWGoood") || AlinLib.MINECRAFT.method_53462().getName().equals("_PWGood_") || AlinLib.MINECRAFT.method_53462().getName().equals("CyCeKu") || config.getBoolean("IM_A_TEST_SUBJECT.PWGOOD", false);
    }

    public static boolean isPPLStreamer() {
        return false;
    }

    public static void updateBossBar() {
        long rest;
        if (restartTime == 0L) {
            restartTime = -1L;
            if (rtBossBar != null) {
                rtBossBar = null;
                AlinLib.MINECRAFT.field_1705.method_1740().method_1795(class_2629.method_34090((UUID)rtUUID));
            }
        } else if (!PepeLandHelper.playerInPPL()) {
            if (rtBossBar != null) {
                rtBossBar = null;
                AlinLib.MINECRAFT.field_1705.method_1740().method_1795(class_2629.method_34090((UUID)rtUUID));
            }
        } else {
            rest = restartTime - System.currentTimeMillis();
            if (rest <= 0L || !config.getBoolean("TIMER.RESTART", true)) {
                restartTime = 0L;
            } else {
                rtBossBar = new class_345(rtUUID, (class_2561)class_2561.method_43469((String)"pplhelper.restart", (Object[])new Object[]{PepeLandHelper.getTimestamp(rest)}), Math.min((float)rest / 300000.0f, 1.0f), rest >= 180000L ? class_1259.class_1260.field_5785 : (rest >= 60000L ? class_1259.class_1260.field_5782 : class_1259.class_1260.field_5784), class_1259.class_1261.field_5790, false, false, false);
                AlinLib.MINECRAFT.field_1705.method_1740().method_1795(class_2629.method_34089((class_1259)rtBossBar));
            }
        }
        if (joinTime == 0L) {
            joinTime = -1L;
            if (jtBossBar != null) {
                jtBossBar = null;
                AlinLib.MINECRAFT.field_1705.method_1740().method_1795(class_2629.method_34090((UUID)jtUUID));
            }
        } else if (!PepeLandHelper.playerInPPL() || TabHelper.getWorld() != TabHelper.Worlds.LOBBY) {
            if (jtBossBar != null) {
                jtBossBar = null;
                AlinLib.MINECRAFT.field_1705.method_1740().method_1795(class_2629.method_34090((UUID)jtUUID));
            }
        } else {
            rest = joinTime - System.currentTimeMillis();
            if (rest <= 0L || !config.getBoolean("TIMER.JOIN", true)) {
                joinTime = 0L;
            } else {
                jtBossBar = new class_345(jtUUID, (class_2561)class_2561.method_43469((String)"pplhelper.join", (Object[])new Object[]{PepeLandHelper.getTimestamp(rest)}), (float)rest / 15000.0f, class_1259.class_1260.field_5784, class_1259.class_1261.field_5795, false, false, false);
                AlinLib.MINECRAFT.field_1705.method_1740().method_1795(class_2629.method_34089((class_1259)jtBossBar));
            }
        }
    }

    public static void updateCoordinatesBB() {
        FollowManager.Coordinates coordinates = FollowManager.getCurrentCoordinates();
        if (coordinates == null || !PepeLandHelper.playerInPPL() || config.getBoolean("SPROJECT.ABI", true) && isInstalledABI) {
            if (spBossBar != null) {
                spBossBar = null;
                lastMaxNear = 0L;
                AlinLib.MINECRAFT.field_1705.method_1740().method_1795(class_2629.method_34090((UUID)spUUID));
            }
        } else {
            if (TabHelper.getWorld() == null) {
                return;
            }
            String parsedCoordinates = coordinates.getStringCoordinates();
            class_746 p = AlinLib.MINECRAFT.field_1724;
            long near = 0L;
            Object huy = "";
            if (!FollowManager.playerInCurrentLevel()) {
                huy = (String)huy + " (" + FollowManager.getLevelName(coordinates.level()) + ")";
            }
            if (p != null && FollowManager.playerInCurrentWorld() && FollowManager.playerInCurrentLevel()) {
                near = (long)FollowManager.dist(coordinates.coordinates()[0], coordinates.coordinates()[coordinates.coordinates().length - 1], p.method_31477(), p.method_31479());
                if (near <= config.getNumber("SELECTED_PROJECT.AUTO_HIDE", (Number)5).longValue()) {
                    FollowManager.resetCoordinates();
                    lastMaxNear = 0L;
                    return;
                }
                huy = String.format(" (%s \u0431\u043b\u043e\u043a\u043e\u0432 \u043e\u0442 \u0432\u0430\u0441)", near);
            }
            lastMaxNear = Math.max(lastMaxNear, near);
            if (coordinates.world() != null) {
                spBossBar = new class_345(spUUID, (class_2561)class_2561.method_43469((String)"pplhelper.selected_project", (Object[])new Object[]{coordinates.world().shortName, parsedCoordinates, huy}), (float)near / (float)lastMaxNear, class_1259.class_1260.field_5785, class_1259.class_1261.field_5795, false, false, false);
                AlinLib.MINECRAFT.field_1705.method_1740().method_1795(class_2629.method_34089((class_1259)spBossBar));
            }
        }
    }

    public static String getTimestamp(long milliseconds) {
        int seconds = (int)(milliseconds / 1000L) % 60;
        int minutes = (int)(milliseconds / 60000L % 60L);
        int hours = (int)(milliseconds / 3600000L % 24L);
        if (hours > 0) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static boolean onlyEmotesCheck() {
        return config.getBoolean("PACK_UPDATES.ONLY_EMOTE", false);
    }

    public static String getInstalledPackVersion() {
        String packVersion = "";
        for (class_3288 pack : AlinLib.MINECRAFT.method_1520().method_14441()) {
            String[] info;
            String desc = Localization.clearFormatCodes((String)pack.method_14459().getString()).toLowerCase();
            if (!desc.contains("pepeland pack") || !AlinLib.MINECRAFT.method_1520().method_14444().contains(pack) || (info = Localization.clearFormatCodes((String)pack.method_14459().getString()).split("v")).length <= 1) continue;
            packVersion = info[1];
        }
        return packVersion;
    }

    public static String[] getEmotes() throws IOException {
        String[] emotes = new String[]{};
        if (PepeLandHelper.getInstalledPack() == null) {
            return emotes;
        }
        InputStream is = (InputStream)PepeLandHelper.getInstalledPack().method_14458().method_14405(class_3264.field_14188, class_2960.method_60656((String)"font/uniform.json")).get();
        JsonObject font = class_3518.method_15285((String)PepeLandHelper.isToString(is));
        JsonArray provider = font.getAsJsonArray("providers");
        emotes = new String[provider.size()];
        int i = 0;
        for (JsonElement element : provider) {
            JsonObject emote = (JsonObject)element;
            emotes[i] = emote.getAsJsonArray("chars").get(0).getAsString();
            LOG.log(emotes[i]);
            ++i;
        }
        return emotes;
    }

    public static HashMap<String, String> getEmotesPath() throws IOException {
        HashMap<String, String> emotes = new HashMap<String, String>();
        if (PepeLandHelper.getInstalledPack() == null) {
            return emotes;
        }
        if (lastEmotes == null) {
            InputStream is = (InputStream)PepeLandHelper.getInstalledPack().method_14458().method_14405(class_3264.field_14188, class_2960.method_60656((String)"font/uniform.json")).get();
            JsonObject font = class_3518.method_15285((String)PepeLandHelper.isToString(is));
            JsonArray provider = font.getAsJsonArray("providers");
            for (JsonElement element : provider) {
                JsonObject emote = (JsonObject)element;
                emotes.put(emote.get("file").getAsString(), emote.getAsJsonArray("chars").get(0).getAsString());
            }
            lastEmotes = emotes;
        } else {
            emotes = lastEmotes;
        }
        return emotes;
    }

    public static String isToString(InputStream is) throws IOException {
        byte[] requestBodyBytes = is.readAllBytes();
        return new String(requestBodyBytes);
    }

    public static class_3288 getInstalledPack() {
        class_3288 packVersion = null;
        for (class_3288 pack : AlinLib.MINECRAFT.method_1520().method_14441()) {
            String[] info;
            String desc = Localization.clearFormatCodes((String)pack.method_14459().getString()).toLowerCase();
            if (!desc.contains("pepeland pack") || !AlinLib.MINECRAFT.method_1520().method_14444().contains(pack) || (info = Localization.clearFormatCodes((String)pack.method_14459().getString()).split("v")).length <= 1) continue;
            packVersion = pack;
        }
        return packVersion;
    }

    public static String getAvailablePack() {
        String packId = "";
        for (class_3288 pack : AlinLib.MINECRAFT.method_1520().method_14441()) {
            if (!Localization.clearFormatCodes((String)pack.method_14459().getString()).toLowerCase().contains("pepeland pack") || AlinLib.MINECRAFT.method_1520().method_14444().contains(pack)) continue;
            packId = pack.method_14463();
            break;
        }
        return packId;
    }

    public static boolean playerInPPL() {
        if (AlinLib.MINECRAFT.field_1687 == null) {
            return false;
        }
        return PepeLandHelper.isTestSubject() || AlinLib.MINECRAFT.method_1558() != null && AlinLib.MINECRAFT.method_1558().field_3761.contains("pepeland.net");
    }

    public static boolean isTestSubject() {
        return config.getBoolean("IM_A_TEST_SUBJECT", false) || FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static Thread downloadPack(JsonObject packData, boolean onlyEmote, BooleanConsumer consumer, boolean modrinth) {
        Thread thread = new Thread(() -> {
            try {
                String originalChecksum = packData.get("checksum").getAsString();
                String path = AlinLib.MINECRAFT.method_1479().resolve(String.format("pepeland-%1$s-v%2$s.zip", onlyEmote ? "emotes" : "main", packData.get("version").getAsString())).toString();
                File file = new File(path);
                if (!file.exists()) {
                    PepeLandAPI.downloadFile$queue(packData.get("url").getAsString(), AlinLib.MINECRAFT.method_1479().toString(), String.format("pepeland-%1$s-v%2$s.zip", onlyEmote ? "emotes" : "main", packData.get("version").getAsString()), originalChecksum, modrinth, 5);
                }
                if (!file.exists() || !originalChecksum.contains(PepeLandHelper.toSHA(path, modrinth))) {
                    if (file.exists()) {
                        file.deleteOnExit();
                    }
                    throw new RuntimeException(class_2561.method_43471((String)"pplhelper.pack.file_broken").getString());
                }
                consumer.accept(true);
            }
            catch (Exception e) {
                LOG.error(e.getMessage() == null ? e.getClass().getName() : e.getMessage());
                consumer.accept(false);
            }
        });
        thread.start();
        return thread;
    }

    public static String toSHA(String filePath, boolean modrinth) throws NoSuchAlgorithmException, IOException {
        int bytesRead;
        MessageDigest digest = MessageDigest.getInstance(modrinth ? "SHA-512" : "SHA-256");
        FileInputStream fis = new FileInputStream(filePath);
        byte[] buffer = new byte[1024];
        while ((bytesRead = fis.read(buffer)) != -1) {
            digest.update(buffer, 0, bytesRead);
        }
        fis.close();
        byte[] hashBytes = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte hashByte : hashBytes) {
            String hex = Integer.toHexString(0xFF & hashByte);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public static void confirmLinkNow(class_437 screen, String link) {
        class_310 minecraft = class_310.method_1551();
        minecraft.method_1507((class_437)new ConfirmScreen(screen, Icons.WHITE_PEPE, (class_2561)class_2561.method_43471((String)"pplhelper"), (class_2561)class_2561.method_43471((String)"chat.link.confirmTrusted"), link));
    }

    static {
        spUUID = UUID.randomUUID();
        lastMaxNear = 0L;
        lastEmotes = null;
    }

    public static interface Icons {
        public static final class_2960 WHITE_PEPE = GuiUtils.getResourceLocation((String)"pplhelper", (String)"textures/gui/sprites/white_pepe.png");
        public static final class_2960 PEPE = GuiUtils.getResourceLocation((String)"pplhelper", (String)"textures/gui/sprites/pepe.png");
        public static final class_2960 PACK_INFO = GuiUtils.getResourceLocation((String)"pplhelper", (String)"textures/gui/sprites/pack_info.png");
        public static final class_2960 PROJECTS = GuiUtils.getResourceLocation((String)"pplhelper", (String)"textures/gui/sprites/projects.png");
        public static final class_2960 COMMANDS = GuiUtils.getResourceLocation((String)"pplhelper", (String)"textures/gui/sprites/commands.png");
        public static final class_2960 MODS = GuiUtils.getResourceLocation((String)"pplhelper", (String)"textures/gui/sprites/mods.png");
        public static final class_2960 WEB = GuiUtils.getResourceLocation((String)"pplhelper", (String)"textures/gui/sprites/web.png");
    }
}

