/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import org.apache.logging.log4j.Level;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import ru.kelcuprum.alinlib.AlinLogger;
import ru.kelcuprum.alinlib.WebAPI;
import ru.kelcuprum.alinlib.config.Config;
import ru.pplh.mod.PepeLandHelper;
import ru.pplh.mod.api.OAuth;
import ru.pplh.mod.api.PepeLandAPI;
import ru.pplh.mod.api.PepeLandHelperAPI;
import ru.pplh.mod.api.components.VersionInfo;
import ru.pplh.mod.api.components.user.User;
import ru.pplh.mod.utils.WebUtils;

public class PepeLandHelperPreLaunch
implements PreLaunchEntrypoint {
    public static Config config = new Config("config/pplhelper/config.json");
    public static final AlinLogger LOG = new AlinLogger("PPL Helper > PreLaunch");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onPreLaunch() {
        Optional april = FabricLoader.getInstance().getModContainer("pplhelper_april");
        User user = PepeLandHelperPreLaunch.loadUser();
        boolean isApril = PepeLandHelperPreLaunch.isAprilFool();
        if (!isApril) {
            boolean bl = isApril = config.getBoolean("IM_A_TEST_SUBJECT.APRIL") != false && user != null && user.role.TESTING_APRIL_FOOL;
        }
        if (isApril) {
            try {
                JsonObject notFound;
                HttpRequest.Builder builder = HttpRequest.newBuilder(new URI(PepeLandHelperAPI.getURI("/april")));
                if (user != null) {
                    builder.header("Authorization", "Bearer " + PepeLandHelper.config.getString("oauth.access_token", ""));
                }
                if ((notFound = WebAPI.getJsonObject((HttpRequest.Builder)builder)) == OAuth.Objects.NOT_FOUND) {
                    return;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String minecraft = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata().getVersion().getFriendlyString();
            if (!april.isEmpty()) return;
            try {
                boolean downloaded = PepeLandHelperPreLaunch.downloadFile(PepeLandHelperAPI.getURI(String.format("april/get?version=%s", minecraft), false), "./mods", String.format("april_fool-mc%s.jar", minecraft), user);
                if (!downloaded) return;
                LOG.log("\u0424\u0430\u0439\u043b \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
                String message = "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 l;ajksda \u0431\u044b\u043b\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e!\n\u0411\u0443\u0434\u044c\u0442\u0435 \u0434\u043e\u0431\u0440\u044b, \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u0435 \u0438\u0433\u0440\u0443.\n\nChange-log:\n- ladlkajdljasldad\n- s;kljda;ldasl;dja\n- l;69696969";
                TinyFileDialogs.tinyfd_messageBox((CharSequence)"????Land Helper | lhafdals;l;hasfd", (CharSequence)message, (CharSequence)"ok", (CharSequence)"info", (boolean)false);
                System.exit(0);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (!april.isPresent()) return;
        try {
            ((Path)((ModContainer)april.get()).getOrigin().getPaths().getFirst()).toFile().delete();
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"PepeLand Helper", (CharSequence)"\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u0435 \u0438\u0433\u0440\u0443, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430.", (CharSequence)"ok", (CharSequence)"info", (boolean)false);
            System.exit(0);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static User loadUser() {
        String token = config.getString("oauth.access_token", "");
        if (token.isBlank()) {
            return null;
        }
        return OAuth.getUser(token);
    }

    public static boolean isAprilFool() {
        return LocalDate.now().getMonthValue() == 4 && LocalDate.now().getDayOfMonth() == 1;
    }

    public static void installUpdates(VersionInfo versionInfo) throws IOException {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            LOG.log("\u043d\u0435 \u0431\u044b\u043a\u0443\u044e, \u043d\u0435 \u0431\u043b\u043e\u043a\u0438\u0440\u0443\u044e");
        } else {
            Path path = (Path)((ModContainer)FabricLoaderImpl.INSTANCE.getModContainer("pplhelper").get()).getOrigin().getPaths().getFirst();
            PepeLandAPI.downloadFile(versionInfo.file, "./mods", path.toFile().getName());
            LOG.log("\u0424\u0430\u0439\u043b \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d");
        }
        String message = "\u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 " + versionInfo.latestVersion + " \u0431\u044b\u043b\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e!\n\u0411\u0443\u0434\u044c\u0442\u0435 \u0434\u043e\u0431\u0440\u044b, \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u0435 \u0438\u0433\u0440\u0443.\n\nChange-log:\n" + versionInfo.changelog;
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"PepeLand Helper | \u0410\u0432\u0442\u043e\u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435", (CharSequence)message, (CharSequence)"ok", (CharSequence)"info", (boolean)false);
        System.exit(0);
    }

    public static boolean downloadFile(String fileURL, String saveDir, String filename, User user) {
        try {
            HttpResponse<byte[]> response;
            HttpRequest.Builder builder = HttpRequest.newBuilder(new URI(fileURL));
            if (user != null) {
                builder.header("Authorization", "Bearer " + PepeLandHelper.config.getString("oauth.access_token", ""));
            }
            if (WebUtils.httpClient == null) {
                WebUtils.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
            }
            if ((response = WebUtils.httpClient.send(builder.build(), HttpResponse.BodyHandlers.ofByteArray())).statusCode() != 200) {
                return false;
            }
            byte[] bytes = response.body();
            String saveFilePath = saveDir + File.separator + filename;
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            outputStream.write(bytes);
            outputStream.close();
            PepeLandHelper.LOG.log("File downloaded successfully.", new Object[]{Level.DEBUG});
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

