/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.utils.GsonHelper;
import ru.pplh.mod.PepeLandHelper;
import ru.pplh.mod.api.PepeLandAPI;
import ru.pplh.mod.api.components.News;
import ru.pplh.mod.api.components.SearchResult;
import ru.pplh.mod.api.components.VersionInfo;
import ru.pplh.mod.api.components.project.Page;
import ru.pplh.mod.api.components.project.Project;
import ru.pplh.mod.utils.WebUtils;

public class PepeLandHelperAPI {
    public static long lastCheckAPI = 0L;
    public static boolean lastApiAvailable = false;

    public static String getURI(String url) {
        return PepeLandHelperAPI.getURI(url, true);
    }

    public static String getURI(String url, boolean uriEncode) {
        Object api = PepeLandHelper.config.getString("API_URL", "https://api.pplh.ru/");
        if (!((String)api).endsWith("/")) {
            api = (String)api + "/";
        }
        return String.format("%1$s%2$s", api, uriEncode ? PepeLandAPI.uriEncode(url) : url);
    }

    public static boolean apiAvailable() {
        if (System.currentTimeMillis() - lastCheckAPI <= 1125L) {
            return lastApiAvailable;
        }
        lastCheckAPI = System.currentTimeMillis();
        if (PepeLandHelper.config.getBoolean("OFFLINE_MODE", false)) {
            lastApiAvailable = false;
        }
        try {
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpParams httpParams = httpClient.getParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)5000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)5000);
            HttpGet httpget = new HttpGet(PepeLandHelperAPI.getURI("ping"));
            HttpResponse response = httpClient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            JsonObject content = class_3518.method_15285((String)new String(entity.getContent().readAllBytes()));
            lastApiAvailable = content.has("message") && content.has("time");
        }
        catch (IOException ex) {
            PepeLandHelper.LOG.error("\u0420\u043e\u0441\u043a\u043e\u043c\u043d\u0430\u0434\u0437\u043e\u0440 \u0434\u043e\u0448\u0451\u043b \u0438 \u0434\u043e \u0445\u0435\u043b\u043f\u0435\u0440\u0430... \u043f\u0443\u043f\u0443\u043f\u0443...");
            lastApiAvailable = false;
        }
        catch (Exception ex) {
            lastApiAvailable = false;
        }
        return lastApiAvailable;
    }

    public static class_2561 getMessageFromBreakAPI() {
        if (PepeLandHelper.config.getBoolean("OFFLINE_MODE", false)) {
            return class_2561.method_43471((String)"pplhelper.api.offline_mode");
        }
        try {
            JsonObject content = WebUtils.getJsonObject(PepeLandHelperAPI.getURI("ping", false));
            if (content.has("error")) {
                throw new Exception(GsonHelper.getStringInJSON((String)"error.message", (JsonObject)content));
            }
            return class_2561.method_43473();
        }
        catch (Exception ex) {
            PepeLandHelper.LOG.error("API \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
            return ex.getMessage() == null ? class_2561.method_43471((String)"pplhelper.api.unavailable") : class_2561.method_43469((String)"pplhelper.api.error", (Object[])new Object[]{ex.getMessage()});
        }
    }

    public static JsonObject getCommonInformation() {
        try {
            return WebUtils.getJsonObject(PepeLandHelperAPI.getURI("common_info", false));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static VersionInfo getAutoUpdate(boolean followTwoDotZero) {
        String ver = ((ModContainer)FabricLoader.getInstance().getModContainer("pplhelper").get()).getMetadata().getVersion().getFriendlyString();
        String minecraft = ((ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get()).getMetadata().getVersion().getFriendlyString();
        if (ver.contains("+")) {
            ver = ver.split("\\+")[0];
        }
        try {
            JsonObject jsonObject = WebUtils.getJsonObject(PepeLandHelperAPI.getURI("versions?version=" + PepeLandAPI.uriEncode(ver) + "&allow_two=" + followTwoDotZero + "&mc=" + minecraft, false));
            if (PepeLandHelperAPI.isError(jsonObject)) {
                throw new RuntimeException(jsonObject.getAsJsonObject("error").get("message").getAsString());
            }
            return new VersionInfo(jsonObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new VersionInfo(ver);
        }
    }

    public static SearchResult getProjects(String query, String world, String category, int page) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(new URI(PepeLandHelperAPI.getURI("projects?query=" + PepeLandAPI.uriEncode(query) + "&page=" + page + (String)(world.equalsIgnoreCase(class_2561.method_43471((String)"pplhelper.project.world.all").getString()) ? "" : "&world=" + PepeLandAPI.uriEncode(world)) + (String)(category.isEmpty() ? "" : "&category=" + PepeLandAPI.uriEncode(category)), false)));
            if (PepeLandHelper.user != null) {
                builder.header("Authorization", "Bearer " + PepeLandHelper.config.getString("oauth.access_token", ""));
            }
            JsonObject projects = WebUtils.getJsonObject(builder);
            ArrayList<Project> list = new ArrayList<Project>();
            for (JsonElement element : projects.getAsJsonArray("page")) {
                list.add(new Project(element.getAsJsonObject(), true));
            }
            return new SearchResult(list, projects.getAsJsonObject("info").get("max_pages").getAsInt());
        }
        catch (Exception ex) {
            PepeLandHelper.LOG.error(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage());
            return new SearchResult(new ArrayList(), 1);
        }
    }

    public static JsonObject getProject(int id) {
        try {
            return WebUtils.getJsonObject(PepeLandHelperAPI.getURI(String.format("projects/%s", id), false));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JsonObject getProjectInteractive(int id) {
        try {
            JsonObject jsonObject = WebUtils.getJsonObject(PepeLandHelperAPI.getURI(String.format("projects/%s/interactive", id), false));
            if (PepeLandHelperAPI.isError(jsonObject)) {
                throw PepeLandHelperAPI.getError(jsonObject);
            }
            return jsonObject;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getProjectContent(int id) {
        try {
            return WebUtils.getString(PepeLandHelperAPI.getURI(String.format("projects/%s/content", id), false));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static String getProjectPageContent(int id, String pageID) {
        try {
            return WebUtils.getString(PepeLandHelperAPI.getURI(String.format("projects/%s/pages/%s", id, pageID), false));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static Page[] getProjectPages(int id) {
        try {
            JsonObject jsonObject = WebUtils.getJsonObject(PepeLandHelperAPI.getURI(String.format("projects/%s/pages", id), false));
            if (PepeLandHelperAPI.isError(jsonObject)) {
                throw new RuntimeException(PepeLandHelperAPI.getError(jsonObject));
            }
            Page[] pages = new Page[jsonObject.getAsJsonObject("pages").keySet().size()];
            int i = 0;
            for (String pageID : jsonObject.getAsJsonObject("pages").keySet()) {
                pages[i] = new Page(id, pageID, jsonObject.getAsJsonObject("pages").getAsJsonObject(pageID).get("name").getAsString());
                ++i;
            }
            return pages;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void uploadProjectSchematicFile(byte[] file, int id) throws IOException, InterruptedException {
        if (PepeLandHelper.user == null) {
            return;
        }
        HttpRequest.Builder builder = HttpRequest.newBuilder(URI.create(PepeLandHelperAPI.getURI(String.format("projects/%s?schematic=true", id))));
        builder.header("Authorization", "Bearer " + PepeLandHelper.config.getString("oauth.access_token", ""));
        builder.POST(HttpRequest.BodyPublishers.ofString("hehehe"));
        JsonObject object = class_3518.method_15285((String)WebUtils.getString(builder));
        if (PepeLandHelperAPI.isError(object)) {
            throw new RuntimeException(object.getAsJsonObject("error").get("message").getAsString());
        }
        PepeLandHelper.LOG.log(object.get("message").getAsString());
    }

    public static void updateProject(Project project) throws IOException, InterruptedException {
        if (PepeLandHelper.user == null) {
            return;
        }
        JsonObject data = new JsonObject();
        data.add("data", project.toJSON());
        data.addProperty("content", PepeLandHelperAPI.getProjectContent(project.id));
        JsonObject object = WebUtils.getJsonObject(HttpRequest.newBuilder(URI.create(PepeLandHelperAPI.getURI(String.format("projects/%s", project.id)))).header("Authorization", "Bearer " + PepeLandHelper.config.getString("oauth.access_token", "")).POST(HttpRequest.BodyPublishers.ofString(data.toString())));
        if (PepeLandHelperAPI.isError(object)) {
            throw new RuntimeException(object.getAsJsonObject("error").get("message").getAsString());
        }
        PepeLandHelper.LOG.log(object.get("message").getAsString());
    }

    public static void downlaodProjectSchematic(int id) {
        try {
            PepeLandAPI.downloadFile(PepeLandHelperAPI.getURI(String.format("projects/%s/schematic", id), false), String.valueOf(AlinLib.MINECRAFT.field_1697.toPath()) + "/schematics", String.format("pplhelper-%s.litematic", id));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static SearchResult getArchivedProjects(String query, String season, String category, int page) {
        try {
            JsonObject projects = WebUtils.getJsonObject(PepeLandHelperAPI.getURI("archive/" + season + "?query=" + PepeLandAPI.uriEncode(query) + "&page=" + page + "&page_size=20" + (String)(category.isEmpty() ? "" : "&category=" + PepeLandAPI.uriEncode(category)), false));
            ArrayList<Project> list = new ArrayList<Project>();
            for (JsonElement element : projects.getAsJsonArray("page")) {
                list.add(new Project(element.getAsJsonObject(), true));
            }
            return new SearchResult(list, projects.getAsJsonObject("info").get("max_pages").getAsInt());
        }
        catch (Exception ex) {
            PepeLandHelper.LOG.error(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage());
            return new SearchResult(new ArrayList(), 1);
        }
    }

    public static String getArchivedProjectContent(int id, String season) {
        try {
            return WebUtils.getString(PepeLandHelperAPI.getURI(String.format("archive/%s/%s/content", season, id), false));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static SearchResult getNews(String search, String category) {
        try {
            JsonObject projects = WebUtils.getJsonObject(PepeLandHelperAPI.getURI("news?query=" + PepeLandAPI.uriEncode(search) + (String)(category.isEmpty() ? "" : "&category=" + PepeLandAPI.uriEncode(category)), false));
            ArrayList<News> list = new ArrayList<News>();
            for (JsonElement element : projects.getAsJsonArray("page")) {
                list.add(new News(element.getAsJsonObject(), true));
            }
            return new SearchResult(list, projects.getAsJsonObject("info").get("max_pages").getAsInt());
        }
        catch (Exception ex) {
            PepeLandHelper.LOG.error(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage());
            return new SearchResult(new ArrayList(), 1);
        }
    }

    public static String getNewsContent(int id) {
        try {
            return WebUtils.getString(PepeLandHelperAPI.getURI(String.format("news/%s/content", id), false));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static boolean isError(JsonElement json) {
        return json.isJsonObject() && json.getAsJsonObject().has("error");
    }

    public static Exception getError(JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject().getAsJsonObject("error");
        return new Exception((String)(jsonObject.has("message") && !jsonObject.get("message").getAsString().isBlank() ? jsonObject.get("message").getAsString() : jsonObject.get("codename").getAsNumber().intValue() + " " + jsonObject.get("codename").getAsString()));
    }
}

