/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.api.components;

import com.google.gson.JsonObject;

public class VersionInfo {
    public State state;
    public String version;
    public String latestVersion = "";
    public String page = "";
    public String file = "";
    public String changelog = "";

    public VersionInfo(JsonObject object) {
        this.state = object.get("status").getAsString().equals("new_update") ? State.NEW_UPDATE : (object.get("status").getAsString().equals("unpublished") ? State.UNPUBLISHED : State.LATEST);
        this.version = object.get("checked_version").getAsString();
        if (this.state == State.NEW_UPDATE) {
            JsonObject update = object.getAsJsonObject("update");
            this.latestVersion = update.get("version").getAsString();
            this.changelog = update.get("changelog").getAsString();
            this.page = update.get("page").getAsString();
            this.file = update.get("url").getAsString();
        } else {
            this.latestVersion = this.version;
        }
    }

    public VersionInfo(String curVersion) {
        this.state = State.LATEST;
        this.version = curVersion;
        this.latestVersion = curVersion;
    }

    public static enum State {
        LATEST,
        NEW_UPDATE,
        UNPUBLISHED;

    }
}

