/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.api.components.project;

import com.google.gson.JsonObject;
import java.io.File;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import ru.kelcuprum.alinlib.utils.GsonHelper;
import ru.pplh.mod.api.OAuth;
import ru.pplh.mod.api.PepeLandHelperAPI;
import ru.pplh.mod.api.components.project.Page;
import ru.pplh.mod.api.components.user.User;
import ru.pplh.mod.utils.LitematicaManager;

public class Project {
    public int id;
    public String title;
    public String description;
    public String creators;
    public String author;
    public String icon;
    public String banner;
    public String world;
    public String coordinates$overworld;
    public String coordinates$nether;
    public String coordinates$end;
    public State state;
    public boolean schematicEnable;
    public String schematicRotate;
    public String schematicMirror;
    public int schematicX;
    public int schematicY;
    public int schematicZ;

    public Project(JsonObject info) {
        this(info, false);
    }

    public Project(JsonObject info, boolean isSearch) {
        this.id = info.get("id").getAsInt();
        this.title = GsonHelper.getStringInJSON((String)"data.title", (JsonObject)info, (String)"");
        this.description = GsonHelper.getStringInJSON((String)"data.description", (JsonObject)info, (String)"");
        this.creators = GsonHelper.getStringInJSON((String)"data.creators", (JsonObject)info, (String)class_2561.method_43471((String)"pplhelper.project.unknown_creators").getString());
        this.author = GsonHelper.getStringInJSON((String)(isSearch ? "data.author.id" : "data.author"), (JsonObject)info);
        this.icon = GsonHelper.getStringInJSON((String)"data.icon", (JsonObject)info);
        this.banner = GsonHelper.getStringInJSON((String)"data.banner", (JsonObject)info);
        this.state = Project.getStateByID(GsonHelper.getNumberInJSON((String)"data.state", (JsonObject)info, (Number)0).intValue());
        this.schematicEnable = GsonHelper.getBooleanInJSON((String)"data.schematic.enable", (JsonObject)info, (boolean)false);
        if (this.schematicEnable) {
            this.schematicRotate = GsonHelper.getStringInJSON((String)"data.schematic.rotate", (JsonObject)info, (String)"none");
            this.schematicMirror = GsonHelper.getStringInJSON((String)"data.schematic.mirror", (JsonObject)info, (String)"none");
            this.schematicX = GsonHelper.getNumberInJSON((String)"data.schematic.x", (JsonObject)info, (Number)0).intValue();
            this.schematicY = GsonHelper.getNumberInJSON((String)"data.schematic.y", (JsonObject)info, (Number)0).intValue();
            this.schematicZ = GsonHelper.getNumberInJSON((String)"data.schematic.z", (JsonObject)info, (Number)0).intValue();
        }
        if (!GsonHelper.jsonElementIsNull((String)"data.coordinates", (JsonObject)info)) {
            this.world = GsonHelper.getStringInJSON((String)"data.coordinates.world", (JsonObject)info);
            this.coordinates$overworld = GsonHelper.getStringInJSON((String)"data.coordinates.overworld", (JsonObject)info);
            this.coordinates$nether = GsonHelper.getStringInJSON((String)"data.coordinates.nether", (JsonObject)info);
            this.coordinates$end = GsonHelper.getStringInJSON((String)"data.coordinates.end", (JsonObject)info);
        }
    }

    public JsonObject toJSON() {
        JsonObject project = new JsonObject();
        project.addProperty("title", this.title);
        project.addProperty("description", this.description);
        project.addProperty("creators", this.creators);
        project.addProperty("author", this.author);
        project.addProperty("icon", this.icon);
        project.addProperty("banner", this.banner);
        project.addProperty("state", Project.getIDByState(this.state));
        JsonObject coordinates = new JsonObject();
        coordinates.addProperty("world", this.world);
        coordinates.addProperty("overworld", this.coordinates$overworld);
        coordinates.addProperty("nether", this.coordinates$nether);
        coordinates.addProperty("end", this.coordinates$end);
        project.add("coordinates", coordinates);
        JsonObject schematic = new JsonObject();
        schematic.addProperty("enable", this.schematicEnable);
        schematic.addProperty("rotate", this.schematicRotate);
        schematic.addProperty("mirror", this.schematicMirror);
        schematic.addProperty("x", this.schematicX);
        schematic.addProperty("y", this.schematicY);
        schematic.addProperty("z", this.schematicZ);
        project.add("schematic", schematic);
        return project;
    }

    public String getContent() {
        return PepeLandHelperAPI.getProjectContent(this.id);
    }

    public Page[] getPages() {
        return PepeLandHelperAPI.getProjectPages(this.id);
    }

    public User getAuthor() {
        return OAuth.getUserByID(this.author);
    }

    public void loadSchematic() {
        if (!this.schematicEnable || !FabricLoader.getInstance().isModLoaded("litematica")) {
            return;
        }
        PepeLandHelperAPI.downlaodProjectSchematic(this.id);
        File file = Path.of(String.format("./schematics/pplhelper-%s.litematic", this.id), new String[0]).toFile();
        LitematicaManager.loadSchematic(file, this);
    }

    public static State getStateByID(int id) {
        return switch (id) {
            case 1 -> State.BUILD;
            case 2 -> State.PLANNED;
            default -> State.BUILT;
        };
    }

    public static int getIDByState(State state) {
        return switch (state.ordinal()) {
            case 1 -> 1;
            case 2 -> 2;
            default -> 0;
        };
    }

    public static enum State {
        BUILT,
        BUILD,
        PLANNED;

    }
}

