/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.api.components.user;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import ru.pplh.mod.PepeLandHelper;
import ru.pplh.mod.api.PepeLandHelperAPI;
import ru.pplh.mod.api.components.News;
import ru.pplh.mod.api.components.project.Project;
import ru.pplh.mod.api.components.user.Role;
import ru.pplh.mod.api.components.user.Studio;
import ru.pplh.mod.utils.WebUtils;

public class User {
    public String nickname;
    public String username;
    public String description;
    public String id;
    public String avatar;
    public Role role = new Role(new JsonObject());
    public Studio studio = new Studio(new JsonObject());

    public User(JsonObject object) {
        if (object.has("nickname")) {
            this.nickname = object.get("nickname").getAsString();
        }
        if (object.has("username")) {
            this.username = object.get("username").getAsString();
        }
        if (object.has("description")) {
            this.description = object.get("description").getAsString();
        }
        if (object.has("id")) {
            this.id = object.get("id").getAsString();
        }
        if (object.has("avatar")) {
            this.avatar = object.get("avatar").getAsString();
        }
        if (object.has("role")) {
            this.role = new Role(object.getAsJsonObject("role"));
        }
        if (object.has("studio")) {
            this.studio = new Studio(object.getAsJsonObject("studio"));
        }
    }

    public List<Project> getProjects() {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder(new URI(PepeLandHelperAPI.getURI("projects?id=" + this.id + "&page_size=2147483647", false)));
            if (PepeLandHelper.user != null) {
                builder.header("Authorization", "Bearer " + PepeLandHelper.config.getString("oauth.access_token", ""));
            }
            JsonObject projects = WebUtils.getJsonObject(builder);
            ArrayList<Project> list = new ArrayList<Project>();
            for (JsonElement element : projects.getAsJsonArray("page")) {
                list.add(new Project(element.getAsJsonObject(), true));
            }
            return list;
        }
        catch (Exception ex) {
            PepeLandHelper.LOG.error(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage());
            return new ArrayList<Project>();
        }
    }

    public List<News> getNews() {
        try {
            JsonObject projects = WebUtils.getJsonObject(PepeLandHelperAPI.getURI("news?id=" + this.id + "&page_size=2147483647", false));
            ArrayList<News> list = new ArrayList<News>();
            for (JsonElement element : projects.getAsJsonArray("page")) {
                list.add(new News(element.getAsJsonObject(), true));
            }
            return list;
        }
        catch (Exception ex) {
            PepeLandHelper.LOG.error(ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage());
            return new ArrayList<News>();
        }
    }
}

