/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.gui;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.pplh.mod.PepeLandHelper;

public class TextureHelper {
    public static HashMap<String, class_2960> resourceLocationMap = new HashMap();
    public static HashMap<String, Boolean> urls = new HashMap();
    public static HashMap<String, class_1043> urlsTextures = new HashMap();
    public static HashMap<String, class_1011> urlsImages = new HashMap();

    public static class_2960 getTexture(String url, String id) {
        if (resourceLocationMap.containsKey(id = TextureHelper.formatUrls(id.toLowerCase()))) {
            return resourceLocationMap.get(id);
        }
        if (!urls.getOrDefault(id, false).booleanValue()) {
            urls.put(id, true);
            String finalId = id;
            new Thread(() -> TextureHelper.registerTexture(url, finalId, AlinLib.MINECRAFT.method_1531(), GuiUtils.getResourceLocation((String)"pplhelper", (String)finalId))).start();
        }
        return PepeLandHelper.Icons.WHITE_PEPE;
    }

    public static void registerTexture(String url, String id, class_1060 textureManager, class_2960 textureId) {
        PepeLandHelper.LOG.debug(String.format("REGISTER: %s %s", url, id));
        AtomicReference<class_1043> texture = new AtomicReference<class_1043>();
        if (urlsTextures.containsKey(url)) {
            texture.set(urlsTextures.get(url));
        } else {
            try {
                BufferedImage bufferedImage = ImageIO.read(new URL(url));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, url.contains(".webp") ? "webp" : "png", byteArrayOutputStream);
                ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                class_1011 image = class_1011.method_4309((InputStream)is);
                class_310.method_1551().execute(() -> texture.set(new class_1043(() -> id, image)));
                urlsTextures.put(url, (class_1043)texture.get());
                urlsImages.put(url, image);
            }
            catch (Exception e) {
                PepeLandHelper.LOG.error("Error loading image from URL: " + url + " - " + e.getMessage());
                resourceLocationMap.put(id, PepeLandHelper.Icons.PACK_INFO);
                return;
            }
        }
        if (textureManager != null) {
            class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture.get()));
            resourceLocationMap.put(id, textureId);
        }
    }

    public static class_2960 getBanner(String url, String id) {
        if (resourceLocationMap.containsKey(id = TextureHelper.formatUrls(id.toLowerCase()))) {
            return resourceLocationMap.get(id);
        }
        if (!urls.getOrDefault(id, false).booleanValue()) {
            urls.put(id, true);
            String finalId = id;
            new Thread(() -> TextureHelper.registerBanner(url, finalId, AlinLib.MINECRAFT.method_1531(), GuiUtils.getResourceLocation((String)"pplhelper", (String)finalId))).start();
        }
        return PepeLandHelper.Icons.WHITE_PEPE;
    }

    public static void registerBanner(String url, String id, class_1060 textureManager, class_2960 textureId) {
        PepeLandHelper.LOG.debug(String.format("REGISTER: %s %s", url, id));
        AtomicReference<class_1043> texture = new AtomicReference<class_1043>();
        if (urlsTextures.containsKey(url)) {
            texture.set(urlsTextures.get(url));
        } else {
            try {
                BufferedImage bufferedImage = ImageIO.read(new URL(url));
                double widthScale = (double)bufferedImage.getWidth() / 750.0;
                int threeHundredBucks = (int)(300.0 * widthScale);
                double scale = (double)bufferedImage.getHeight() / (double)threeHundredBucks;
                int height = (int)((double)bufferedImage.getHeight() / scale);
                if (bufferedImage.getHeight() > height) {
                    int y = (bufferedImage.getHeight() - height) / 2;
                    bufferedImage = bufferedImage.getSubimage(0, y, bufferedImage.getWidth(), bufferedImage.getHeight() - y * 2);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                ByteArrayInputStream is = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                class_1011 image = class_1011.method_4309((InputStream)is);
                class_310.method_1551().execute(() -> texture.set(new class_1043(() -> id, image)));
                urlsTextures.put(url, (class_1043)texture.get());
                urlsImages.put(url, image);
            }
            catch (Exception e) {
                PepeLandHelper.LOG.error("Error loading image from URL: " + url + " - " + e.getMessage());
                resourceLocationMap.put(id, PepeLandHelper.Icons.PACK_INFO);
                return;
            }
        }
        if (textureManager != null) {
            class_310.method_1551().execute(() -> class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture.get()));
            resourceLocationMap.put(id, textureId);
        }
    }

    public static String formatUrls(String url) {
        return url.toLowerCase().replaceAll(" ", "-").replaceAll("[^A-Za-z0-9_-]", "_");
    }
}

