/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.utils;

import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.info.Player;
import ru.pplh.mod.PepeLandHelper;
import ru.pplh.mod.utils.TabHelper;

public class ChatFilter {
    public static boolean enableWorld(String message) {
        if (ChatFilter.isWorldEnabled(message)) {
            String world = message.replaceAll("\\[\u041c\u0438\u0440: (.+?)].+", "$1");
            TabHelper.Worlds worlds = TabHelper.getWorldByName(world);
            if (worlds == null) {
                AlinLib.LOG.log(world);
                return true;
            }
            return PepeLandHelper.config.getBoolean(String.format("CHAT.FILTER.WORLD.%s", worlds.shortName.toUpperCase()), true);
        }
        return true;
    }

    public static boolean isWorldEnabled(String message) {
        return message.replaceAll("\\[\u041c\u0438\u0440: (.+?)]", "").length() < message.length();
    }

    public static boolean isMysteryBox(String message) {
        return message.contains("Mystery Box");
    }

    public static boolean isJoin(String message) {
        return message.startsWith("[+] ");
    }

    public static boolean isLeave(String message) {
        return message.startsWith("[-] ");
    }

    public static boolean isGlobalChat(String message) {
        return message.startsWith("[G] ") || message.replaceAll("\\[\u041c\u0438\u0440: (.+?)] \\[G]", "").length() < message.length();
    }

    public static boolean mention(String message) {
        return message.contains(Player.getName());
    }

    public static boolean isFriend(String message) {
        String[] nicknames;
        boolean response = false;
        String nickname = message.replaceAll("\\[[+-]] (.+?)", "$1");
        for (String friend : nicknames = PepeLandHelper.config.getString("CHAT.FILTER.FRIENDS", "PWGoood, Gwinsen, Pooshka").replaceAll("[^a-zA-Z0-9_,]", "").split(",")) {
            if (!friend.equalsIgnoreCase(nickname)) continue;
            response = true;
            break;
        }
        return response;
    }

    public static boolean isContainsNWords(String message) {
        boolean response = false;
        String[] args = message.split(" ");
        String[] words = PepeLandHelper.config.getString("CHAT.FILTER.NWORDS", "\u0445\u043e\u043a\u043a\u0435\u0439, \u0445\u043e\u043a\u043a\u0435\u0439\u043d\u044b\u0439, \u043c\u0430\u0442\u0447").replaceAll("[ ]", "").split(",");
        block0: for (String arg : args) {
            for (String word : words) {
                if (!arg.equals(word)) continue;
                response = true;
                continue block0;
            }
        }
        return response;
    }

    public static boolean isContainsGandons(String message) {
        String[] words;
        boolean response = false;
        message = message.replaceAll("\\[\u041c\u0438\u0440: (.+?)] \\[G]", "").replace("[G] ", "").toLowerCase();
        for (String word : words = PepeLandHelper.config.getString("CHAT.FILTER.GANDONS", "GaszovayaPlita").replaceAll("[ ]", "").split(",")) {
            if (!message.startsWith(word.toLowerCase()) || ChatFilter.mention(word)) continue;
            response = true;
            break;
        }
        return response;
    }
}

