/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.utils;

import com.jagrosh.discordipc.IPCClient;
import com.jagrosh.discordipc.entities.ActivityType;
import com.jagrosh.discordipc.entities.DiscordBuild;
import com.jagrosh.discordipc.entities.RichPresence;
import com.jagrosh.discordipc.entities.StatusDisplayType;
import java.time.Instant;
import net.minecraft.class_2561;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.config.Localization;
import ru.pplh.mod.PepeLandHelper;

public class DiscordActivityManager {
    private static IPCClient client;
    private static RichPresence currentActivity;
    private static long startTime;
    private static boolean initialized;

    public static void initialize() {
        try {
            client = new IPCClient(1299064772943155322L);
            startTime = Instant.now().getEpochSecond();
            initialized = true;
            client.connect(new DiscordBuild[0]);
        }
        catch (Exception e) {
            System.err.println("Failed to initialize Discord RPC: " + e.getMessage());
        }
    }

    public static void updatePresence() {
        if (!initialized || client == null) {
            return;
        }
        try {
            String details = AlinLib.localization.getParsedText(Localization.fixFormatCodes((String)PepeLandHelper.config.getString("DISCORD.DETAILS", class_2561.method_43471((String)"pplhelper.configs.discord.details.default").getString())));
            String state = AlinLib.localization.getParsedText(Localization.fixFormatCodes((String)PepeLandHelper.config.getString("DISCORD.STATE", class_2561.method_43471((String)"pplhelper.configs.discord.state.default").getString())));
            RichPresence.Builder builder = new RichPresence.Builder();
            builder.setActivityType(ActivityType.Playing);
            builder.setStatusDisplayType(StatusDisplayType.Details);
            builder.setDetails(details);
            builder.setState(state);
            builder.setStartTimestamp(startTime);
            builder.setLargeImage("https://wf.kelcu.ru/logos/ppl7.png", "PepeLand", "https://pepeland.net");
            if (currentActivity == builder.build()) {
                return;
            }
            currentActivity = builder.build();
            client.sendRichPresence(currentActivity);
        }
        catch (Exception e) {
            System.err.println("Error updating Discord presence: " + e.getMessage());
        }
    }

    public static void clearPresence() {
        if (!initialized || client == null) {
            return;
        }
    }

    public static void shutDown() {
        initialized = false;
        if (client != null) {
            try {
                DiscordActivityManager.clearPresence();
                client.close();
                client = null;
            }
            catch (Exception e) {
                System.err.println("Error shutting down Discord RPC: " + e.getMessage());
            }
        }
    }

    static {
        initialized = false;
    }
}

