/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.utils;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.components.builder.text.HorizontalRuleBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;
import ru.pplh.mod.gui.components.ScaledTextBox;
import ru.pplh.mod.gui.components.WebImageWidget;

public class MarkdownParser {
    public static List<class_339> parse(String content, int x, int width, String idForImage, class_437 screen) {
        ArrayList<class_339> widgets = new ArrayList<class_339>();
        String[] strings = content.replaceAll("\r\n", "\n").split("\n");
        boolean lastIsPlain = false;
        boolean lastIsBlockQuote = false;
        Object plain = "";
        Object blockquote = "";
        for (String string : strings) {
            if (string.matches("!\\[(.+?)]\\((.+?)\\)")) {
                class_2561 component;
                if (lastIsPlain) {
                    lastIsPlain = false;
                    component = MarkdownParser.parse((String)plain);
                    widgets.add(new TextBuilder(component).setType(TextBuilder.TYPE.MESSAGE).setPosition(x, -40).setSize(width - 230, 20).build());
                    plain = "";
                }
                if (lastIsBlockQuote) {
                    lastIsBlockQuote = false;
                    component = MarkdownParser.parse((String)blockquote);
                    widgets.add(new TextBuilder(component).setType(TextBuilder.TYPE.BLOCKQUOTE).setPosition(x, -40).setSize(width - 230, 20).build());
                    blockquote = "";
                }
                int iWidth = width - 230;
                int iHeight = 20;
                widgets.add((class_339)new WebImageWidget(x, -2147483647, iWidth, iHeight, MarkdownParser.unparse(string.replaceAll("!\\[(.+?)]\\((.+?)\\)", "$2")), MarkdownParser.unparse(string.replaceAll("!\\[(.+?)]\\((.+?)\\)", "$1")), true, (class_2561)class_2561.method_43473()));
                continue;
            }
            if (string.startsWith("<hr") && string.endsWith(">")) {
                if (lastIsPlain) {
                    lastIsPlain = false;
                    class_2561 component = MarkdownParser.parse((String)plain);
                    widgets.add(new TextBuilder(component).setType(TextBuilder.TYPE.MESSAGE).setPosition(x, -40).setSize(width - 230, 20).build());
                    plain = "";
                }
                if (lastIsBlockQuote) {
                    lastIsBlockQuote = false;
                    class_2561 component = MarkdownParser.parse((String)blockquote);
                    widgets.add(new TextBuilder(component).setType(TextBuilder.TYPE.BLOCKQUOTE).setPosition(x, -40).setSize(width - 230, 20).build());
                    blockquote = "";
                }
                widgets.add(new HorizontalRuleBuilder().setPosition(x, -1).build());
                continue;
            }
            if (string.startsWith("#")) {
                if (lastIsPlain) {
                    lastIsPlain = false;
                    class_2561 component = MarkdownParser.parse((String)plain);
                    widgets.add(new TextBuilder(component).setType(TextBuilder.TYPE.MESSAGE).setPosition(x, -40).setSize(width - 230, 20).build());
                    plain = "";
                }
                if (lastIsBlockQuote) {
                    lastIsBlockQuote = false;
                    class_2561 component = MarkdownParser.parse((String)blockquote);
                    widgets.add(new TextBuilder(component).setType(TextBuilder.TYPE.BLOCKQUOTE).setPosition(x, -40).setSize(width - 230, 20).build());
                    blockquote = "";
                }
                int j = 0;
                int scale = 0;
                int i = 0;
                while (i < string.length() && string.split("")[i].equals("#")) {
                    j = i + ((string.split("")[i] + string.split("")[i + 1]).equals("# ") ? 2 : 1);
                    scale = i++;
                }
                class_2561 component = MarkdownParser.parse(string.substring(j));
                Objects.requireNonNull(AlinLib.MINECRAFT.field_1772);
                widgets.add((class_339)new ScaledTextBox(x, -40, width - 230, 9 + 5, component, false, 1.5f - (float)scale / 6.0f));
                continue;
            }
            if (string.startsWith(">")) {
                if (lastIsPlain) {
                    lastIsPlain = false;
                    class_2561 component = MarkdownParser.parse((String)plain);
                    widgets.add(new TextBuilder(component).setType(TextBuilder.TYPE.MESSAGE).setPosition(x, -40).setSize(width - 230, 20).build());
                    plain = "";
                }
                if (!lastIsBlockQuote) {
                    lastIsBlockQuote = true;
                }
                String string3 = string.substring(string.contains("> ") ? 2 : 1);
                string3 = string3 + "\n";
                blockquote = (String)blockquote + string3;
                continue;
            }
            if (lastIsBlockQuote) {
                lastIsBlockQuote = false;
                class_2561 component = MarkdownParser.parse((String)blockquote);
                widgets.add(new TextBuilder(component).setType(TextBuilder.TYPE.BLOCKQUOTE).setPosition(x, -40).setSize(width - 230, 20).build());
                blockquote = "";
            }
            if (!lastIsPlain) {
                lastIsPlain = true;
            }
            if (string.isBlank()) continue;
            String string4 = string + "\n";
            plain = (String)plain + string4;
        }
        if (lastIsPlain) {
            widgets.add(new TextBuilder(MarkdownParser.parse((String)plain)).setType(TextBuilder.TYPE.MESSAGE).setPosition(x, -40).setSize(width - 230, 20).build());
        }
        if (lastIsBlockQuote) {
            widgets.add(new TextBuilder(MarkdownParser.parse((String)blockquote)).setType(TextBuilder.TYPE.BLOCKQUOTE).setPosition(x, -40).setSize(width - 230, 20).build());
        }
        return widgets;
    }

    public static class_2561 parse(String string) {
        String ret = MarkdownParser.getString(string);
        class_5250 component = class_2561.method_43473();
        String[] links = MarkdownParser.hehSplit(ret, "\\[(.+?)]\\((.+?)\\)");
        if (links.length >= 1) {
            String sp = ret;
            for (String link : links) {
                sp = sp.replace(link, "[\ue699]");
            }
            int u = 0;
            for (String text : sp.split("\\[\ue699]")) {
                component.method_10852((class_2561)class_2561.method_43470((String)text));
                if (u < links.length) {
                    class_5250 cLink = class_2561.method_43473().method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_36139(-7752454).method_10958((class_2558)new class_2558.class_10608(URI.create(links[u].replaceAll("\\[(.+?)]\\((.+?)\\)", "$2"))))).method_27693(links[u].replaceAll("\\[(.+?)]\\((.+?)\\)", "$1"));
                    component.method_10852((class_2561)cLink);
                }
                ++u;
            }
        } else {
            component.method_10852((class_2561)class_2561.method_43470((String)ret));
        }
        return component;
    }

    @NotNull
    private static String getString(String string) {
        String ret = string.replaceAll("\\*\\*(.+?)\\*\\*(?!\\*)", "\u00a7l$1\u00a7r").replaceAll("\\*(.+?)\\*(?!\\*)", "\u00a7o$1\u00a7r").replaceAll("__(.+?)__(?!_)", "\u00a7n$1\u00a7r").replaceAll("_(.+?)_(?!_)", "\u00a7o$1\u00a7r").replaceAll("~~(.+?)~~(?!~)", "\u00a7m$1\u00a7r").replaceAll("\\|\\|(.+?)\\|\\|(?!\\|)", "\u00a7k$1\u00a7r").replace("<br>\n", "\n").replace("\r", "").replace("<br>", "\n");
        if (ret.endsWith("\n")) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static String[] hehSplit(String content, String regex) {
        String[] shits = content.split(regex);
        boolean start = true;
        for (String shit : shits) {
            if (!shit.isEmpty() && content.contains(shit)) {
                content = content.replace(shit, start ? "" : "[\ue699]");
            }
            if (!start) continue;
            start = false;
        }
        if (content.endsWith("[\ue699]")) {
            content = content.substring(0, content.length() - 3);
        }
        return content.isEmpty() ? new String[]{} : content.split("\\[\ue699]");
    }

    public static String unparse(String string) {
        return string.replaceAll("\u00a7l(.+?)\u00a7r", "**$1**").replaceAll("\u00a7o(.+?)\u00a7r", "_$1_").replaceAll("\u00a7n(.+?)\u00a7r", "__$1__").replaceAll("\u00a7m(.+?)\u00a7r", "~~$1~~").replaceAll("\u00a7k(.+?)\u00a7r", "||$1||");
    }
}

