/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.Level;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.WebAPI;
import ru.pplh.mod.PepeLandHelper;
import ru.pplh.mod.api.PepeLandHelperAPI;

public class PepeLandAPI {
    public static String API_URL = "https://static-api.pepeland.org/";
    public static long lastReq = System.currentTimeMillis();
    public static JsonObject info;

    public static String getURI(String url) {
        return String.format("%1$s%2$s", API_URL, PepeLandAPI.uriEncode(url));
    }

    public static String uriEncode(String uri) {
        return URLEncoder.encode(uri, StandardCharsets.UTF_8);
    }

    public static JsonObject getPacksInfo(boolean modrinth) {
        try {
            if (modrinth) {
                if (PepeLandHelperAPI.apiAvailable()) {
                    return WebAPI.getJsonObject((String)PepeLandHelperAPI.getURI("resourcepacks/versions", false));
                }
                if (lastReq > System.currentTimeMillis() && info != null) {
                    return info;
                }
                try {
                    JsonArray jsonObject = WebAPI.getJsonArray((HttpRequest.Builder)HttpRequest.newBuilder().uri(URI.create("https://api.modrinth.com/v2/project/pepelandrp/version")));
                    JsonObject resp = new JsonObject();
                    for (JsonElement element : jsonObject) {
                        JsonObject info = (JsonObject)element;
                        String ver = info.get("version_number").getAsString();
                        JsonObject add = new JsonObject();
                        add.addProperty("version", ver);
                        add.addProperty("url", info.get("files").getAsJsonArray().get(0).getAsJsonObject().get("url").getAsString());
                        add.addProperty("checksum", info.get("files").getAsJsonArray().get(0).getAsJsonObject().get("hashes").getAsJsonObject().get("sha512").getAsString());
                        if (ver.contains("e")) {
                            if (resp.has("emotes")) continue;
                            resp.add("emotes", (JsonElement)add);
                            continue;
                        }
                        if (resp.has("main")) continue;
                        resp.add("main", (JsonElement)add);
                    }
                    info = resp;
                    lastReq = System.currentTimeMillis() + 120000L;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return info;
            }
            return WebAPI.getJsonObject((String)PepeLandAPI.getURI("resourcepack/latest.json"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JsonObject getPackInfo(boolean onlyEmote, boolean modrinth) {
        try {
            return PepeLandAPI.getPacksInfo(modrinth).getAsJsonObject(onlyEmote ? "emotes" : "main");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void downloadFile(String fileURL, String saveDir, String filename) throws IOException {
        URL url = new URL(fileURL);
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        int responseCode = httpConn.getResponseCode();
        String saveFilePath = saveDir + File.separator + filename;
        if (responseCode == 200) {
            int bytesRead;
            InputStream inputStream = httpConn.getInputStream();
            FileOutputStream outputStream = new FileOutputStream(saveFilePath);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            outputStream.close();
            inputStream.close();
            PepeLandHelper.LOG.log("File downloaded successfully.", new Object[]{Level.DEBUG});
        } else {
            PepeLandHelper.LOG.log("No file to download. Server replied HTTP code: " + responseCode, new Object[]{Level.ERROR});
        }
        httpConn.disconnect();
    }

    public static void downloadFile$queue(String fileURL, String saveDir, String filename, String originalChecksum, boolean modrinth, int count) {
        int position = 0;
        while (position < count) {
            PepeLandHelper.LOG.log("Count: %s", new Object[]{position});
            try {
                PepeLandAPI.downloadFile(fileURL, saveDir, filename);
                String path = AlinLib.MINECRAFT.method_1479().resolve(filename).toString();
                File file = new File(path);
                if (file.exists() && originalChecksum.contains(PepeLandHelper.toSHA(path, modrinth))) {
                    position = count;
                    continue;
                }
                ++position;
            }
            catch (Exception ex) {
                ++position;
            }
        }
    }
}

