/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.gui.screens.pages;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.gui.GuiUtils;
import ru.kelcuprum.alinlib.gui.Icons;
import ru.kelcuprum.alinlib.gui.components.ConfigureScrolWidget;
import ru.kelcuprum.alinlib.gui.components.ImageWidget;
import ru.kelcuprum.alinlib.gui.components.builder.button.ButtonBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.HorizontalRuleBuilder;
import ru.kelcuprum.alinlib.gui.components.builder.text.TextBuilder;
import ru.kelcuprum.alinlib.gui.components.text.TextBox;
import ru.pplh.mod.PepeLandHelper;
import ru.pplh.mod.api.PepeLandHelperAPI;
import ru.pplh.mod.api.components.project.Page;
import ru.pplh.mod.api.components.project.Project;
import ru.pplh.mod.gui.components.BannerWidget;
import ru.pplh.mod.gui.components.UserCard;
import ru.pplh.mod.gui.components.VerticalConfigureScrolWidget;
import ru.pplh.mod.gui.screens.message.ErrorScreen;
import ru.pplh.mod.utils.FollowManager;
import ru.pplh.mod.utils.MarkdownParser;

public class ProjectScreen
extends class_437 {
    public final Project project;
    public final class_437 parent;
    public String content = "";
    public String mainContent = "";
    Page[] pages = new Page[0];
    public String season;
    private ConfigureScrolWidget scroller;
    private List<class_339> widgets = new ArrayList<class_339>();
    private VerticalConfigureScrolWidget scroller_pages;
    private List<class_339> widgets_pages = new ArrayList<class_339>();
    private ConfigureScrolWidget panel_scroller;
    private List<class_339> panel_widgets = new ArrayList<class_339>();
    private final int maxSize = 550;
    private final int panelSize = 200;

    public ProjectScreen(class_437 screen, Project project, String season) {
        super((class_2561)class_2561.method_43471((String)(season == null || season.isEmpty() ? "pplhelper.project" : "pplhelper.project.archived")));
        this.project = project;
        this.parent = screen;
        this.season = season;
        try {
            if (season == null || season.isEmpty()) {
                this.mainContent = this.content = project.getContent();
                this.pages = project.getPages();
            } else {
                this.mainContent = this.content = PepeLandHelperAPI.getArchivedProjectContent(project.id, season);
                this.pages = new Page[0];
            }
        }
        catch (Exception ex) {
            AlinLib.MINECRAFT.method_1507((class_437)new ErrorScreen(ex, screen));
        }
    }

    protected void method_25426() {
        this.initSidebar();
        this.initContent();
    }

    public void initSidebar() {
        int x = 10;
        int y = 35;
        this.panel_widgets = new ArrayList<class_339>();
        int size = 180;
        this.panel_scroller = (ConfigureScrolWidget)this.method_37063((class_364)new ConfigureScrolWidget(x + size + 1, y, 3, this.field_22790 - y - 6, (class_2561)class_2561.method_43473(), scroller -> {
            scroller.innerHeight = 0;
            for (class_339 widget : this.panel_widgets) {
                if (widget.field_22764) {
                    if (widget instanceof ImageWidget) {
                        widget.method_25358(Math.min(widget.method_25368(), size));
                    } else {
                        widget.method_25358(size);
                    }
                    widget.method_48229(x, y + (int)((double)scroller.innerHeight - scroller.scrollAmount()));
                    scroller.innerHeight = scroller.innerHeight + (widget.method_25364() + (widget instanceof ImageWidget ? 5 : (widget instanceof BannerWidget ? 7 : 3)));
                    continue;
                }
                widget.method_46419(-widget.method_25364());
            }
            scroller.innerHeight -= 8;
        }));
        double scale = (double)size / 550.0;
        this.method_37063((class_364)new TextBuilder(this.field_22785).setPosition(10, 10).setSize(size - 20, 20).build());
        this.method_37063((class_364)new ButtonBuilder(class_5244.field_24339, s -> this.method_25419()).setSprite(Icons.EXIT).setPosition(10 + size - 20, 10).setSize(20, 20).build());
        if (this.project.banner != null && !this.project.banner.isEmpty()) {
            this.panel_widgets.add(new BannerWidget(x, -160, size, (int)(160.0 * scale), this.project.banner, String.format("project_banner_%s", this.project.id), (class_2561)class_2561.method_43473()));
        }
        this.panel_widgets.add(new TextBuilder((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.project.title).method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)))).method_27693(this.project.description.isEmpty() ? "" : "\n").method_27693(this.project.description)).setType(TextBuilder.TYPE.MESSAGE).setPosition(x, -40).setSize(size, 20).build());
        this.panel_widgets.add(new TextBuilder((class_2561)class_2561.method_43469((String)"pplhelper.project.creators", (Object[])new Object[]{this.project.creators})).setType(TextBuilder.TYPE.BLOCKQUOTE).setPosition(x, -40).setSize(size, 20).build());
        this.panel_widgets.add(new TextBuilder((class_2561)class_2561.method_43469((String)"pplhelper.project.state", (Object[])new Object[]{this.project.state == Project.State.BUILT ? class_2561.method_43471((String)"pplhelper.project.state.built") : (this.project.state == Project.State.BUILD ? class_2561.method_43471((String)"pplhelper.project.state.build") : class_2561.method_43471((String)"pplhelper.project.state.planned"))})).setType(TextBuilder.TYPE.BLOCKQUOTE).setPosition(x, -40).setSize(size, 20).build());
        class_5250 coord = class_2561.method_43473().method_10852((class_2561)class_2561.method_43469((String)"pplhelper.project.coordinates", (Object[])new Object[]{this.project.world}));
        if (this.project.coordinates$overworld != null && !this.project.coordinates$overworld.isEmpty()) {
            coord.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"pplhelper.project.coordinates.overworld")).method_27693(": ").method_27693(this.project.coordinates$overworld);
        }
        if (this.project.coordinates$nether != null && !this.project.coordinates$nether.isEmpty()) {
            coord.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"pplhelper.project.coordinates.nether")).method_27693(": ").method_27693(this.project.coordinates$nether);
        }
        if (this.project.coordinates$end != null && !this.project.coordinates$end.isEmpty()) {
            coord.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"pplhelper.project.coordinates.end")).method_27693(": ").method_27693(this.project.coordinates$end);
        }
        TextBox msg = (TextBox)new TextBuilder((class_2561)coord).setType(TextBuilder.TYPE.BLOCKQUOTE).setPosition(x, y).setSize(size, 20).build();
        this.panel_widgets.add((class_339)msg);
        this.panel_widgets.add(new ButtonBuilder((class_2561)class_2561.method_43471((String)(FollowManager.project == null || FollowManager.project.id != this.project.id ? "pplhelper.project.follow" : "pplhelper.project.unfollow")), s -> {
            if (FollowManager.project == null || FollowManager.project.id != this.project.id) {
                FollowManager.setCoordinates(this.project);
            } else {
                FollowManager.resetCoordinates();
            }
            s.builder.setTitle((class_2561)class_2561.method_43471((String)(FollowManager.project == null ? "pplhelper.project.follow" : "pplhelper.project.unfollow")));
        }).setPosition(x, y).setWidth(size).build());
        if (FabricLoader.getInstance().isModLoaded("litematica") && (this.project.schematicEnable && PepeLandHelper.playerInPPL() || PepeLandHelper.user != null && Objects.equals(PepeLandHelper.user.id, this.project.author))) {
            this.panel_widgets.add(new HorizontalRuleBuilder((class_2561)class_2561.method_43471((String)"pplhelper.project.schematic")).setPosition(x, y).build());
            if (this.project.schematicEnable && PepeLandHelper.playerInPPL()) {
                this.panel_widgets.add(new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.project.schematic.download"), s -> this.project.loadSchematic()).setPosition(x, y).setWidth(size).build());
            }
            if (PepeLandHelper.user != null && Objects.equals(PepeLandHelper.user.id, this.project.author)) {
                this.panel_widgets.add(new ButtonBuilder((class_2561)class_2561.method_43471((String)"pplhelper.project.schematic.upload_short"), s -> PepeLandHelper.confirmLinkNow(this, String.format("https://pplh.ru/projects/%s/schematic", this.project.id))).setPosition(x, y).setWidth(size).build());
            }
        }
        if ((this.season == null || this.season.isEmpty()) && this.project.author != null) {
            this.panel_widgets.add(new HorizontalRuleBuilder().setTitle((class_2561)class_2561.method_43471((String)"pplhelper.project.author")).build());
            this.panel_widgets.add((class_339)new UserCard(x, y, size, this.project.getAuthor(), true));
        }
        this.addWidgetsToScroller(this.panel_widgets, this.panel_scroller);
    }

    public void initContent() {
        this.widgets = new ArrayList<class_339>();
        this.widgets_pages = new ArrayList<class_339>();
        int size = Math.min(550, this.field_22789 - 15 - 200);
        int x = (this.field_22789 - size - 200) / 2 + 200;
        int y = 35;
        this.scroller = (ConfigureScrolWidget)this.method_37063((class_364)new ConfigureScrolWidget(x + size + 1, y, 3, this.field_22790 - y - 6, (class_2561)class_2561.method_43473(), scroller -> {
            scroller.innerHeight = 0;
            for (class_339 widget : this.widgets) {
                if (widget.field_22764) {
                    if (widget instanceof ImageWidget) {
                        widget.method_25358(Math.min(widget.method_25368(), size));
                    } else {
                        widget.method_25358(size);
                    }
                    widget.method_48229(x, y + (int)((double)scroller.innerHeight - scroller.scrollAmount()));
                    scroller.innerHeight = scroller.innerHeight + (widget.method_25364() + (widget instanceof ImageWidget ? 5 : (widget instanceof BannerWidget ? 7 : 3)));
                    continue;
                }
                widget.method_46419(-widget.method_25364());
            }
            scroller.innerHeight -= 8;
        }));
        this.scroller_pages = (VerticalConfigureScrolWidget)this.method_37063((class_364)new VerticalConfigureScrolWidget(x, y - 4, size, 3, (class_2561)class_2561.method_43473(), scroller -> {
            scroller.innerHeight = 0;
            for (class_339 widget : this.widgets_pages) {
                if (widget.field_22764) {
                    widget.method_48229(x + (int)((double)scroller.innerHeight - scroller.scrollAmount()), y - 25);
                    scroller.innerHeight += widget.method_25368() + 5;
                    continue;
                }
                widget.method_46419(-widget.method_25364());
            }
            scroller.innerHeight -= 13;
        }));
        class_5250 description = class_2561.method_43471((String)(this.mainContent.isEmpty() ? "pplhelper.project.description.empty" : "pplhelper.project.description"));
        if (this.pages.length == 0) {
            this.method_37063((class_364)new TextBuilder((class_2561)description).setPosition(x, 10).setSize(size, 20).build());
        } else {
            this.widgets_pages.add(new ButtonBuilder((class_2561)description, s -> {
                this.mainContent = this.content = this.project.getContent();
                this.rebuildContentWidgets();
            }).setWidth(12 + this.field_22787.field_1772.method_27525((class_5348)description)).build());
            for (Page page : this.pages) {
                if (page == null) continue;
                this.widgets_pages.add(new ButtonBuilder((class_2561)class_2561.method_43470((String)page.name), s -> {
                    this.content = page.getContent();
                    this.rebuildContentWidgets();
                }).setWidth(12 + this.field_22787.field_1772.method_1727(page.name)).build());
            }
        }
        this.addWidgetsToScroller(this.widgets_pages, this.scroller_pages);
        if (!this.content.isEmpty()) {
            this.widgets.addAll(MarkdownParser.parse(this.content, x, size, String.format("project_%s_", this.project.id) + "%s", this));
        } else {
            this.widgets.add((class_339)new ImageWidget(x, 35, size, 20, GuiUtils.getResourceLocation((String)"pplhelper", (String)"textures/gui/sprites/amogus.png"), 256, 32, true, (class_2561)class_2561.method_43473()));
        }
        this.addWidgetsToScroller(this.widgets);
    }

    public void rebuildContentWidgets() {
        for (class_339 widget : this.widgets) {
            this.method_37066((class_364)widget);
        }
        this.initContent();
    }

    public void addWidgetsToScroller(List<class_339> widgets) {
        this.addWidgetsToScroller(widgets, this.scroller);
    }

    public void addWidgetsToScroller(class_339 widget) {
        this.addWidgetsToScroller(widget, this.scroller);
    }

    public void addWidgetsToScroller(List<class_339> widgets, ConfigureScrolWidget scroller) {
        for (class_339 widget : widgets) {
            this.addWidgetsToScroller(widget, scroller);
        }
    }

    public void addWidgetsToScroller(class_339 widget, ConfigureScrolWidget scroller) {
        widget.method_46419(-100);
        scroller.addWidget(widget);
        this.method_25429((class_364)widget);
    }

    public void addWidgetsToScroller(List<class_339> widgets, VerticalConfigureScrolWidget scroller) {
        for (class_339 widget : widgets) {
            this.addWidgetsToScroller(widget, scroller);
        }
    }

    public void addWidgetsToScroller(class_339 widget, VerticalConfigureScrolWidget scroller) {
        widget.method_46419(-100);
        scroller.addWidget(widget);
        this.method_25429((class_364)widget);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        int size = Math.min(550, this.field_22789 - 15 - 200);
        int x = (this.field_22789 - size - 200) / 2 + 200;
        guiGraphics.method_44379(x, 10, x + size, 30);
        if (this.scroller_pages != null) {
            for (class_339 widget : this.scroller_pages.widgets) {
                widget.method_25394(guiGraphics, i, j, f);
            }
        }
        guiGraphics.method_44380();
        guiGraphics.method_44379(0, 35, this.field_22789, this.field_22790 - 5);
        if (this.scroller != null) {
            for (class_339 widget : this.scroller.widgets) {
                widget.method_25394(guiGraphics, i, j, f);
            }
        }
        if (this.panel_scroller != null) {
            for (class_339 widget : this.panel_scroller.widgets) {
                widget.method_25394(guiGraphics, i, j, f);
            }
        }
        guiGraphics.method_44380();
    }

    public boolean method_25402(double d, double e, int i) {
        int size = Math.min(550, this.field_22789 - 15 - 200);
        int x = (this.field_22789 - size - 200) / 2 + 200;
        int panelX = 10;
        int panel_size = 190;
        boolean st = true;
        class_364 selected = null;
        for (class_364 guiEventListener : this.method_25396()) {
            if (this.scroller != null && this.scroller.widgets.contains(guiEventListener)) {
                if (!(d >= (double)x) || !(d <= (double)(x + size)) || !(e >= 30.0) || !guiEventListener.method_25402(d, e, i)) continue;
                st = false;
                selected = guiEventListener;
                break;
            }
            if (this.panel_scroller != null && this.panel_scroller.widgets.contains(guiEventListener)) {
                if (!(d >= (double)panelX) || !(d <= (double)(panelX + panel_size)) || !(e >= 30.0) || !guiEventListener.method_25402(d, e, i)) continue;
                st = false;
                selected = guiEventListener;
                break;
            }
            if (this.scroller_pages != null && this.scroller_pages.widgets.contains(guiEventListener)) {
                if (!(d >= (double)x) || !(d <= (double)(x + size)) || !(e <= 30.0) || !guiEventListener.method_25402(d, e, i)) continue;
                st = false;
                selected = guiEventListener;
                break;
            }
            if (!guiEventListener.method_25402(d, e, i)) continue;
            st = false;
            selected = guiEventListener;
            break;
        }
        this.method_25395(selected);
        if (i == 0) {
            this.method_25398(true);
        }
        return st;
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        super.method_25420(guiGraphics, i, j, f);
        int size = Math.min(550, this.field_22789 - 15 - 200);
        int x = (this.field_22789 - size - 200) / 2 + 200;
        int maxY = 35;
        if (this.scroller != null) {
            for (class_339 widget : this.scroller.widgets) {
                maxY = widget.method_46427() + widget.method_25364() + 5;
            }
        }
        GuiUtils.getSelected().renderBackground(guiGraphics, x - 5, 5, x + size + 5, Math.min(this.field_22790 - 5, maxY));
        if (this.pages.length == 0) {
            GuiUtils.getSelected().renderTitleBackground(guiGraphics, x, 10, x + size, 30);
        }
        int maxPanelY = 35;
        if (this.panel_scroller != null) {
            for (class_339 widget : this.panel_scroller.widgets) {
                maxPanelY = widget.method_46427() + widget.method_25364() + 5;
            }
        }
        GuiUtils.getSelected().renderBackground(guiGraphics, 5, 5, 195, Math.min(this.field_22790 - 5, maxPanelY));
        GuiUtils.getSelected().renderTitleBackground(guiGraphics, 10, 10, 165, 30);
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean scr = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (!scr && this.panel_scroller != null && mouseX < 200.0) {
            scr = this.panel_scroller.method_25401(mouseX, mouseY, scrollX, scrollY);
        } else if (!scr && this.scroller_pages != null && mouseY < 30.0) {
            scr = this.scroller_pages.method_25401(mouseX, mouseY, scrollX, scrollY);
        } else if (!scr && this.scroller != null) {
            scr = this.scroller.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return scr;
    }

    public void method_25393() {
        if (this.scroller != null) {
            this.scroller.onScroll.accept(this.scroller);
        }
        if (this.panel_scroller != null) {
            this.panel_scroller.onScroll.accept(this.panel_scroller);
        }
        if (this.scroller_pages != null) {
            this.scroller_pages.onScroll.accept(this.scroller_pages);
        }
        super.method_25393();
    }

    public boolean method_25404(int i, int j, int k) {
        if (i == 256) {
            if (this.method_25399() != null && this.method_25399().method_25370()) {
                this.method_25399().method_25365(false);
                return true;
            }
        } else if (i == 294) {
            this.method_41843();
        }
        return super.method_25404(i, j, k);
    }
}

