/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_3518;
import ru.pplh.mod.PepeLandHelper;

public class WebUtils {
    public static HttpClient httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(2L)).build();

    public static String getString(HttpRequest request) throws IOException, InterruptedException {
        if (httpClient == null) {
            httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(10L)).build();
        }
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        return response.body();
    }

    public static String getString(HttpRequest.Builder url) throws IOException, InterruptedException {
        return WebUtils.getString(WebUtils.setupHeaders(url).build());
    }

    public static String getString(String url) throws IOException, InterruptedException {
        return WebUtils.getString(WebUtils.setupHeaders(HttpRequest.newBuilder().uri(URI.create(url))).build());
    }

    public static JsonObject getJsonObject(String url) throws IOException, InterruptedException {
        return WebUtils.getJsonObject(WebUtils.setupHeaders(HttpRequest.newBuilder().uri(URI.create(url))).header("Content-Type", "application/json").build());
    }

    public static JsonArray getJsonArray(String url) throws IOException, InterruptedException {
        return WebUtils.getJsonArray(WebUtils.setupHeaders(HttpRequest.newBuilder().uri(URI.create(url))).header("Content-Type", "application/json").build());
    }

    public static JsonObject getJsonObject(HttpRequest url) throws IOException, InterruptedException {
        return class_3518.method_15285((String)WebUtils.getString(url));
    }

    public static JsonArray getJsonArray(HttpRequest url) throws IOException, InterruptedException {
        return class_3518.method_43679((String)WebUtils.getString(url));
    }

    public static JsonObject getJsonObject(HttpRequest.Builder url) throws IOException, InterruptedException {
        return WebUtils.getJsonObject(WebUtils.setupHeaders(url).header("Content-Type", "application/json").build());
    }

    public static JsonArray getJsonArray(HttpRequest.Builder url) throws IOException, InterruptedException {
        return WebUtils.getJsonArray(WebUtils.setupHeaders(url).header("Content-Type", "application/json").build());
    }

    public static HttpRequest.Builder setupHeaders(HttpRequest.Builder builder) {
        String token = PepeLandHelper.config.getString("oauth.access_token", "");
        if (!token.isBlank()) {
            builder.header("pplh_access_token", token);
        }
        builder.header("pplh_version", ((ModContainer)FabricLoader.getInstance().getModContainer("pplhelper").get()).getMetadata().getVersion().getFriendlyString());
        return builder;
    }
}

