/*
 * Decompiled with CFR 0.152.
 */
package express.http;

import express.http.Cookie;
import express.http.SameSite;
import java.time.Instant;
import java.util.HashMap;

public final class CookieFactory {
    private CookieFactory() {
    }

    public static Cookie fromString(String cookieString) {
        Cookie cookie = null;
        char[] chars = cookieString.toCharArray();
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        boolean swap = false;
        for (char c : chars) {
            if (c == '=') {
                swap = true;
                continue;
            }
            if (c == ';') {
                cookie = CookieFactory.addField(cookie, key.toString(), val.toString());
                key.setLength(0);
                val.setLength(0);
                swap = false;
                continue;
            }
            if (swap) {
                val.append(c);
                continue;
            }
            key.append(c);
        }
        cookie = CookieFactory.addField(cookie, key.toString(), val.toString());
        return cookie;
    }

    public static HashMap<String, Cookie> fromStrings(String[] stringCookies) {
        HashMap<String, Cookie> cookies = new HashMap<String, Cookie>();
        if (stringCookies == null || stringCookies.length == 0) {
            return cookies;
        }
        for (String s : stringCookies) {
            Cookie cookie = CookieFactory.fromString(s);
            if (cookie == null) continue;
            cookies.put(cookie.getName(), cookie);
        }
        return cookies;
    }

    private static Cookie addField(Cookie cookie, String key, String value) {
        key = key.trim();
        if (cookie == null) {
            cookie = new Cookie(key, value);
        } else if (key.equalsIgnoreCase("Path")) {
            cookie.setPath(value);
        } else if (key.equalsIgnoreCase("Domain")) {
            cookie.setDomain(value);
        } else if (key.equalsIgnoreCase("Expire")) {
            cookie.setExpire(Instant.parse(value));
        } else if (key.equalsIgnoreCase("Max-Age")) {
            if (CookieFactory.isInteger(value)) {
                cookie.setMaxAge(Long.parseLong(value));
            }
        } else if (key.equalsIgnoreCase("SameSite")) {
            SameSite sameSite = value.equalsIgnoreCase("LAX") ? SameSite.LAX : SameSite.STRICT;
            cookie.setSameSite(sameSite);
        } else if (key.equalsIgnoreCase("Secure")) {
            cookie.setSecure(true);
        } else if (key.equalsIgnoreCase("HttpOnly")) {
            cookie.setHttpOnly(true);
        }
        return cookie;
    }

    private static boolean isInteger(String str) {
        char[] chars;
        for (char c : chars = str.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

