/*
 * Decompiled with CFR 0.152.
 */
package express.http.request;

import express.http.request.Request;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Authorization {
    public static final String HEADER_NAME = "Authorization";
    private final String type;
    private final String data;

    public Authorization(String authHeader) {
        String[] parts = (String[])Stream.of(authHeader.split(" ")).filter(s -> !s.isEmpty()).toArray(String[]::new);
        this.type = parts[0];
        this.data = parts[1];
    }

    public static List<Authorization> get(Request req) {
        List<String> headerVals = req.getHeader(HEADER_NAME);
        if (!headerVals.isEmpty()) {
            String authHeader = headerVals.get(0);
            return Collections.unmodifiableList(Stream.of(authHeader.split(",")).map(Authorization::new).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    @SafeVarargs
    public static boolean validate(Request req, Predicate<Authorization> ... validators) {
        for (Authorization auth : Authorization.get(req)) {
            for (Predicate<Authorization> validator : validators) {
                if (!validator.test(auth)) continue;
                return true;
            }
        }
        return false;
    }

    public static Predicate<Authorization> validator(String type, String data) {
        return auth -> auth.getType().equals(type) && auth.getData().equals(data);
    }

    public String getType() {
        return this.type;
    }

    public String getData() {
        return this.data;
    }

    public String getDataBase64Decoded() {
        return new String(Base64.getDecoder().decode(this.data));
    }
}

